/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.impl;

import com.dremio.jdbc.AlreadyClosedSqlException;
import com.dremio.jdbc.DremioConnection;
import com.dremio.jdbc.DremioConnectionConfig;
import com.dremio.jdbc.InvalidParameterSqlException;
import com.dremio.jdbc.JdbcApiSqlException;
import com.dremio.jdbc.impl.DremioExceptionMapper;
import com.dremio.jdbc.impl.DremioPreparedStatementImpl;
import com.dremio.jdbc.impl.DremioStatementImpl;
import com.dremio.jdbc.impl.DremioStatementRegistry;
import com.dremio.jdbc.impl.DriverImpl;
import com.dremio.jdbc.shaded.com.dremio.exec.client.DremioClient;
import com.dremio.jdbc.shaded.com.dremio.exec.rpc.RpcException;
import com.dremio.jdbc.shaded.com.google.common.base.Strings;
import com.dremio.jdbc.shaded.com.google.common.base.Throwables;
import com.dremio.jdbc.shaded.org.apache.arrow.memory.OutOfMemoryException;
import com.dremio.jdbc.shaded.org.apache.calcite.avatica.AvaticaConnection;
import com.dremio.jdbc.shaded.org.apache.calcite.avatica.AvaticaFactory;
import com.dremio.jdbc.shaded.org.apache.calcite.avatica.AvaticaStatement;
import com.dremio.jdbc.shaded.org.apache.calcite.avatica.Meta;
import com.dremio.jdbc.shaded.org.apache.calcite.avatica.NoSuchStatementException;
import com.dremio.jdbc.shaded.org.apache.calcite.avatica.UnregisteredDriver;
import com.dremio.jdbc.shaded.org.slf4j.Logger;
import com.dremio.jdbc.shaded.org.slf4j.LoggerFactory;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.time.DateTimeException;
import java.time.ZoneId;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.concurrent.Executor;

class DremioConnectionImpl
extends AvaticaConnection
implements DremioConnection {
    private static final Logger logger = LoggerFactory.getLogger(DremioConnection.class);
    final DremioStatementRegistry openStatementsRegistry = new DremioStatementRegistry();
    final DremioConnectionConfig config;
    private final DremioClient client;
    private final TimeZone timeZone;

    protected DremioConnectionImpl(DriverImpl driver, AvaticaFactory factory, String url, Properties info) throws SQLException {
        super(driver, factory, url, info);
        super.setTransactionIsolation(0);
        super.setAutoCommit(true);
        this.config = new DremioConnectionConfig(info);
        this.timeZone = this.getTimeZone(this.config.timeZone());
        try {
            if (this.config.isLocal()) {
                throw new UnsupportedOperationException("Dremio JDBC driver doesn't not support local mode operation");
            }
            this.client = new DremioClient(driver.getSabotConfig(), this.config.isDirect());
            String connect = this.config.getZookeeperConnectionString();
            this.client.setClientName(this.isDremioToDremio(info) ? "Dremio-to-Dremio" : "Dremio JDBC Driver");
            this.client.connect(connect, info);
        }
        catch (OutOfMemoryException e) {
            throw new SQLException("Failure creating root allocator", e);
        }
        catch (RpcException e) {
            throw DremioExceptionMapper.map(e, "Failure in connecting to Dremio: %s", e.toString());
        }
    }

    private boolean isDremioToDremio(Properties info) {
        return Boolean.parseBoolean((String)info.get("D2D"));
    }

    @Override
    protected AvaticaStatement lookupStatement(Meta.StatementHandle h2) throws SQLException {
        return super.lookupStatement(h2);
    }

    @Override
    protected Meta.ExecuteResult prepareAndExecuteInternal(AvaticaStatement statement, String sql, long maxRowCount) throws SQLException, NoSuchStatementException {
        try {
            return super.prepareAndExecuteInternal(statement, sql, maxRowCount);
        }
        catch (RuntimeException e) {
            Throwables.propagateIfInstanceOf(e.getCause(), SQLException.class);
            throw e;
        }
    }

    private void throwIfClosed() throws AlreadyClosedSqlException, SQLException {
        if (this.isClosed()) {
            throw new AlreadyClosedSqlException("Connection is already closed.");
        }
    }

    @Override
    public DremioConnectionConfig getConfig() {
        return this.config;
    }

    @Override
    public DremioClient getClient() {
        return this.client;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.throwIfClosed();
        if (!autoCommit) {
            throw new SQLFeatureNotSupportedException("Can't turn off auto-committing; transactions are not supported.  (Dremio is not transactional.)");
        }
        assert (this.getAutoCommit()) : "getAutoCommit() = " + this.getAutoCommit();
    }

    @Override
    public void commit() throws SQLException {
        this.throwIfClosed();
        if (this.getAutoCommit()) {
            throw new JdbcApiSqlException("Can't call commit() in auto-commit mode.");
        }
        throw new SQLFeatureNotSupportedException("Connection.commit() is not supported.  (Dremio is not transactional.)");
    }

    @Override
    public void rollback() throws SQLException {
        this.throwIfClosed();
        if (this.getAutoCommit()) {
            throw new JdbcApiSqlException("Can't call rollback() in auto-commit mode.");
        }
        throw new SQLFeatureNotSupportedException("Connection.rollback() is not supported.  (Dremio is not transactional.)");
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        this.throwIfClosed();
        throw new SQLFeatureNotSupportedException("Savepoints are not supported.  (Dremio is not transactional.)");
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        this.throwIfClosed();
        throw new SQLFeatureNotSupportedException("Savepoints are not supported.  (Dremio is not transactional.)");
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.throwIfClosed();
        throw new SQLFeatureNotSupportedException("Savepoints are not supported.  (Dremio is not transactional.)");
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.throwIfClosed();
        throw new SQLFeatureNotSupportedException("Savepoints are not supported.  (Dremio is not transactional.)");
    }

    private String isolationValueToString(int level) {
        switch (level) {
            case 0: {
                return "TRANSACTION_NONE";
            }
            case 1: {
                return "TRANSACTION_READ_UNCOMMITTED";
            }
            case 2: {
                return "TRANSACTION_READ_COMMITTED";
            }
            case 4: {
                return "TRANSACTION_REPEATABLE_READ";
            }
            case 8: {
                return "TRANSACTION_SERIALIZABLE";
            }
        }
        return "<Unknown transaction isolation level value " + level + ">";
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.throwIfClosed();
        switch (level) {
            case 0: {
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                throw new SQLFeatureNotSupportedException("Can't change transaction isolation level to Connection." + this.isolationValueToString(level) + " (from Connection." + this.isolationValueToString(this.getTransactionIsolation()) + ").  (Dremio is not transactional.)");
            }
            default: {
                throw new JdbcApiSqlException("Invalid transaction isolation level value " + level);
            }
        }
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws AlreadyClosedSqlException, JdbcApiSqlException, SQLFeatureNotSupportedException, SQLException {
        this.throwIfClosed();
        if (null == executor) {
            throw new InvalidParameterSqlException("Invalid (null) \"executor\" parameter to setNetworkTimeout(...)");
        }
        if (milliseconds < 0) {
            throw new InvalidParameterSqlException("Invalid (negative) \"milliseconds\" parameter to setNetworkTimeout(...) (" + milliseconds + ")");
        }
        if (0 != milliseconds) {
            throw new SQLFeatureNotSupportedException("Setting network timeout is not supported.");
        }
    }

    @Override
    public int getNetworkTimeout() throws AlreadyClosedSqlException, SQLException {
        this.throwIfClosed();
        return 0;
    }

    @Override
    public DremioStatementImpl createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.throwIfClosed();
        DremioStatementImpl statement = (DremioStatementImpl)super.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
        return statement;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.throwIfClosed();
        DremioPreparedStatementImpl statement = (DremioPreparedStatementImpl)super.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        return statement;
    }

    @Override
    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    @Override
    public AvaticaStatement createStatement() throws SQLException {
        this.throwIfClosed();
        return super.createStatement();
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.throwIfClosed();
        return super.prepareStatement(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        this.throwIfClosed();
        try {
            return super.prepareCall(sql);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        this.throwIfClosed();
        try {
            return super.nativeSQL(sql);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.throwIfClosed();
        return super.getAutoCommit();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.throwIfClosed();
        return super.getMetaData();
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.throwIfClosed();
        super.setReadOnly(readOnly);
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.throwIfClosed();
        return super.isReadOnly();
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.throwIfClosed();
        super.setCatalog(catalog);
    }

    @Override
    public synchronized String getCatalog() throws SQLException {
        this.throwIfClosed();
        String catalog = super.getCatalog();
        if (null == catalog) {
            try (ResultSet rs = this.getMetaData().getCatalogs();){
                if (rs.next()) {
                    catalog = rs.getString(1);
                    super.setCatalog(catalog);
                }
            }
        }
        return catalog;
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.throwIfClosed();
        return super.getTransactionIsolation();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.throwIfClosed();
        return super.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.throwIfClosed();
        super.clearWarnings();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.throwIfClosed();
        return super.createStatement(resultSetType, resultSetConcurrency);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.throwIfClosed();
        return super.prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.throwIfClosed();
        try {
            return super.prepareCall(sql, resultSetType, resultSetConcurrency);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        this.throwIfClosed();
        try {
            return super.getTypeMap();
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.throwIfClosed();
        try {
            super.setTypeMap(map);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.throwIfClosed();
        super.setHoldability(holdability);
    }

    @Override
    public int getHoldability() throws SQLException {
        this.throwIfClosed();
        return super.getHoldability();
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.throwIfClosed();
        try {
            return super.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.throwIfClosed();
        try {
            return super.prepareStatement(sql, autoGeneratedKeys);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.throwIfClosed();
        try {
            return super.prepareStatement(sql, columnIndexes);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.throwIfClosed();
        try {
            return super.prepareStatement(sql, columnNames);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public Clob createClob() throws SQLException {
        this.throwIfClosed();
        try {
            return super.createClob();
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public Blob createBlob() throws SQLException {
        this.throwIfClosed();
        try {
            return super.createBlob();
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public NClob createNClob() throws SQLException {
        this.throwIfClosed();
        try {
            return super.createNClob();
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        this.throwIfClosed();
        try {
            return super.createSQLXML();
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return super.isValid(timeout) && this.client.isActive();
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        try {
            this.throwIfClosed();
        }
        catch (SQLException e) {
            throw new SQLClientInfoException(e.getMessage(), null, (Throwable)e);
        }
        try {
            super.setClientInfo(name, value);
        }
        catch (UnsupportedOperationException e) {
            SQLFeatureNotSupportedException intended = new SQLFeatureNotSupportedException(e.getMessage(), e);
            throw new SQLClientInfoException(e.getMessage(), null, (Throwable)intended);
        }
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        try {
            this.throwIfClosed();
        }
        catch (SQLException e) {
            throw new SQLClientInfoException(e.getMessage(), null, (Throwable)e);
        }
        try {
            super.setClientInfo(properties);
        }
        catch (UnsupportedOperationException e) {
            SQLFeatureNotSupportedException intended = new SQLFeatureNotSupportedException(e.getMessage(), e);
            throw new SQLClientInfoException(e.getMessage(), null, (Throwable)intended);
        }
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        this.throwIfClosed();
        try {
            return super.getClientInfo(name);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.throwIfClosed();
        try {
            return super.getClientInfo();
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        this.throwIfClosed();
        try {
            return super.createArrayOf(typeName, elements);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        this.throwIfClosed();
        try {
            return super.createStruct(typeName, attributes);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.throwIfClosed();
        super.setSchema(schema);
    }

    @Override
    public String getSchema() throws SQLException {
        this.throwIfClosed();
        return super.getSchema();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.throwIfClosed();
        try {
            super.abort(executor);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    private TimeZone getTimeZone(String timeZone) {
        if (!Strings.isNullOrEmpty(timeZone)) {
            try {
                return TimeZone.getTimeZone(ZoneId.of(timeZone));
            }
            catch (DateTimeException dateTimeException) {
                // empty catch block
            }
        }
        return TimeZone.getDefault();
    }

    UnregisteredDriver getDriver() {
        return this.driver;
    }

    AvaticaFactory getFactory() {
        return this.factory;
    }

    private static void closeOrWarn(AutoCloseable autoCloseable, String message, Logger logger) {
        if (autoCloseable == null) {
            return;
        }
        try {
            autoCloseable.close();
        }
        catch (Exception e) {
            logger.warn(message, e);
        }
    }

    void cleanup() {
        this.openStatementsRegistry.close();
        DremioConnectionImpl.closeOrWarn(this.client, "Exception while closing client.", logger);
    }
}

