/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.impl;

import com.dremio.jdbc.SchemaChangeListener;
import com.dremio.jdbc.SqlTimeoutException;
import com.dremio.jdbc.impl.DremioAccessorList;
import com.dremio.jdbc.impl.DremioColumnMetaDataList;
import com.dremio.jdbc.impl.DremioConnectionImpl;
import com.dremio.jdbc.impl.DremioPreparedStatementImpl;
import com.dremio.jdbc.impl.SqlAccessorWrapper;
import com.dremio.jdbc.shaded.com.dremio.common.exceptions.UserException;
import com.dremio.jdbc.shaded.com.dremio.common.utils.protos.QueryIdHelper;
import com.dremio.jdbc.shaded.com.dremio.exec.client.DremioClient;
import com.dremio.jdbc.shaded.com.dremio.exec.exception.SchemaChangeException;
import com.dremio.jdbc.shaded.com.dremio.exec.proto.UserBitShared;
import com.dremio.jdbc.shaded.com.dremio.exec.proto.UserProtos;
import com.dremio.jdbc.shaded.com.dremio.exec.record.BatchSchema;
import com.dremio.jdbc.shaded.com.dremio.exec.record.RecordBatchLoader;
import com.dremio.jdbc.shaded.com.dremio.exec.rpc.ConnectionThrottle;
import com.dremio.jdbc.shaded.com.dremio.sabot.rpc.user.QueryDataBatch;
import com.dremio.jdbc.shaded.com.dremio.sabot.rpc.user.UserResultsListener;
import com.dremio.jdbc.shaded.com.google.common.annotations.VisibleForTesting;
import com.dremio.jdbc.shaded.com.google.common.collect.Queues;
import com.dremio.jdbc.shaded.org.apache.calcite.avatica.AvaticaStatement;
import com.dremio.jdbc.shaded.org.apache.calcite.avatica.ColumnMetaData;
import com.dremio.jdbc.shaded.org.apache.calcite.avatica.Meta;
import com.dremio.jdbc.shaded.org.apache.calcite.avatica.util.ArrayImpl;
import com.dremio.jdbc.shaded.org.apache.calcite.avatica.util.Cursor;
import com.dremio.jdbc.shaded.org.slf4j.Logger;
import com.dremio.jdbc.shaded.org.slf4j.LoggerFactory;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;

class DremioCursor
implements Cursor {
    public static final String JDBC_BATCH_QUEUE_THROTTLING_THRESHOLD = "dremio.jdbc.batch_queue_throttling_threshold";
    public static final String IS_CATALOG_NAME = "DREMIO";
    public static final QueryDataBatch END_OF_STREAM_MESSAGE = new QueryDataBatch(null, null);
    private static final Logger logger = LoggerFactory.getLogger(DremioCursor.class);
    private static final String UNKNOWN_NAME_STRING = "";
    private final DremioConnectionImpl connection;
    private final AvaticaStatement statement;
    private final Meta.Signature signature;
    private final RecordBatchLoader currentBatchHolder;
    private final ResultsListener resultsListener;
    private SchemaChangeListener changeListener;
    private final DremioAccessorList accessors = new DremioAccessorList();
    private BatchSchema schema;
    private DremioColumnMetaDataList columnMetaDataList;
    private boolean initialSchemaLoaded = false;
    private boolean afterFirstBatch = false;
    private boolean returnTrueForNextCallToNext = false;
    private boolean afterLastRow = false;
    private int currentRowNumber = -1;
    private int currentRecordNumber = -1;

    DremioCursor(DremioConnectionImpl connection, AvaticaStatement statement, Meta.Signature signature) {
        this.connection = connection;
        this.statement = statement;
        this.signature = signature;
        DremioClient client = connection.getClient();
        int batchQueueThrottlingThreshold = client.getConfig().getInt(JDBC_BATCH_QUEUE_THROTTLING_THRESHOLD);
        this.resultsListener = new ResultsListener(batchQueueThrottlingThreshold);
        this.currentBatchHolder = new RecordBatchLoader(client.getRecordAllocator());
    }

    protected int getCurrentRecordNumber() {
        return this.currentRecordNumber;
    }

    public String getQueryId() {
        if (this.resultsListener.getQueryId() != null) {
            return QueryIdHelper.getQueryId(this.resultsListener.getQueryId());
        }
        return null;
    }

    public boolean isBeforeFirst() {
        return this.currentRowNumber < 0;
    }

    public boolean isAfterLast() {
        return this.afterLastRow;
    }

    @Override
    public List<Cursor.Accessor> createAccessors(List<ColumnMetaData> types, Calendar localCalendar, ArrayImpl.Factory factory) {
        this.columnMetaDataList = (DremioColumnMetaDataList)types;
        return this.accessors;
    }

    synchronized void cleanup() {
        if (this.resultsListener.getQueryId() != null && !this.resultsListener.completed) {
            this.connection.getClient().cancelQuery(this.resultsListener.getQueryId());
        }
        this.resultsListener.close();
        this.currentBatchHolder.clear();
    }

    private void updateColumns() {
        this.accessors.generateAccessors(this, this.currentBatchHolder, this.connection.getTimeZone());
        ArrayList getObjectClasses = new ArrayList();
        for (int ax = 0; ax < this.accessors.size(); ++ax) {
            SqlAccessorWrapper accessor = this.accessors.get(ax);
            getObjectClasses.add(accessor.getObjectClass());
        }
        this.columnMetaDataList.updateColumnMetaData(IS_CATALOG_NAME, UNKNOWN_NAME_STRING, UNKNOWN_NAME_STRING, this.schema, getObjectClasses);
        if (this.changeListener != null) {
            this.changeListener.schemaChanged(this.schema);
        }
    }

    private boolean nextRowInternally() throws SQLException {
        if (this.currentRecordNumber + 1 < this.currentBatchHolder.getRecordCount()) {
            ++this.currentRecordNumber;
            return true;
        }
        try {
            boolean schemaChanged;
            QueryDataBatch qrb = this.resultsListener.getNext();
            if (this.afterFirstBatch) {
                while (qrb != null && (qrb.getHeader().getRowCount() == 0 || qrb.getData() == null)) {
                    logger.warn("Spurious batch read: {}", (Object)qrb);
                    qrb.release();
                    qrb = this.resultsListener.getNext();
                }
            }
            this.afterFirstBatch = true;
            if (qrb == null) {
                this.currentBatchHolder.clear();
                this.afterLastRow = true;
                return false;
            }
            this.currentRecordNumber = 0;
            try {
                schemaChanged = this.currentBatchHolder.load(qrb.getHeader().getDef(), qrb.getData());
            }
            finally {
                qrb.release();
            }
            this.schema = this.currentBatchHolder.getSchema();
            if (schemaChanged) {
                this.updateColumns();
            }
            if (this.returnTrueForNextCallToNext && this.currentBatchHolder.getRecordCount() == 0) {
                this.returnTrueForNextCallToNext = false;
            }
            return true;
        }
        catch (UserException e) {
            throw new SQLException(e.getMessage(), e);
        }
        catch (TimeoutException e) {
            throw new SqlTimeoutException(String.format("Cancelled after expiration of timeout of %d seconds.", this.statement.getQueryTimeout()), e);
        }
        catch (InterruptedException e) {
            throw new SQLException("Interrupted.", e);
        }
        catch (SchemaChangeException e) {
            throw new SQLException("Unexpected SchemaChangeException from RecordBatchLoader.load(...)");
        }
        catch (RuntimeException e) {
            throw new SQLException("Unexpected RuntimeException: " + e.toString(), e);
        }
    }

    void loadInitialSchema() throws SQLException {
        List<UserProtos.PreparedStatementParameterValue> values;
        UserProtos.PreparedStatement preparedStatement;
        if (this.initialSchemaLoaded) {
            throw new IllegalStateException("loadInitialSchema() called a second time");
        }
        assert (!this.afterLastRow) : "afterLastRow already true in loadInitialSchema()";
        assert (!this.afterFirstBatch) : "afterLastRow already true in loadInitialSchema()";
        assert (-1 == this.currentRecordNumber) : "currentRecordNumber not -1 (is " + this.currentRecordNumber + ") in loadInitialSchema()";
        assert (0 == this.currentBatchHolder.getRecordCount()) : "currentBatchHolder.getRecordCount() not 0 (is " + this.currentBatchHolder.getRecordCount() + " in loadInitialSchema()";
        if (this.statement instanceof DremioPreparedStatementImpl) {
            DremioPreparedStatementImpl dremioPreparedStatement = (DremioPreparedStatementImpl)this.statement;
            preparedStatement = dremioPreparedStatement.getPreparedStatementHandle();
            values = dremioPreparedStatement.getProtoParameterValues();
        } else {
            preparedStatement = null;
            values = null;
        }
        long queryTimeoutSecs = this.statement.getQueryTimeout();
        if (queryTimeoutSecs > 0L) {
            long queryEnd = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(queryTimeoutSecs);
            this.resultsListener.setShouldCompleteBefore(queryEnd);
        }
        if (preparedStatement != null) {
            this.connection.getClient().executePreparedStatement(preparedStatement.getServerHandle(), values, this.resultsListener);
        } else {
            this.connection.getClient().runQuery(UserBitShared.QueryType.SQL, this.signature.sql, (UserResultsListener)this.resultsListener);
        }
        try {
            this.resultsListener.awaitFirstMessage();
        }
        catch (TimeoutException e) {
            throw new SqlTimeoutException(String.format("Cancelled after expiration of timeout of %d seconds.", this.statement.getQueryTimeout()), e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SQLException("Interrupted", e);
        }
        this.returnTrueForNextCallToNext = true;
        this.nextRowInternally();
        this.initialSchemaLoaded = true;
    }

    @Override
    public boolean next() throws SQLException {
        if (!this.initialSchemaLoaded) {
            throw new IllegalStateException("next() called but loadInitialSchema() was not called");
        }
        assert (this.afterFirstBatch) : "afterFirstBatch still false in next()";
        if (this.afterLastRow) {
            return false;
        }
        if (this.returnTrueForNextCallToNext) {
            ++this.currentRowNumber;
            this.returnTrueForNextCallToNext = false;
            return true;
        }
        this.accessors.clearLastColumnIndexedInRow();
        boolean res = this.nextRowInternally();
        if (res) {
            ++this.currentRowNumber;
        }
        return res;
    }

    public void cancel() {
        this.close();
    }

    @Override
    public void close() {
        this.cleanup();
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.accessors.wasNull();
    }

    static class ResultsListener
    implements UserResultsListener {
        private static final Logger logger = LoggerFactory.getLogger(ResultsListener.class);
        private static final AtomicInteger INSTANCE_ID_COUNTER = new AtomicInteger(1);
        private final int instanceId;
        private final int batchQueueThrottlingThreshold;
        private volatile UserBitShared.QueryId queryId;
        private int lastReceivedBatchNumber;
        private int lastDequeuedBatchNumber;
        private volatile UserException executionFailureException;
        volatile boolean completed = false;
        private final Object throttleLock = new Object();
        private volatile ConnectionThrottle throttle;
        private volatile boolean closed = false;
        private final CountDownLatch firstMessageReceived = new CountDownLatch(1);
        final LinkedBlockingDeque<QueryDataBatch> batchQueue = Queues.newLinkedBlockingDeque();
        private final long batchQueuePollTimeoutMs;
        private long shouldCompleteBefore = Long.MAX_VALUE;

        @VisibleForTesting
        ResultsListener(int batchQueueThrottlingThreshold, long batchQueuePollTimeoutMs) {
            this.instanceId = INSTANCE_ID_COUNTER.getAndIncrement();
            this.batchQueueThrottlingThreshold = batchQueueThrottlingThreshold;
            this.batchQueuePollTimeoutMs = batchQueuePollTimeoutMs;
            logger.debug("[#{}] Query listener created.", (Object)this.instanceId);
        }

        ResultsListener(int batchQueueThrottlingThreshold) {
            this(batchQueueThrottlingThreshold, 50L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @VisibleForTesting
        boolean startThrottlingIfNot(ConnectionThrottle throttle) {
            if (throttle == null) {
                throw new IllegalStateException("New throttle cannot be null.");
            }
            Object object = this.throttleLock;
            synchronized (object) {
                if (this.throttle != null) {
                    return false;
                }
                this.throttle = throttle;
                this.throttle.setAutoRead(false);
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @VisibleForTesting
        boolean stopThrottlingIfSo() {
            Object object = this.throttleLock;
            synchronized (object) {
                if (this.throttle == null) {
                    return false;
                }
                this.throttle.setAutoRead(true);
                this.throttle = null;
                return true;
            }
        }

        public void awaitFirstMessage() throws TimeoutException, InterruptedException {
            if (this.shouldCompleteBefore == Long.MAX_VALUE) {
                this.firstMessageReceived.await();
            } else {
                long remaining = this.shouldCompleteBefore - System.currentTimeMillis();
                if (!this.firstMessageReceived.await(remaining, TimeUnit.MILLISECONDS)) {
                    throw new TimeoutException("Did not receive first message before timeout expiration.");
                }
            }
        }

        private void releaseIfFirst() {
            this.firstMessageReceived.countDown();
        }

        @Override
        public void queryIdArrived(UserBitShared.QueryId queryId) {
            logger.debug("[#{}] Received query ID: {}.", (Object)this.instanceId, (Object)QueryIdHelper.getQueryId(queryId));
            this.queryId = queryId;
        }

        @Override
        public void submissionFailed(UserException ex) {
            logger.debug("[#{}] Received query failure:", (Object)this.instanceId, (Object)ex);
            this.executionFailureException = ex;
            this.completed = true;
            this.close();
            logger.info("[#{}] Query failed:", (Object)this.instanceId, (Object)ex);
        }

        @Override
        public void dataArrived(QueryDataBatch result, ConnectionThrottle throttle) {
            ++this.lastReceivedBatchNumber;
            logger.debug("[#{}] Received query data batch #{}: {}.", this.instanceId, this.lastReceivedBatchNumber, result);
            if (this.closed) {
                result.release();
                this.completed = true;
                return;
            }
            this.batchQueue.add(result);
            if (this.batchQueue.size() > this.batchQueueThrottlingThreshold && this.startThrottlingIfNot(throttle)) {
                logger.debug("[#{}] Throttling started at queue size {}.", (Object)this.instanceId, (Object)this.batchQueue.size());
            }
            this.releaseIfFirst();
        }

        @Override
        public void queryCompleted(UserBitShared.QueryResult.QueryState state) {
            logger.debug("[#{}] Received query completion: {}.", (Object)this.instanceId, (Object)state);
            this.completed = true;
            this.batchQueue.add(END_OF_STREAM_MESSAGE);
            this.releaseIfFirst();
        }

        UserBitShared.QueryId getQueryId() {
            return this.queryId;
        }

        QueryDataBatch getNext() throws UserException, TimeoutException, InterruptedException {
            QueryDataBatch qdb;
            do {
                if (this.executionFailureException != null) {
                    logger.debug("[#{}] Dequeued query failure exception:", (Object)this.instanceId, (Object)this.executionFailureException);
                    throw this.executionFailureException;
                }
                if (this.completed && this.batchQueue.isEmpty()) {
                    return null;
                }
                long remaining = this.shouldCompleteBefore - System.currentTimeMillis();
                if (remaining < 0L) {
                    throw new TimeoutException("Query did not complete before timeout expiration");
                }
                QueryDataBatch queryDataBatch = qdb = this.completed ? this.batchQueue.poll() : this.batchQueue.poll(Math.min(remaining, this.batchQueuePollTimeoutMs), TimeUnit.MILLISECONDS);
                if (qdb != END_OF_STREAM_MESSAGE) continue;
                return null;
            } while (qdb == null);
            ++this.lastDequeuedBatchNumber;
            logger.debug("[#{}] Dequeued query data batch #{}: {}.", this.instanceId, this.lastDequeuedBatchNumber, qdb);
            if ((this.batchQueue.size() < this.batchQueueThrottlingThreshold / 2 || this.batchQueue.size() == 0) && this.stopThrottlingIfSo()) {
                logger.debug("[#{}] Throttling stopped at queue size {}.", (Object)this.instanceId, (Object)this.batchQueue.size());
            }
            return qdb;
        }

        void setShouldCompleteBefore(long shouldCompleteBefore) {
            this.shouldCompleteBefore = shouldCompleteBefore;
        }

        void close() {
            logger.debug("[#{}] Query listener closing.", (Object)this.instanceId);
            this.closed = true;
            if (this.stopThrottlingIfSo()) {
                logger.debug("[#{}] Throttling stopped at close() (at queue size {}).", (Object)this.instanceId, (Object)this.batchQueue.size());
            }
            while (!this.batchQueue.isEmpty()) {
                QueryDataBatch qdb = this.batchQueue.poll();
                if (qdb == null || qdb.getData() == null) continue;
                qdb.getData().close();
            }
            this.completed = true;
            this.batchQueue.add(END_OF_STREAM_MESSAGE);
            this.releaseIfFirst();
        }
    }
}

