/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.impl;

import com.dremio.jdbc.impl.DremioConnectionImpl;
import com.dremio.jdbc.impl.DremioDatabaseMetaDataImpl;
import com.dremio.jdbc.impl.DremioFactory;
import com.dremio.jdbc.impl.DremioPreparedStatementImpl;
import com.dremio.jdbc.impl.DremioResultSetImpl;
import com.dremio.jdbc.impl.DremioResultSetMetaDataImpl;
import com.dremio.jdbc.impl.DremioStatementImpl;
import com.dremio.jdbc.impl.DriverImpl;
import com.dremio.jdbc.shaded.com.dremio.common.exceptions.UserException;
import com.dremio.jdbc.shaded.com.dremio.exec.client.DremioClient;
import com.dremio.jdbc.shaded.com.dremio.exec.client.ServerMethod;
import com.dremio.jdbc.shaded.com.dremio.exec.proto.UserProtos;
import com.dremio.jdbc.shaded.com.dremio.exec.rpc.RpcFuture;
import com.dremio.jdbc.shaded.com.google.protobuf.ByteString;
import com.dremio.jdbc.shaded.org.apache.calcite.avatica.AvaticaConnection;
import com.dremio.jdbc.shaded.org.apache.calcite.avatica.AvaticaFactory;
import com.dremio.jdbc.shaded.org.apache.calcite.avatica.AvaticaParameter;
import com.dremio.jdbc.shaded.org.apache.calcite.avatica.AvaticaStatement;
import com.dremio.jdbc.shaded.org.apache.calcite.avatica.Helper;
import com.dremio.jdbc.shaded.org.apache.calcite.avatica.Meta;
import com.dremio.jdbc.shaded.org.apache.calcite.avatica.QueryState;
import com.dremio.jdbc.shaded.org.slf4j.Logger;
import com.dremio.jdbc.shaded.org.slf4j.LoggerFactory;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.NClob;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLTimeoutException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.TimeZone;

public class DremioJdbc41Factory
extends DremioFactory {
    private static final Logger logger = LoggerFactory.getLogger(DremioJdbc41Factory.class);

    public DremioJdbc41Factory() {
        this(4, 1);
    }

    protected DremioJdbc41Factory(int major, int minor) {
        super(major, minor);
    }

    @Override
    DremioConnectionImpl newConnection(DriverImpl driver, DremioFactory factory, String url, Properties info) throws SQLException {
        return new DremioConnectionImpl(driver, (AvaticaFactory)factory, url, info);
    }

    @Override
    public DremioDatabaseMetaDataImpl newDatabaseMetaData(AvaticaConnection connection) {
        return new DremioDatabaseMetaDataImpl(connection);
    }

    @Override
    public DremioStatementImpl newStatement(AvaticaConnection connection, Meta.StatementHandle h2, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        return new DremioStatementImpl((DremioConnectionImpl)connection, h2, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public DremioJdbc41PreparedStatement newPreparedStatement(AvaticaConnection connection, Meta.StatementHandle h2, Meta.Signature signature, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        DremioConnectionImpl dremioConnection = (DremioConnectionImpl)connection;
        DremioClient client = dremioConnection.getClient();
        if (dremioConnection.getConfig().isServerPreparedStatementDisabled() || !client.getSupportedMethods().contains((Object)ServerMethod.PREPARED_STATEMENT)) {
            return new DremioJdbc41PreparedStatement(dremioConnection, h2, signature, null, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        return this.newServerPreparedStatement(dremioConnection, h2, signature, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    private DremioJdbc41PreparedStatement newServerPreparedStatement(DremioConnectionImpl connection, Meta.StatementHandle h2, Meta.Signature signature, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        String sql = signature.sql;
        try {
            UserProtos.CreatePreparedStatementResp resp;
            RpcFuture<UserProtos.CreatePreparedStatementResp> respFuture = connection.getClient().createPreparedStatement(signature.sql);
            try {
                resp = (UserProtos.CreatePreparedStatementResp)respFuture.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new SQLException("Interrupted", e);
            }
            UserProtos.RequestStatus status = resp.getStatus();
            if (status != UserProtos.RequestStatus.OK) {
                String errMsgFromServer;
                String string = errMsgFromServer = resp.getError() != null ? resp.getError().getMessage() : "";
                if (status == UserProtos.RequestStatus.TIMEOUT) {
                    logger.error("Request timed out to create prepare statement: {}", (Object)errMsgFromServer);
                    throw new SQLTimeoutException("Failed to create prepared statement: " + errMsgFromServer);
                }
                if (status == UserProtos.RequestStatus.FAILED) {
                    logger.error("Failed to create prepared statement: {}", (Object)errMsgFromServer);
                    throw new SQLException("Failed to create prepared statement: " + String.valueOf(resp.getError()));
                }
                logger.error("Failed to create prepared statement. Unknown status: {}, Error: {}", (Object)status, (Object)errMsgFromServer);
                throw new SQLException(String.format("Failed to create prepared statement. Unknown status: %s, Error: %s", status, errMsgFromServer));
            }
            ArrayList<AvaticaParameter> parameters = new ArrayList<AvaticaParameter>();
            for (UserProtos.ResultColumnMetadata param : resp.getPreparedStatement().getParametersList()) {
                String parameterType = param.getDataType();
                if ("CHARACTER VARYING".equals(parameterType)) {
                    parameterType = "VARCHAR";
                } else if ("BINARY VARYING".equals(parameterType)) {
                    parameterType = "VARBINARY";
                }
                parameters.add(new AvaticaParameter(param.getSigned(), param.getPrecision(), param.getScale(), JDBCType.valueOf(parameterType).ordinal(), param.getDataType(), param.getDataType(), param.getColumnName()));
            }
            return new DremioJdbc41PreparedStatement(connection, h2, new Meta.Signature(signature.columns, signature.sql, parameters, signature.internalParameters, signature.cursorFactory, signature.statementType), resp.getPreparedStatement(), resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (SQLException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw Helper.INSTANCE.createException("Error while preparing statement [" + sql + "]", e);
        }
        catch (Exception e) {
            throw Helper.INSTANCE.createException("Error while preparing statement [" + sql + "]", e);
        }
    }

    @Override
    public DremioResultSetImpl newResultSet(AvaticaStatement statement, QueryState state, Meta.Signature signature, TimeZone timeZone, Meta.Frame firstFrame) throws SQLException {
        ResultSetMetaData metaData = this.newResultSetMetaData(statement, signature);
        return new DremioResultSetImpl(statement, state, signature, metaData, timeZone, firstFrame);
    }

    @Override
    public ResultSetMetaData newResultSetMetaData(AvaticaStatement statement, Meta.Signature signature) {
        return new DremioResultSetMetaDataImpl(statement, null, signature);
    }

    private static class DremioJdbc41PreparedStatement
    extends DremioPreparedStatementImpl {
        private static final String ERROR_MSG = "Parameter value has not been set properly for the index: %s";

        DremioJdbc41PreparedStatement(DremioConnectionImpl connection, Meta.StatementHandle h2, Meta.Signature signature, UserProtos.PreparedStatement pstmt, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
            super(connection, h2, signature, pstmt, resultSetType, resultSetConcurrency, resultSetHoldability);
        }

        @Override
        public void setNull(int parameterIndex, int sqlType) throws SQLException {
            this.throwIfClosed();
            super.setParamValue(parameterIndex, UserProtos.PreparedStatementParameterValue.newBuilder().setIsNullValue(true).build());
        }

        @Override
        public void setBoolean(int parameterIndex, boolean x) throws SQLException {
            this.throwIfClosed();
            if (!this.getParameter((int)parameterIndex).typeName.equals("BOOLEAN")) {
                throw UserException.validationError().message(String.format(ERROR_MSG, parameterIndex + 1)).buildSilently();
            }
            super.setParamValue(parameterIndex, UserProtos.PreparedStatementParameterValue.newBuilder().setBoolValue(x).build());
        }

        @Override
        public void setShort(int parameterIndex, short x) throws SQLException {
            this.throwIfClosed();
            switch (this.getParameter((int)parameterIndex).typeName) {
                case "NUMERIC": 
                case "BIGINT": 
                case "DECIMAL": 
                case "INTEGER": {
                    super.setParamValue(parameterIndex, UserProtos.PreparedStatementParameterValue.newBuilder().setIntValue(x).build());
                    break;
                }
                default: {
                    throw UserException.validationError().message(String.format(ERROR_MSG, parameterIndex + 1)).buildSilently();
                }
            }
        }

        @Override
        public void setInt(int parameterIndex, int x) throws SQLException {
            this.throwIfClosed();
            switch (this.getParameter((int)parameterIndex).typeName) {
                case "NUMERIC": 
                case "BIGINT": 
                case "DECIMAL": 
                case "INTEGER": {
                    super.setParamValue(parameterIndex, UserProtos.PreparedStatementParameterValue.newBuilder().setIntValue(x).build());
                    break;
                }
                default: {
                    throw UserException.validationError().message(String.format(ERROR_MSG, parameterIndex + 1)).buildSilently();
                }
            }
        }

        @Override
        public void setLong(int parameterIndex, long x) throws SQLException {
            this.throwIfClosed();
            switch (this.getParameter((int)parameterIndex).typeName) {
                case "NUMERIC": 
                case "BIGINT": 
                case "DECIMAL": {
                    super.setParamValue(parameterIndex, UserProtos.PreparedStatementParameterValue.newBuilder().setLongValue(x).build());
                    break;
                }
                default: {
                    throw UserException.validationError().message(String.format(ERROR_MSG, parameterIndex + 1)).buildSilently();
                }
            }
        }

        @Override
        public void setFloat(int parameterIndex, float x) throws SQLException {
            this.throwIfClosed();
            switch (this.getParameter((int)parameterIndex).typeName) {
                case "DOUBLE": 
                case "FLOAT": {
                    super.setParamValue(parameterIndex, UserProtos.PreparedStatementParameterValue.newBuilder().setFloatValue(x).build());
                    break;
                }
                default: {
                    throw UserException.validationError().message(String.format(ERROR_MSG, parameterIndex + 1)).buildSilently();
                }
            }
        }

        @Override
        public void setDouble(int parameterIndex, double x) throws SQLException {
            this.throwIfClosed();
            if (!this.getParameter((int)parameterIndex).typeName.equals("DOUBLE")) {
                throw UserException.validationError().message(String.format(ERROR_MSG, parameterIndex + 1)).buildSilently();
            }
            super.setParamValue(parameterIndex, UserProtos.PreparedStatementParameterValue.newBuilder().setDoubleValue(x).build());
        }

        @Override
        public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
            this.throwIfClosed();
            switch (this.getParameter((int)parameterIndex).typeName) {
                case "NUMERIC": 
                case "BIGINT": 
                case "DECIMAL": {
                    super.setParamValue(parameterIndex, UserProtos.PreparedStatementParameterValue.newBuilder().setBigDecimalValue(UserProtos.BigDecimalMsg.newBuilder().setScale(x.scale()).setPrecision(x.precision()).setValue(ByteString.copyFrom(x.unscaledValue().toByteArray())).build()).build());
                    break;
                }
                default: {
                    throw UserException.validationError().message(String.format(ERROR_MSG, parameterIndex + 1)).buildSilently();
                }
            }
        }

        @Override
        public void setString(int parameterIndex, String x) throws SQLException {
            this.throwIfClosed();
            if (!this.getParameter((int)parameterIndex).typeName.equals("CHARACTER VARYING")) {
                throw UserException.validationError().message(String.format(ERROR_MSG, parameterIndex + 1)).buildSilently();
            }
            super.setParamValue(parameterIndex, UserProtos.PreparedStatementParameterValue.newBuilder().setStringValue(x).build());
        }

        @Override
        public void setBytes(int parameterIndex, byte[] x) throws SQLException {
            this.throwIfClosed();
            if (!this.getParameter((int)parameterIndex).typeName.equals("BINARY VARYING")) {
                throw UserException.validationError().message(String.format(ERROR_MSG, parameterIndex + 1)).buildSilently();
            }
            super.setParamValue(parameterIndex, UserProtos.PreparedStatementParameterValue.newBuilder().setByteArrayValue(ByteString.copyFrom(x)).build());
        }

        @Override
        public void setDate(int parameterIndex, Date x) throws SQLException {
            this.throwIfClosed();
            if (!this.getParameter((int)parameterIndex).typeName.equals("DATE")) {
                throw UserException.validationError().message(String.format(ERROR_MSG, parameterIndex + 1)).buildSilently();
            }
            super.setParamValue(parameterIndex, UserProtos.PreparedStatementParameterValue.newBuilder().setDateValue(x.getTime()).build());
        }

        @Override
        public void setTime(int parameterIndex, Time x) throws SQLException {
            this.throwIfClosed();
            if (!this.getParameter((int)parameterIndex).typeName.equals("TIME")) {
                throw UserException.validationError().message(String.format(ERROR_MSG, parameterIndex + 1)).buildSilently();
            }
            super.setParamValue(parameterIndex, UserProtos.PreparedStatementParameterValue.newBuilder().setTimeValue(x.getTime()).build());
        }

        @Override
        public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
            this.throwIfClosed();
            if (!this.getParameter((int)parameterIndex).typeName.equals("TIMESTAMP")) {
                throw UserException.validationError().message(String.format(ERROR_MSG, parameterIndex + 1)).buildSilently();
            }
            super.setParamValue(parameterIndex, UserProtos.PreparedStatementParameterValue.newBuilder().setTimestampValue(UserProtos.TimeStamp.newBuilder().setSeconds(x.getTime()).setNanos(x.getNanos()).build()).build());
        }

        @Override
        public void setRowId(int parameterIndex, RowId x) throws SQLException {
            this.getSite(parameterIndex).setRowId(x);
        }

        @Override
        public void setNString(int parameterIndex, String value) throws SQLException {
            this.getSite(parameterIndex).setNString(value);
        }

        @Override
        public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
            this.getSite(parameterIndex).setNCharacterStream(value, length);
        }

        @Override
        public void setNClob(int parameterIndex, NClob value) throws SQLException {
            this.getSite(parameterIndex).setNClob(value);
        }

        @Override
        public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
            this.getSite(parameterIndex).setClob(reader, length);
        }

        @Override
        public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
            this.getSite(parameterIndex).setBlob(inputStream, length);
        }

        @Override
        public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
            this.getSite(parameterIndex).setNClob(reader, length);
        }

        @Override
        public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
            this.getSite(parameterIndex).setSQLXML(xmlObject);
        }

        @Override
        public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
            this.getSite(parameterIndex).setAsciiStream(x, length);
        }

        @Override
        public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
            this.getSite(parameterIndex).setBinaryStream(x, length);
        }

        @Override
        public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
            this.getSite(parameterIndex).setCharacterStream(reader, length);
        }

        @Override
        public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
            this.getSite(parameterIndex).setAsciiStream(x);
        }

        @Override
        public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
            this.getSite(parameterIndex).setBinaryStream(x);
        }

        @Override
        public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
            this.getSite(parameterIndex).setCharacterStream(reader);
        }

        @Override
        public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
            this.getSite(parameterIndex).setNCharacterStream(value);
        }

        @Override
        public void setClob(int parameterIndex, Reader reader) throws SQLException {
            this.getSite(parameterIndex).setClob(reader);
        }

        @Override
        public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
            this.getSite(parameterIndex).setBlob(inputStream);
        }

        @Override
        public void setNClob(int parameterIndex, Reader reader) throws SQLException {
            this.getSite(parameterIndex).setNClob(reader);
        }
    }
}

