/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.impl;

import com.dremio.jdbc.impl.DremioConnectionImpl;
import com.dremio.jdbc.impl.DremioMeta;
import com.dremio.jdbc.impl.DremioMetaImpl;
import com.dremio.jdbc.shaded.com.dremio.common.util.concurrent.DremioFutures;
import com.dremio.jdbc.shaded.com.dremio.exec.proto.UserBitShared;
import com.dremio.jdbc.shaded.com.dremio.exec.proto.UserProtos;
import com.dremio.jdbc.shaded.com.dremio.exec.rpc.RpcException;
import com.dremio.jdbc.shaded.com.dremio.exec.rpc.RpcFuture;
import com.dremio.jdbc.shaded.com.google.common.base.Function;
import com.dremio.jdbc.shaded.com.google.common.collect.Lists;
import com.dremio.jdbc.shaded.org.apache.calcite.avatica.AvaticaStatement;
import com.dremio.jdbc.shaded.org.apache.calcite.avatica.ColumnMetaData;
import com.dremio.jdbc.shaded.org.apache.calcite.avatica.Meta;
import com.dremio.jdbc.shaded.org.apache.calcite.avatica.MetaImpl;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

class DremioMetaServerImpl
implements DremioMeta {
    private final DremioConnectionImpl connection;
    private final String searchStringEscape;

    public DremioMetaServerImpl(DremioConnectionImpl connection) throws SQLException {
        this.connection = connection;
        this.searchStringEscape = connection.getMetaData().getSearchStringEscape();
    }

    private UserProtos.LikeFilter newLikeFilter(Meta.Pat pattern) throws SQLException {
        if (pattern == null || pattern.s == null) {
            return null;
        }
        return UserProtos.LikeFilter.newBuilder().setPattern(pattern.s).setEscape(this.searchStringEscape).build();
    }

    private Meta.Pat quote(String v) throws SQLException {
        if (v == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(v.length());
        block3: for (int index = 0; index < v.length(); ++index) {
            char c = v.charAt(index);
            switch (c) {
                case '%': 
                case '_': {
                    sb.append(this.searchStringEscape).append(c);
                    continue block3;
                }
                default: {
                    if (c == this.searchStringEscape.charAt(0)) {
                        sb.append(this.searchStringEscape);
                    }
                    sb.append(c);
                }
            }
        }
        return Meta.Pat.of(sb.toString());
    }

    @Override
    public Meta.MetaResultSet getCatalogs() throws SQLException {
        return new MetadataAdapter<MetaImpl.MetaCatalog, UserProtos.GetCatalogsResp, UserProtos.CatalogMetadata>(MetaImpl.MetaCatalog.class){

            @Override
            protected UserProtos.RequestStatus getStatus(UserProtos.GetCatalogsResp response) {
                return response.getStatus();
            }

            @Override
            protected List<UserProtos.CatalogMetadata> getResult(UserProtos.GetCatalogsResp response) {
                return response.getCatalogsList();
            }

            @Override
            protected UserBitShared.DremioPBError getError(UserProtos.GetCatalogsResp response) {
                return response.getError();
            }

            @Override
            protected MetaImpl.MetaCatalog adapt(UserProtos.CatalogMetadata protoValue) {
                return new MetaImpl.MetaCatalog(protoValue.getCatalogName());
            }
        }.getMeta(this.connection.getClient().getCatalogs(null));
    }

    @Override
    public Meta.MetaResultSet getSchemas(String catalog, Meta.Pat schemaPattern) throws SQLException {
        UserProtos.LikeFilter catalogNameFilter = this.newLikeFilter(this.quote(catalog));
        UserProtos.LikeFilter schemaNameFilter = this.newLikeFilter(schemaPattern);
        return new MetadataAdapter<MetaImpl.MetaSchema, UserProtos.GetSchemasResp, UserProtos.SchemaMetadata>(MetaImpl.MetaSchema.class){

            @Override
            protected UserProtos.RequestStatus getStatus(UserProtos.GetSchemasResp response) {
                return response.getStatus();
            }

            @Override
            protected List<UserProtos.SchemaMetadata> getResult(UserProtos.GetSchemasResp response) {
                return response.getSchemasList();
            }

            @Override
            protected UserBitShared.DremioPBError getError(UserProtos.GetSchemasResp response) {
                return response.getError();
            }

            @Override
            protected MetaImpl.MetaSchema adapt(UserProtos.SchemaMetadata value) {
                return new MetaImpl.MetaSchema(value.getCatalogName(), value.getSchemaName());
            }
        }.getMeta(this.connection.getClient().getSchemas(catalogNameFilter, schemaNameFilter));
    }

    @Override
    public Meta.MetaResultSet getTables(String catalog, Meta.Pat schemaPattern, Meta.Pat tableNamePattern, List<String> typeList) throws SQLException {
        UserProtos.LikeFilter catalogNameFilter = this.newLikeFilter(this.quote(catalog));
        UserProtos.LikeFilter schemaNameFilter = this.newLikeFilter(schemaPattern);
        UserProtos.LikeFilter tableNameFilter = this.newLikeFilter(tableNamePattern);
        return new MetadataAdapter<MetaImpl.MetaTable, UserProtos.GetTablesResp, UserProtos.TableMetadata>(MetaImpl.MetaTable.class){

            @Override
            protected UserProtos.RequestStatus getStatus(UserProtos.GetTablesResp response) {
                return response.getStatus();
            }

            @Override
            protected UserBitShared.DremioPBError getError(UserProtos.GetTablesResp response) {
                return response.getError();
            }

            @Override
            protected List<UserProtos.TableMetadata> getResult(UserProtos.GetTablesResp response) {
                return response.getTablesList();
            }

            @Override
            protected MetaImpl.MetaTable adapt(UserProtos.TableMetadata protoValue) {
                return new MetaImpl.MetaTable(protoValue.getCatalogName(), protoValue.getSchemaName(), protoValue.getTableName(), protoValue.getType());
            }
        }.getMeta(this.connection.getClient().getTables(catalogNameFilter, schemaNameFilter, tableNameFilter, typeList));
    }

    @Override
    public Meta.MetaResultSet getColumns(String catalog, Meta.Pat schemaPattern, Meta.Pat tableNamePattern, Meta.Pat columnNamePattern) throws SQLException {
        UserProtos.LikeFilter catalogNameFilter = this.newLikeFilter(this.quote(catalog));
        UserProtos.LikeFilter schemaNameFilter = this.newLikeFilter(schemaPattern);
        UserProtos.LikeFilter tableNameFilter = this.newLikeFilter(tableNamePattern);
        UserProtos.LikeFilter columnNameFilter = this.newLikeFilter(columnNamePattern);
        return new MetadataAdapter<MetaImpl.MetaColumn, UserProtos.GetColumnsResp, UserProtos.ColumnMetadata>(MetaImpl.MetaColumn.class){

            @Override
            protected UserProtos.RequestStatus getStatus(UserProtos.GetColumnsResp response) {
                return response.getStatus();
            }

            @Override
            protected UserBitShared.DremioPBError getError(UserProtos.GetColumnsResp response) {
                return response.getError();
            }

            @Override
            protected List<UserProtos.ColumnMetadata> getResult(UserProtos.GetColumnsResp response) {
                return response.getColumnsList();
            }

            private int getDataType(UserProtos.ColumnMetadata value) {
                switch (value.getDataType()) {
                    case "ARRAY": {
                        return 2003;
                    }
                    case "BIGINT": {
                        return -5;
                    }
                    case "BINARY": {
                        return -2;
                    }
                    case "BINARY LARGE OBJECT": {
                        return 2004;
                    }
                    case "BINARY VARYING": {
                        return -3;
                    }
                    case "BIT": {
                        return -7;
                    }
                    case "BOOLEAN": {
                        return 16;
                    }
                    case "CHARACTER": {
                        return 1;
                    }
                    case "CHARACTER LARGE OBJECT": {
                        return 2005;
                    }
                    case "CHARACTER VARYING": {
                        return 12;
                    }
                    case "DATALINK": {
                        return 70;
                    }
                    case "DATE": {
                        return 91;
                    }
                    case "DECIMAL": {
                        return 3;
                    }
                    case "DISTINCT": {
                        return 2001;
                    }
                    case "DOUBLE": 
                    case "DOUBLE PRECISION": {
                        return 8;
                    }
                    case "FLOAT": {
                        return 6;
                    }
                    case "INTEGER": {
                        return 4;
                    }
                    case "INTERVAL": {
                        return 1111;
                    }
                    case "JAVA_OBJECT": {
                        return 2000;
                    }
                    case "LONGNVARCHAR": {
                        return -16;
                    }
                    case "LONGVARBINARY": {
                        return -4;
                    }
                    case "LONGVARCHAR": {
                        return -1;
                    }
                    case "MAP": {
                        return 1111;
                    }
                    case "NATIONAL CHARACTER": {
                        return -15;
                    }
                    case "NATIONAL CHARACTER LARGE OBJECT": {
                        return 2011;
                    }
                    case "NATIONAL CHARACTER VARYING": {
                        return -9;
                    }
                    case "NULL": {
                        return 0;
                    }
                    case "NUMERIC": {
                        return 2;
                    }
                    case "OTHER": {
                        return 1111;
                    }
                    case "REAL": {
                        return 7;
                    }
                    case "REF": {
                        return 2006;
                    }
                    case "ROWID": {
                        return -8;
                    }
                    case "SMALLINT": {
                        return 5;
                    }
                    case "SQLXML": {
                        return 2009;
                    }
                    case "STRUCT": {
                        return 2002;
                    }
                    case "TIME": {
                        return 92;
                    }
                    case "TIMESTAMP": {
                        return 93;
                    }
                    case "TINYINT": {
                        return -6;
                    }
                }
                return 1111;
            }

            Integer getDecimalDigits(UserProtos.ColumnMetadata value) {
                switch (value.getDataType()) {
                    case "TINYINT": 
                    case "SMALLINT": 
                    case "INTEGER": 
                    case "BIGINT": 
                    case "DECIMAL": 
                    case "NUMERIC": {
                        return value.hasNumericScale() ? Integer.valueOf(value.getNumericScale()) : null;
                    }
                    case "REAL": {
                        return 7;
                    }
                    case "FLOAT": {
                        return 7;
                    }
                    case "DOUBLE": {
                        return 15;
                    }
                    case "DATE": 
                    case "TIME": 
                    case "TIMESTAMP": 
                    case "INTERVAL": {
                        return value.getDateTimePrecision();
                    }
                }
                return null;
            }

            private Integer getNumPrecRadix(UserProtos.ColumnMetadata value) {
                switch (value.getDataType()) {
                    case "TINYINT": 
                    case "SMALLINT": 
                    case "INTEGER": 
                    case "BIGINT": 
                    case "DECIMAL": 
                    case "NUMERIC": 
                    case "REAL": 
                    case "FLOAT": 
                    case "DOUBLE": {
                        return value.getNumericPrecisionRadix();
                    }
                    case "INTERVAL": {
                        return 10;
                    }
                    case "DATE": 
                    case "TIME": 
                    case "TIMESTAMP": {
                        return 10;
                    }
                }
                return null;
            }

            private int getNullable(UserProtos.ColumnMetadata value) {
                if (!value.hasIsNullable()) {
                    return 2;
                }
                return value.getIsNullable() ? 1 : 0;
            }

            private String getIsNullable(UserProtos.ColumnMetadata value) {
                if (!value.hasIsNullable()) {
                    return "";
                }
                return value.getIsNullable() ? "YES" : "NO";
            }

            private Integer getCharOctetLength(UserProtos.ColumnMetadata value) {
                if (!value.hasCharMaxLength()) {
                    return null;
                }
                switch (value.getDataType()) {
                    case "CHARACTER": 
                    case "CHARACTER LARGE OBJECT": 
                    case "CHARACTER VARYING": 
                    case "LONGVARCHAR": 
                    case "LONGNVARCHAR": 
                    case "NATIONAL CHARACTER": 
                    case "NATIONAL CHARACTER LARGE OBJECT": 
                    case "NATIONAL CHARACTER VARYING": {
                        return value.getCharOctetLength();
                    }
                }
                return null;
            }

            @Override
            protected MetaImpl.MetaColumn adapt(UserProtos.ColumnMetadata value) {
                return new MetaImpl.MetaColumn(value.getCatalogName(), value.getSchemaName(), value.getTableName(), value.getColumnName(), this.getDataType(value), value.getDataType(), value.getColumnSize(), this.getDecimalDigits(value), this.getNumPrecRadix(value), this.getNullable(value), this.getCharOctetLength(value), value.getOrdinalPosition(), this.getIsNullable(value));
            }
        }.getMeta(this.connection.getClient().getColumns(catalogNameFilter, schemaNameFilter, tableNameFilter, columnNameFilter));
    }

    private abstract class MetadataAdapter<CalciteMetaType, Response, ResponseValue> {
        private final Class<? extends CalciteMetaType> clazz;

        public MetadataAdapter(Class<? extends CalciteMetaType> clazz) {
            this.clazz = clazz;
        }

        Meta.MetaResultSet getMeta(RpcFuture<Response> future) throws SQLException {
            Response response;
            try {
                response = DremioFutures.getChecked(future, RpcException.class, RpcException::mapException);
            }
            catch (RpcException e) {
                throw new SQLException("Failure getting metadata", e);
            }
            if (this.getStatus(response) != UserProtos.RequestStatus.OK) {
                UserBitShared.DremioPBError error = this.getError(response);
                throw new SQLException("Failure getting metadata: " + error.getMessage());
            }
            try {
                List<Object> rows = Lists.transform(this.getResult(response), new Function<ResponseValue, Object>(){

                    @Override
                    public Object apply(ResponseValue input) {
                        return MetadataAdapter.this.adapt(input);
                    }
                });
                Meta.Frame frame = Meta.Frame.create(0L, true, rows);
                ColumnMetaData.StructType fieldMetaData = DremioMetaImpl.fieldMetaData(this.clazz);
                Meta.Signature signature = Meta.Signature.create(fieldMetaData.columns, "", Collections.emptyList(), Meta.CursorFactory.record(this.clazz, Arrays.asList(this.clazz.getFields()), fieldMetaData.columns.stream().map(column -> column.columnName).collect(Collectors.toList())), Meta.StatementType.SELECT);
                AvaticaStatement statement = DremioMetaServerImpl.this.connection.createStatement();
                return Meta.MetaResultSet.create(DremioMetaServerImpl.this.connection.id, statement.getId(), true, signature, frame);
            }
            catch (SQLException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SQLException("Failure while attempting to get DatabaseMetadata.", e);
            }
        }

        protected abstract UserProtos.RequestStatus getStatus(Response var1);

        protected abstract UserBitShared.DremioPBError getError(Response var1);

        protected abstract List<ResponseValue> getResult(Response var1);

        protected abstract CalciteMetaType adapt(ResponseValue var1);
    }
}

