/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.impl;

import com.dremio.jdbc.AlreadyClosedSqlException;
import com.dremio.jdbc.DremioResultSet;
import com.dremio.jdbc.ExecutionCanceledSqlException;
import com.dremio.jdbc.SchemaChangeListener;
import com.dremio.jdbc.impl.DremioConnectionImpl;
import com.dremio.jdbc.impl.DremioCursor;
import com.dremio.jdbc.shaded.com.dremio.common.SuppressForbidden;
import com.dremio.jdbc.shaded.org.apache.calcite.avatica.AvaticaResultSet;
import com.dremio.jdbc.shaded.org.apache.calcite.avatica.AvaticaSite;
import com.dremio.jdbc.shaded.org.apache.calcite.avatica.AvaticaStatement;
import com.dremio.jdbc.shaded.org.apache.calcite.avatica.ColumnMetaData;
import com.dremio.jdbc.shaded.org.apache.calcite.avatica.Meta;
import com.dremio.jdbc.shaded.org.apache.calcite.avatica.QueryState;
import com.dremio.jdbc.shaded.org.apache.calcite.avatica.util.Cursor;
import com.dremio.jdbc.shaded.org.slf4j.Logger;
import com.dremio.jdbc.shaded.org.slf4j.LoggerFactory;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.TimeZone;

class DremioResultSetImpl
extends AvaticaResultSet
implements DremioResultSet {
    private static final Logger logger = LoggerFactory.getLogger(DremioResultSetImpl.class);
    private final DremioConnectionImpl connection;
    SchemaChangeListener changeListener;
    boolean hasPendingCancelationNotification;

    DremioResultSetImpl(AvaticaStatement statement, QueryState state, Meta.Signature signature, ResultSetMetaData resultSetMetaData, TimeZone timeZone, Meta.Frame firstFrame) throws SQLException {
        super(statement, state, signature, resultSetMetaData, timeZone, firstFrame);
        this.connection = (DremioConnectionImpl)statement.getConnection();
        this.cursor = new DremioCursor(this.connection, statement, signature);
    }

    private void throwIfClosed() throws AlreadyClosedSqlException, ExecutionCanceledSqlException, SQLException {
        if (this.isClosed()) {
            if (this.cursor instanceof DremioCursor && this.hasPendingCancelationNotification) {
                this.hasPendingCancelationNotification = false;
                throw new ExecutionCanceledSqlException("SQL statement execution canceled; ResultSet now closed.");
            }
            throw new AlreadyClosedSqlException("ResultSet is already closed.");
        }
    }

    @Override
    protected void cancel() {
        if (this.cursor instanceof DremioCursor) {
            this.hasPendingCancelationNotification = true;
            ((DremioCursor)this.cursor).cancel();
        } else {
            super.cancel();
        }
    }

    @Override
    public boolean next() throws SQLException {
        this.throwIfClosed();
        if (this.cursor != null) {
            return super.next();
        }
        return false;
    }

    @Override
    public void close() {
        super.close();
    }

    @Override
    public boolean wasNull() throws SQLException {
        this.throwIfClosed();
        return super.wasNull();
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        this.throwIfClosed();
        return super.getString(columnIndex);
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        this.throwIfClosed();
        return super.getBoolean(columnIndex);
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        this.throwIfClosed();
        return super.getByte(columnIndex);
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        this.throwIfClosed();
        return super.getShort(columnIndex);
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        this.throwIfClosed();
        return super.getInt(columnIndex);
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        this.throwIfClosed();
        return super.getLong(columnIndex);
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        this.throwIfClosed();
        return super.getFloat(columnIndex);
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        this.throwIfClosed();
        return super.getDouble(columnIndex);
    }

    @Override
    @SuppressForbidden
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        this.throwIfClosed();
        return super.getBigDecimal(columnIndex, scale);
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        this.throwIfClosed();
        return super.getBytes(columnIndex);
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        this.throwIfClosed();
        return super.getDate(columnIndex);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        this.throwIfClosed();
        return super.getTime(columnIndex);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        this.throwIfClosed();
        return super.getTimestamp(columnIndex);
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        this.throwIfClosed();
        return super.getAsciiStream(columnIndex);
    }

    @Override
    @SuppressForbidden
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        this.throwIfClosed();
        return super.getUnicodeStream(columnIndex);
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        this.throwIfClosed();
        return super.getBinaryStream(columnIndex);
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        this.throwIfClosed();
        return super.getString(columnLabel);
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        this.throwIfClosed();
        return super.getBoolean(columnLabel);
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        this.throwIfClosed();
        return super.getByte(columnLabel);
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        this.throwIfClosed();
        return super.getShort(columnLabel);
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        this.throwIfClosed();
        return super.getInt(columnLabel);
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        this.throwIfClosed();
        return super.getLong(columnLabel);
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        this.throwIfClosed();
        return super.getFloat(columnLabel);
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        this.throwIfClosed();
        return super.getDouble(columnLabel);
    }

    @Override
    @SuppressForbidden
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        this.throwIfClosed();
        return super.getBigDecimal(columnLabel, scale);
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        this.throwIfClosed();
        return super.getBytes(columnLabel);
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        this.throwIfClosed();
        return super.getDate(columnLabel);
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        this.throwIfClosed();
        return super.getTime(columnLabel);
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        this.throwIfClosed();
        return super.getTimestamp(columnLabel);
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        this.throwIfClosed();
        return super.getAsciiStream(columnLabel);
    }

    @Override
    @SuppressForbidden
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        this.throwIfClosed();
        return super.getUnicodeStream(columnLabel);
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        this.throwIfClosed();
        return super.getBinaryStream(columnLabel);
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.throwIfClosed();
        return super.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.throwIfClosed();
        super.clearWarnings();
    }

    @Override
    public String getCursorName() throws SQLException {
        this.throwIfClosed();
        try {
            return super.getCursorName();
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.throwIfClosed();
        return super.getMetaData();
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        Cursor.Accessor accessor;
        this.throwIfClosed();
        try {
            accessor = (Cursor.Accessor)this.accessorList.get(columnIndex - 1);
        }
        catch (IndexOutOfBoundsException e) {
            throw new SQLException("invalid column ordinal: " + columnIndex);
        }
        ColumnMetaData metaData = (ColumnMetaData)this.columnMetaDataList.get(columnIndex - 1);
        int typeId = metaData.type.id != 6 ? metaData.type.id : 7;
        return AvaticaSite.get(accessor, typeId, this.localCalendar);
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        this.throwIfClosed();
        return super.getObject(columnLabel);
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        this.throwIfClosed();
        return super.findColumn(columnLabel);
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        this.throwIfClosed();
        return super.getCharacterStream(columnIndex);
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        this.throwIfClosed();
        return super.getCharacterStream(columnLabel);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        this.throwIfClosed();
        return super.getBigDecimal(columnIndex);
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        this.throwIfClosed();
        return super.getBigDecimal(columnLabel);
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        this.throwIfClosed();
        return super.isBeforeFirst();
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        this.throwIfClosed();
        return super.isAfterLast();
    }

    @Override
    public boolean isFirst() throws SQLException {
        this.throwIfClosed();
        return super.isFirst();
    }

    @Override
    public boolean isLast() throws SQLException {
        this.throwIfClosed();
        try {
            return super.isLast();
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.throwIfClosed();
        try {
            super.beforeFirst();
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void afterLast() throws SQLException {
        this.throwIfClosed();
        try {
            super.afterLast();
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public boolean first() throws SQLException {
        this.throwIfClosed();
        try {
            return super.first();
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public boolean last() throws SQLException {
        this.throwIfClosed();
        try {
            return super.last();
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public int getRow() throws SQLException {
        this.throwIfClosed();
        return super.getRow();
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        this.throwIfClosed();
        try {
            return super.absolute(row);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        this.throwIfClosed();
        try {
            return super.relative(rows);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public boolean previous() throws SQLException {
        this.throwIfClosed();
        try {
            return super.previous();
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.throwIfClosed();
        super.setFetchDirection(direction);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.throwIfClosed();
        return super.getFetchDirection();
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.throwIfClosed();
        super.setFetchSize(rows);
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.throwIfClosed();
        return super.getFetchSize();
    }

    @Override
    public int getType() throws SQLException {
        this.throwIfClosed();
        return super.getType();
    }

    @Override
    public int getConcurrency() throws SQLException {
        this.throwIfClosed();
        return super.getConcurrency();
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        this.throwIfClosed();
        return super.rowUpdated();
    }

    @Override
    public boolean rowInserted() throws SQLException {
        this.throwIfClosed();
        return super.rowInserted();
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        this.throwIfClosed();
        return super.rowDeleted();
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        this.throwIfClosed();
        try {
            super.updateNull(columnIndex);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        this.throwIfClosed();
        try {
            super.updateBoolean(columnIndex, x);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        this.throwIfClosed();
        try {
            super.updateByte(columnIndex, x);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        this.throwIfClosed();
        try {
            super.updateShort(columnIndex, x);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        this.throwIfClosed();
        try {
            super.updateInt(columnIndex, x);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        this.throwIfClosed();
        try {
            super.updateLong(columnIndex, x);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        this.throwIfClosed();
        try {
            super.updateFloat(columnIndex, x);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        this.throwIfClosed();
        try {
            super.updateDouble(columnIndex, x);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        this.throwIfClosed();
        try {
            super.updateBigDecimal(columnIndex, x);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        this.throwIfClosed();
        try {
            super.updateString(columnIndex, x);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        this.throwIfClosed();
        try {
            super.updateBytes(columnIndex, x);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        this.throwIfClosed();
        try {
            super.updateDate(columnIndex, x);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        this.throwIfClosed();
        try {
            super.updateTime(columnIndex, x);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        this.throwIfClosed();
        try {
            super.updateTimestamp(columnIndex, x);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.throwIfClosed();
        try {
            super.updateAsciiStream(columnIndex, x, length);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.throwIfClosed();
        try {
            super.updateBinaryStream(columnIndex, x, length);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        this.throwIfClosed();
        try {
            super.updateCharacterStream(columnIndex, x, length);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scaleOrLength) throws SQLException {
        this.throwIfClosed();
        try {
            super.updateObject(columnIndex, x, scaleOrLength);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        this.throwIfClosed();
        try {
            super.updateObject(columnIndex, x);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
        this.throwIfClosed();
        try {
            super.updateNull(columnLabel);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateBoolean(String columnLabel, boolean x) throws SQLException {
        this.throwIfClosed();
        try {
            super.updateBoolean(columnLabel, x);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateByte(String columnLabel, byte x) throws SQLException {
        this.throwIfClosed();
        try {
            super.updateByte(columnLabel, x);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateShort(String columnLabel, short x) throws SQLException {
        this.throwIfClosed();
        try {
            super.updateShort(columnLabel, x);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateInt(String columnLabel, int x) throws SQLException {
        this.throwIfClosed();
        try {
            super.updateInt(columnLabel, x);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateLong(String columnLabel, long x) throws SQLException {
        this.throwIfClosed();
        try {
            super.updateLong(columnLabel, x);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateFloat(String columnLabel, float x) throws SQLException {
        this.throwIfClosed();
        try {
            super.updateFloat(columnLabel, x);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateDouble(String columnLabel, double x) throws SQLException {
        this.throwIfClosed();
        try {
            super.updateDouble(columnLabel, x);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
        this.throwIfClosed();
        try {
            super.updateBigDecimal(columnLabel, x);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateString(String columnLabel, String x) throws SQLException {
        this.throwIfClosed();
        try {
            super.updateString(columnLabel, x);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateBytes(String columnLabel, byte[] x) throws SQLException {
        this.throwIfClosed();
        try {
            super.updateBytes(columnLabel, x);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateDate(String columnLabel, Date x) throws SQLException {
        this.throwIfClosed();
        try {
            super.updateDate(columnLabel, x);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateTime(String columnLabel, Time x) throws SQLException {
        this.throwIfClosed();
        try {
            super.updateTime(columnLabel, x);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
        this.throwIfClosed();
        try {
            super.updateTimestamp(columnLabel, x);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
        this.throwIfClosed();
        try {
            super.updateAsciiStream(columnLabel, x, length);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
        this.throwIfClosed();
        try {
            super.updateBinaryStream(columnLabel, x, length);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, int length) throws SQLException {
        this.throwIfClosed();
        try {
            super.updateCharacterStream(columnLabel, reader, length);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateObject(String columnLabel, Object x, int scaleOrLength) throws SQLException {
        this.throwIfClosed();
        try {
            super.updateObject(columnLabel, x, scaleOrLength);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateObject(String columnLabel, Object x) throws SQLException {
        this.throwIfClosed();
        try {
            super.updateObject(columnLabel, x);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void insertRow() throws SQLException {
        this.throwIfClosed();
        try {
            super.insertRow();
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateRow() throws SQLException {
        this.throwIfClosed();
        try {
            super.updateRow();
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void deleteRow() throws SQLException {
        this.throwIfClosed();
        try {
            super.deleteRow();
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void refreshRow() throws SQLException {
        this.throwIfClosed();
        try {
            super.refreshRow();
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        this.throwIfClosed();
        try {
            super.cancelRowUpdates();
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        this.throwIfClosed();
        try {
            super.moveToInsertRow();
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        this.throwIfClosed();
        try {
            super.moveToCurrentRow();
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public AvaticaStatement getStatement() throws SQLException {
        this.throwIfClosed();
        return super.getStatement();
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        this.throwIfClosed();
        return super.getObject(columnIndex, map);
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        this.throwIfClosed();
        return super.getRef(columnIndex);
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        this.throwIfClosed();
        return super.getBlob(columnIndex);
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        this.throwIfClosed();
        return super.getClob(columnIndex);
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        this.throwIfClosed();
        return super.getArray(columnIndex);
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        this.throwIfClosed();
        return super.getObject(columnLabel, map);
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        this.throwIfClosed();
        return super.getRef(columnLabel);
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        this.throwIfClosed();
        return super.getBlob(columnLabel);
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        this.throwIfClosed();
        return super.getClob(columnLabel);
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        this.throwIfClosed();
        return super.getArray(columnLabel);
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        this.throwIfClosed();
        return super.getDate(columnIndex, cal);
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        this.throwIfClosed();
        return super.getDate(columnLabel, cal);
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        this.throwIfClosed();
        return super.getTime(columnIndex, cal);
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        this.throwIfClosed();
        return super.getTime(columnLabel, cal);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        this.throwIfClosed();
        return super.getTimestamp(columnIndex, cal);
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        this.throwIfClosed();
        return super.getTimestamp(columnLabel, cal);
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        this.throwIfClosed();
        return super.getURL(columnIndex);
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        this.throwIfClosed();
        return super.getURL(columnLabel);
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        this.throwIfClosed();
        try {
            super.updateRef(columnIndex, x);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateRef(String columnLabel, Ref x) throws SQLException {
        this.throwIfClosed();
        try {
            super.updateRef(columnLabel, x);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        this.throwIfClosed();
        try {
            super.updateBlob(columnIndex, x);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateBlob(String columnLabel, Blob x) throws SQLException {
        this.throwIfClosed();
        try {
            super.updateBlob(columnLabel, x);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        this.throwIfClosed();
        try {
            super.updateClob(columnIndex, x);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateClob(String columnLabel, Clob x) throws SQLException {
        this.throwIfClosed();
        try {
            super.updateClob(columnLabel, x);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        this.throwIfClosed();
        try {
            super.updateArray(columnIndex, x);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateArray(String columnLabel, Array x) throws SQLException {
        this.throwIfClosed();
        try {
            super.updateArray(columnLabel, x);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        this.throwIfClosed();
        try {
            return super.getRowId(columnIndex);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        this.throwIfClosed();
        try {
            return super.getRowId(columnLabel);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        this.throwIfClosed();
        try {
            super.updateRowId(columnIndex, x);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        this.throwIfClosed();
        try {
            super.updateRowId(columnLabel, x);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        this.throwIfClosed();
        return super.getHoldability();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return super.isClosed();
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        this.throwIfClosed();
        try {
            super.updateNString(columnIndex, nString);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        this.throwIfClosed();
        try {
            super.updateNString(columnLabel, nString);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        this.throwIfClosed();
        try {
            super.updateNClob(columnIndex, nClob);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        this.throwIfClosed();
        try {
            super.updateNClob(columnLabel, nClob);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        this.throwIfClosed();
        return super.getNClob(columnIndex);
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        this.throwIfClosed();
        return super.getNClob(columnLabel);
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        this.throwIfClosed();
        return super.getSQLXML(columnIndex);
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        this.throwIfClosed();
        return super.getSQLXML(columnLabel);
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        this.throwIfClosed();
        try {
            super.updateSQLXML(columnIndex, xmlObject);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        this.throwIfClosed();
        try {
            super.updateSQLXML(columnLabel, xmlObject);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        this.throwIfClosed();
        return super.getNString(columnIndex);
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        this.throwIfClosed();
        return super.getNString(columnLabel);
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        this.throwIfClosed();
        return super.getNCharacterStream(columnIndex);
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        this.throwIfClosed();
        return super.getNCharacterStream(columnLabel);
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        this.throwIfClosed();
        try {
            super.updateNCharacterStream(columnIndex, x, length);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this.throwIfClosed();
        try {
            super.updateNCharacterStream(columnLabel, reader, length);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        this.throwIfClosed();
        try {
            super.updateAsciiStream(columnIndex, x, length);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        this.throwIfClosed();
        try {
            super.updateBinaryStream(columnIndex, x, length);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        this.throwIfClosed();
        try {
            super.updateCharacterStream(columnIndex, x, length);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        this.throwIfClosed();
        try {
            super.updateAsciiStream(columnLabel, x, length);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        this.throwIfClosed();
        try {
            super.updateBinaryStream(columnLabel, x, length);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this.throwIfClosed();
        try {
            super.updateCharacterStream(columnLabel, reader, length);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        this.throwIfClosed();
        try {
            super.updateBlob(columnIndex, inputStream, length);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        this.throwIfClosed();
        try {
            super.updateBlob(columnLabel, inputStream, length);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        this.throwIfClosed();
        try {
            super.updateClob(columnIndex, reader, length);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        this.throwIfClosed();
        try {
            super.updateClob(columnLabel, reader, length);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        this.throwIfClosed();
        try {
            super.updateNClob(columnIndex, reader, length);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        this.throwIfClosed();
        try {
            super.updateNClob(columnLabel, reader, length);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        this.throwIfClosed();
        try {
            super.updateNCharacterStream(columnIndex, x);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        this.throwIfClosed();
        try {
            super.updateNCharacterStream(columnLabel, reader);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        this.throwIfClosed();
        try {
            super.updateAsciiStream(columnIndex, x);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        this.throwIfClosed();
        try {
            super.updateBinaryStream(columnIndex, x);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        this.throwIfClosed();
        try {
            super.updateCharacterStream(columnIndex, x);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        this.throwIfClosed();
        try {
            super.updateAsciiStream(columnLabel, x);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        this.throwIfClosed();
        try {
            super.updateBinaryStream(columnLabel, x);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        this.throwIfClosed();
        try {
            super.updateCharacterStream(columnLabel, reader);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        this.throwIfClosed();
        try {
            super.updateBlob(columnIndex, inputStream);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        this.throwIfClosed();
        try {
            super.updateBlob(columnLabel, inputStream);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        this.throwIfClosed();
        try {
            super.updateClob(columnIndex, reader);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        this.throwIfClosed();
        try {
            super.updateClob(columnLabel, reader);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        this.throwIfClosed();
        try {
            super.updateNClob(columnIndex, reader);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        this.throwIfClosed();
        try {
            super.updateNClob(columnLabel, reader);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        this.throwIfClosed();
        return super.getObject(columnIndex, type);
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        this.throwIfClosed();
        return super.getObject(columnLabel, type);
    }

    @Override
    public String getQueryId() throws SQLException {
        this.throwIfClosed();
        if (this.cursor instanceof DremioCursor) {
            return ((DremioCursor)this.cursor).getQueryId();
        }
        return null;
    }

    @Override
    protected DremioResultSetImpl execute() throws SQLException {
        this.connection.getDriver().handler.onStatementExecute(this.statement, null);
        if (this.signature.cursorFactory != null) {
            super.execute();
        } else {
            DremioCursor cursor = new DremioCursor(this.connection, this.statement, this.signature);
            super.execute2(cursor, this.signature.columns);
            cursor.loadInitialSchema();
        }
        return this;
    }
}

