/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.impl;

import com.dremio.jdbc.AlreadyClosedSqlException;
import com.dremio.jdbc.DremioStatement;
import com.dremio.jdbc.impl.DremioConnectionImpl;
import com.dremio.jdbc.impl.DremioRemoteStatement;
import com.dremio.jdbc.shaded.org.apache.calcite.avatica.AvaticaStatement;
import com.dremio.jdbc.shaded.org.apache.calcite.avatica.Meta;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;

class DremioStatementImpl
extends AvaticaStatement
implements DremioStatement,
DremioRemoteStatement {
    private final DremioConnectionImpl connection;

    DremioStatementImpl(DremioConnectionImpl connection, Meta.StatementHandle h2, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        super(connection, h2, resultSetType, resultSetConcurrency, resultSetHoldability);
        this.connection = connection;
        connection.openStatementsRegistry.addStatement(this);
    }

    private void throwIfClosed() throws SQLException {
        if (this.isClosed()) {
            throw new AlreadyClosedSqlException("Statement is already closed.");
        }
    }

    @Override
    public DremioConnectionImpl getConnection() {
        try {
            this.throwIfClosed();
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return this.connection;
    }

    private SQLException unwrapIfExtra(SQLException superMethodException) {
        Throwable cause = superMethodException.getCause();
        SQLException result = null != cause && cause instanceof SQLException ? (SQLException)cause : superMethodException;
        return result;
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.throwIfClosed();
        try {
            return super.execute(sql);
        }
        catch (SQLException possiblyExtraWrapperException) {
            throw this.unwrapIfExtra(possiblyExtraWrapperException);
        }
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        try {
            this.throwIfClosed();
            return super.executeQuery(sql);
        }
        catch (SQLException possiblyExtraWrapperException) {
            throw this.unwrapIfExtra(possiblyExtraWrapperException);
        }
    }

    @Override
    public long executeLargeUpdate(String sql) throws SQLException {
        this.throwIfClosed();
        try {
            return super.executeLargeUpdate(sql);
        }
        catch (SQLException possiblyExtraWrapperException) {
            throw this.unwrapIfExtra(possiblyExtraWrapperException);
        }
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.throwIfClosed();
        try {
            return super.executeUpdate(sql, columnIndexes);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        this.throwIfClosed();
        try {
            return super.executeUpdate(sql, columnNames);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void cleanUp() {
        DremioConnectionImpl connection1 = this.connection;
        connection1.openStatementsRegistry.removeStatement(this);
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.throwIfClosed();
        return super.getQueryTimeout();
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.throwIfClosed();
        super.setQueryTimeout(seconds);
    }

    @Override
    public boolean isClosed() throws SQLException {
        return super.isClosed();
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        this.throwIfClosed();
        try {
            return super.getMaxFieldSize();
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.throwIfClosed();
        try {
            super.setMaxFieldSize(max);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public long getLargeMaxRows() throws SQLException {
        this.throwIfClosed();
        return super.getLargeMaxRows();
    }

    @Override
    public long getLargeUpdateCount() throws SQLException {
        this.throwIfClosed();
        return super.getLargeUpdateCount();
    }

    @Override
    public void setLargeMaxRows(long max) throws SQLException {
        this.throwIfClosed();
        super.setLargeMaxRows(max);
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.throwIfClosed();
        try {
            super.setEscapeProcessing(enable);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void cancel() throws SQLException {
        this.throwIfClosed();
        super.cancel();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.throwIfClosed();
        return super.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.throwIfClosed();
        super.clearWarnings();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.throwIfClosed();
        try {
            super.setCursorName(name);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.throwIfClosed();
        return super.getResultSet();
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.throwIfClosed();
        return super.getUpdateCount();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        this.throwIfClosed();
        try {
            return super.getMoreResults();
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.throwIfClosed();
        super.setFetchDirection(direction);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.throwIfClosed();
        return super.getFetchDirection();
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.throwIfClosed();
        super.setFetchSize(rows);
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.throwIfClosed();
        return super.getFetchSize();
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        this.throwIfClosed();
        try {
            return super.getResultSetConcurrency();
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.throwIfClosed();
        try {
            return super.getResultSetType();
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.throwIfClosed();
        try {
            super.addBatch(sql);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        this.throwIfClosed();
        try {
            super.clearBatch();
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.throwIfClosed();
        try {
            return super.executeBatch();
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        this.throwIfClosed();
        try {
            return super.getMoreResults(current);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        this.throwIfClosed();
        try {
            return super.getGeneratedKeys();
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.throwIfClosed();
        try {
            return super.executeUpdate(sql, autoGeneratedKeys);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        this.throwIfClosed();
        try {
            return super.execute(sql, autoGeneratedKeys);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        this.throwIfClosed();
        try {
            return super.execute(sql, columnIndexes);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        this.throwIfClosed();
        try {
            return super.execute(sql, columnNames);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        this.throwIfClosed();
        try {
            return super.getResultSetHoldability();
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.throwIfClosed();
        try {
            super.setPoolable(poolable);
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public boolean isPoolable() throws SQLException {
        this.throwIfClosed();
        try {
            return super.isPoolable();
        }
        catch (UnsupportedOperationException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e);
        }
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.throwIfClosed();
        super.closeOnCompletion();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        this.throwIfClosed();
        return super.isCloseOnCompletion();
    }
}

