/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.impl;

import com.dremio.jdbc.shaded.org.slf4j.Logger;
import com.dremio.jdbc.shaded.org.slf4j.LoggerFactory;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Map;

class DremioStatementRegistry {
    private static final Logger logger = LoggerFactory.getLogger(DremioStatementRegistry.class);
    private final Map<Statement, Object> openStatements = new IdentityHashMap<Statement, Object>();

    DremioStatementRegistry() {
    }

    void addStatement(Statement statement) {
        logger.debug("Adding to open-statements registry: " + String.valueOf(statement));
        this.openStatements.put(statement, statement);
    }

    void removeStatement(Statement statement) {
        logger.debug("Removing from open-statements registry: " + String.valueOf(statement));
        this.openStatements.remove(statement);
    }

    void close() {
        ArrayList<Statement> copiedList = new ArrayList<Statement>(this.openStatements.keySet());
        for (Statement statement : copiedList) {
            try {
                logger.debug("Auto-closing (via open-statements registry): " + String.valueOf(statement));
                statement.close();
            }
            catch (SQLException e) {
                logger.error("Error auto-closing statement " + String.valueOf(statement) + ": " + String.valueOf(e), e);
            }
        }
        this.openStatements.clear();
    }
}

