/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.proxy;

import com.dremio.jdbc.proxy.InvocationReporter;
import com.dremio.jdbc.proxy.TracingInvocationHandler;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

class ProxiesManager {
    private final InvocationReporter reporter;
    private Map<ProxyKey<?>, Object> proxiedsToProxiesMap = new HashMap();

    public ProxiesManager(InvocationReporter reporter) {
        this.reporter = reporter;
    }

    public <INTF> INTF getProxyInstanceForOriginal(INTF originalInstance, Class<INTF> declaredType) {
        ProxyKey<INTF> key = new ProxyKey<INTF>(declaredType, originalInstance);
        Object proxy = this.proxiedsToProxiesMap.computeIfAbsent(key, this::newProxyInstance);
        return (INTF)proxy;
    }

    private final <INTF> INTF newProxyInstance(ProxyKey<INTF> proxyKey) {
        Class declaredType = proxyKey.declaredType;
        TracingInvocationHandler callHandler = new TracingInvocationHandler(this, this.reporter, proxyKey.originalInstance, declaredType);
        try {
            Object proxyInstance = Proxy.newProxyInstance(declaredType.getClassLoader(), new Class[]{declaredType}, callHandler);
            return (INTF)proxyInstance;
        }
        catch (IllegalArgumentException | SecurityException e) {
            throw new RuntimeException("Error creating proxy for " + String.valueOf(declaredType) + ": " + String.valueOf(e), e);
        }
    }

    private static final class ProxyKey<INTF> {
        private final Class<INTF> declaredType;
        private final INTF originalInstance;

        private ProxyKey(Class<INTF> declaredType, INTF originalInstance) {
            this.declaredType = declaredType;
            this.originalInstance = originalInstance;
        }

        public int hashCode() {
            return this.declaredType.hashCode() + 31 * System.identityHashCode(this.originalInstance);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ProxyKey)) {
                return false;
            }
            ProxyKey that = (ProxyKey)obj;
            return Objects.equals(this.declaredType, that.declaredType) && this.originalInstance == that.originalInstance;
        }
    }
}

