/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.proxy;

import com.dremio.jdbc.proxy.InvocationReporter;
import com.dremio.jdbc.proxy.ProxiesManager;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

class TracingInvocationHandler<INTF>
implements InvocationHandler {
    private final ProxiesManager proxiesManager;
    private final InvocationReporter callReporter;
    private final INTF proxiedObject;
    private final Class<?> proxiedInterface;

    TracingInvocationHandler(ProxiesManager proxiesManager, InvocationReporter reporter, INTF proxiedObject, Class<INTF> proxiedInterface) {
        this.proxiesManager = proxiesManager;
        this.callReporter = reporter;
        this.proxiedObject = proxiedObject;
        this.proxiedInterface = proxiedInterface;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object netReturnedResult;
        Object rawReturnedResult;
        this.callReporter.methodCalled(this.proxiedObject, this.proxiedInterface, method, args);
        try {
            Class<?> methodReturnType;
            rawReturnedResult = method.invoke(this.proxiedObject, args);
            netReturnedResult = null == rawReturnedResult ? null : (!(methodReturnType = method.getReturnType()).isInterface() ? rawReturnedResult : this.getProxyInstance(rawReturnedResult, methodReturnType));
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException("Unexpected/unhandled error calling proxied method: " + String.valueOf(e), e);
        }
        catch (InvocationTargetException e) {
            Throwable thrownResult = e.getCause();
            this.callReporter.methodThrew(this.proxiedObject, this.proxiedInterface, method, args, thrownResult);
            throw thrownResult;
        }
        this.callReporter.methodReturned(this.proxiedObject, this.proxiedInterface, method, args, rawReturnedResult);
        return netReturnedResult;
    }

    private <T> T getProxyInstance(Object originalInstance, Class<T> declaredType) {
        assert (declaredType.isInstance(originalInstance)) : "toBeProxied is of class (" + originalInstance.getClass().getName() + ") that doesn't implement specified interface " + declaredType.getName();
        return (T)this.proxiesManager.getProxyInstanceForOriginal(originalInstance, declaredType);
    }
}

