/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.carrotsearch.hppc;

import com.dremio.jdbc.shaded.com.carrotsearch.hppc.ObjectCollection;
import com.dremio.jdbc.shaded.com.carrotsearch.hppc.ObjectLookupContainer;
import com.dremio.jdbc.shaded.com.carrotsearch.hppc.cursors.ObjectCursor;
import com.dremio.jdbc.shaded.com.carrotsearch.hppc.predicates.ObjectPredicate;
import java.lang.reflect.Array;
import java.util.Arrays;

abstract class AbstractObjectCollection<KType>
implements ObjectCollection<KType> {
    AbstractObjectCollection() {
    }

    @Override
    public int removeAll(ObjectLookupContainer<? super KType> c) {
        return this.removeAll(c::contains);
    }

    @Override
    public int retainAll(ObjectLookupContainer<? super KType> c) {
        return this.removeAll((? super KType k) -> !c.contains(k));
    }

    @Override
    public int retainAll(ObjectPredicate<? super KType> predicate) {
        return this.removeAll((? super KType value) -> !predicate.apply(value));
    }

    @Override
    public Object[] toArray() {
        Object[] array = new Object[this.size()];
        int i = 0;
        for (ObjectCursor c : this) {
            array[i++] = c.value;
        }
        return array;
    }

    @Override
    public <T> T[] toArray(Class<T> componentClass) {
        int size = this.size();
        Object[] array = (Object[])Array.newInstance(componentClass, size);
        int i = 0;
        for (ObjectCursor c : this) {
            array[i++] = c.value;
        }
        return array;
    }

    public String toString() {
        return Arrays.toString(this.toArray());
    }

    protected boolean equals(Object v1, Object v2) {
        return v1 == v2 || v1 != null && v1.equals(v2);
    }
}

