/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.carrotsearch.hppc;

import com.dremio.jdbc.shaded.com.carrotsearch.hppc.AbstractCharCollection;
import com.dremio.jdbc.shaded.com.carrotsearch.hppc.AbstractIterator;
import com.dremio.jdbc.shaded.com.carrotsearch.hppc.AbstractObjectCollection;
import com.dremio.jdbc.shaded.com.carrotsearch.hppc.Accountable;
import com.dremio.jdbc.shaded.com.carrotsearch.hppc.BitMixer;
import com.dremio.jdbc.shaded.com.carrotsearch.hppc.BufferAllocationException;
import com.dremio.jdbc.shaded.com.carrotsearch.hppc.CharBufferVisualizer;
import com.dremio.jdbc.shaded.com.carrotsearch.hppc.CharContainer;
import com.dremio.jdbc.shaded.com.carrotsearch.hppc.CharLookupContainer;
import com.dremio.jdbc.shaded.com.carrotsearch.hppc.CharObjectAssociativeContainer;
import com.dremio.jdbc.shaded.com.carrotsearch.hppc.CharObjectMap;
import com.dremio.jdbc.shaded.com.carrotsearch.hppc.HashContainers;
import com.dremio.jdbc.shaded.com.carrotsearch.hppc.ObjectCollection;
import com.dremio.jdbc.shaded.com.carrotsearch.hppc.Preallocable;
import com.dremio.jdbc.shaded.com.carrotsearch.hppc.RamUsageEstimator;
import com.dremio.jdbc.shaded.com.carrotsearch.hppc.cursors.CharCursor;
import com.dremio.jdbc.shaded.com.carrotsearch.hppc.cursors.CharObjectCursor;
import com.dremio.jdbc.shaded.com.carrotsearch.hppc.cursors.ObjectCursor;
import com.dremio.jdbc.shaded.com.carrotsearch.hppc.predicates.CharObjectPredicate;
import com.dremio.jdbc.shaded.com.carrotsearch.hppc.predicates.CharPredicate;
import com.dremio.jdbc.shaded.com.carrotsearch.hppc.predicates.ObjectPredicate;
import com.dremio.jdbc.shaded.com.carrotsearch.hppc.procedures.CharObjectProcedure;
import com.dremio.jdbc.shaded.com.carrotsearch.hppc.procedures.CharProcedure;
import com.dremio.jdbc.shaded.com.carrotsearch.hppc.procedures.ObjectProcedure;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;

public class CharObjectHashMap<VType>
implements CharObjectMap<VType>,
Preallocable,
Cloneable,
Accountable {
    public char[] keys;
    public Object[] values;
    protected int assigned;
    protected int mask;
    protected int resizeAt;
    protected boolean hasEmptyKey;
    protected double loadFactor;
    protected int iterationSeed;

    public CharObjectHashMap() {
        this(4);
    }

    public CharObjectHashMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public CharObjectHashMap(int expectedElements, double loadFactor) {
        this.loadFactor = this.verifyLoadFactor(loadFactor);
        this.iterationSeed = HashContainers.nextIterationSeed();
        this.ensureCapacity(expectedElements);
    }

    public CharObjectHashMap(CharObjectAssociativeContainer<? extends VType> container) {
        this(container.size());
        this.putAll(container);
    }

    @Override
    public VType put(char key, VType value) {
        char existing;
        assert (this.assigned < this.mask + 1);
        int mask = this.mask;
        if (key == '\u0000') {
            Object previousValue = this.hasEmptyKey ? this.values[mask + 1] : null;
            this.hasEmptyKey = true;
            this.values[mask + 1] = value;
            return (VType)previousValue;
        }
        char[] keys = this.keys;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != '\u0000') {
            if (key == existing) {
                Object previousValue = this.values[slot];
                this.values[slot] = value;
                return (VType)previousValue;
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(slot, key, value);
        } else {
            keys[slot] = key;
            this.values[slot] = value;
        }
        ++this.assigned;
        return null;
    }

    @Override
    public int putAll(CharObjectAssociativeContainer<? extends VType> container) {
        int count = this.size();
        for (CharObjectCursor<VType> charObjectCursor : container) {
            this.put(charObjectCursor.key, charObjectCursor.value);
        }
        return this.size() - count;
    }

    @Override
    public int putAll(Iterable<? extends CharObjectCursor<? extends VType>> iterable) {
        int count = this.size();
        for (CharObjectCursor<VType> charObjectCursor : iterable) {
            this.put(charObjectCursor.key, charObjectCursor.value);
        }
        return this.size() - count;
    }

    @Override
    public VType remove(char key) {
        char existing;
        int mask = this.mask;
        if (key == '\u0000') {
            if (!this.hasEmptyKey) {
                return null;
            }
            this.hasEmptyKey = false;
            Object previousValue = this.values[mask + 1];
            this.values[mask + 1] = null;
            return (VType)previousValue;
        }
        char[] keys = this.keys;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != '\u0000') {
            if (key == existing) {
                Object previousValue = this.values[slot];
                this.shiftConflictingKeys(slot);
                return (VType)previousValue;
            }
            slot = slot + 1 & mask;
        }
        return null;
    }

    @Override
    public int removeAll(CharContainer other) {
        int before = this.size();
        if (other.size() >= this.size() && other instanceof CharLookupContainer) {
            if (this.hasEmptyKey && other.contains('\u0000')) {
                this.hasEmptyKey = false;
                this.values[this.mask + 1] = null;
            }
            char[] keys = this.keys;
            int slot = 0;
            int max = this.mask;
            while (slot <= max) {
                char existing = keys[slot];
                if (existing != '\u0000' && other.contains(existing)) {
                    this.shiftConflictingKeys(slot);
                    continue;
                }
                ++slot;
            }
        } else {
            for (CharCursor c : other) {
                this.remove(c.value);
            }
        }
        return before - this.size();
    }

    @Override
    public int removeAll(CharObjectPredicate<? super VType> predicate) {
        int before = this.size();
        int mask = this.mask;
        if (this.hasEmptyKey && predicate.apply('\u0000', this.values[mask + 1])) {
            this.hasEmptyKey = false;
            this.values[mask + 1] = null;
        }
        char[] keys = this.keys;
        Object[] values = this.values;
        int slot = 0;
        while (slot <= mask) {
            char existing = keys[slot];
            if (existing != '\u0000' && predicate.apply(existing, values[slot])) {
                this.shiftConflictingKeys(slot);
                continue;
            }
            ++slot;
        }
        return before - this.size();
    }

    @Override
    public int removeAll(CharPredicate predicate) {
        int before = this.size();
        if (this.hasEmptyKey && predicate.apply('\u0000')) {
            this.hasEmptyKey = false;
            this.values[this.mask + 1] = null;
        }
        char[] keys = this.keys;
        int slot = 0;
        int max = this.mask;
        while (slot <= max) {
            char existing = keys[slot];
            if (existing != '\u0000' && predicate.apply(existing)) {
                this.shiftConflictingKeys(slot);
                continue;
            }
            ++slot;
        }
        return before - this.size();
    }

    @Override
    public VType get(char key) {
        char existing;
        if (key == '\u0000') {
            return (VType)(this.hasEmptyKey ? this.values[this.mask + 1] : null);
        }
        char[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != '\u0000') {
            if (key == existing) {
                return (VType)this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return null;
    }

    @Override
    public VType getOrDefault(char key, VType defaultValue) {
        char existing;
        if (key == '\u0000') {
            return (VType)(this.hasEmptyKey ? this.values[this.mask + 1] : defaultValue);
        }
        char[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != '\u0000') {
            if (key == existing) {
                return (VType)this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return defaultValue;
    }

    @Override
    public boolean containsKey(char key) {
        char existing;
        if (key == '\u0000') {
            return this.hasEmptyKey;
        }
        char[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != '\u0000') {
            if (key == existing) {
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    @Override
    public int indexOf(char key) {
        char existing;
        int mask = this.mask;
        if (key == '\u0000') {
            return this.hasEmptyKey ? mask + 1 : ~(mask + 1);
        }
        char[] keys = this.keys;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != '\u0000') {
            if (key == existing) {
                return slot;
            }
            slot = slot + 1 & mask;
        }
        return ~slot;
    }

    @Override
    public boolean indexExists(int index) {
        assert (index < 0 || index >= 0 && index <= this.mask || index == this.mask + 1 && this.hasEmptyKey);
        return index >= 0;
    }

    @Override
    public VType indexGet(int index) {
        assert (index >= 0) : "The index must point at an existing key.";
        assert (index <= this.mask || index == this.mask + 1 && this.hasEmptyKey);
        return (VType)this.values[index];
    }

    @Override
    public VType indexReplace(int index, VType newValue) {
        assert (index >= 0) : "The index must point at an existing key.";
        assert (index <= this.mask || index == this.mask + 1 && this.hasEmptyKey);
        Object previousValue = this.values[index];
        this.values[index] = newValue;
        return (VType)previousValue;
    }

    @Override
    public void indexInsert(int index, char key, VType value) {
        assert (index < 0) : "The index must not point at an existing key.";
        index ^= 0xFFFFFFFF;
        if (key == '\u0000') {
            assert (index == this.mask + 1);
            this.values[index] = value;
            this.hasEmptyKey = true;
        } else {
            assert (this.keys[index] == '\u0000');
            if (this.assigned == this.resizeAt) {
                this.allocateThenInsertThenRehash(index, key, value);
            } else {
                this.keys[index] = key;
                this.values[index] = value;
            }
            ++this.assigned;
        }
    }

    @Override
    public VType indexRemove(int index) {
        assert (index >= 0) : "The index must point at an existing key.";
        assert (index <= this.mask || index == this.mask + 1 && this.hasEmptyKey);
        Object previousValue = this.values[index];
        if (index > this.mask) {
            assert (index == this.mask + 1);
            this.hasEmptyKey = false;
            this.values[index] = null;
        } else {
            this.shiftConflictingKeys(index);
        }
        return (VType)previousValue;
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        Arrays.fill(this.keys, '\u0000');
        Arrays.fill(this.values, null);
    }

    @Override
    public void release() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        this.keys = null;
        this.values = null;
        this.ensureCapacity(4);
    }

    @Override
    public int size() {
        return this.assigned + (this.hasEmptyKey ? 1 : 0);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int hashCode() {
        int h2 = this.hasEmptyKey ? -559038737 : 0;
        for (CharObjectCursor<VType> c : this) {
            h2 += BitMixer.mix(c.key) + BitMixer.mix(c.value);
        }
        return h2;
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj != null && this.getClass() == obj.getClass() && this.equalElements((CharObjectHashMap)this.getClass().cast(obj));
    }

    protected boolean equalElements(CharObjectHashMap<?> other) {
        if (other.size() != this.size()) {
            return false;
        }
        for (CharObjectCursor<?> c : other) {
            char key = c.key;
            if (this.containsKey(key) && Objects.equals(c.value, this.get(key))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void ensureCapacity(int expectedElements) {
        if (expectedElements > this.resizeAt || this.keys == null) {
            char[] prevKeys = this.keys;
            Object[] prevValues = this.values;
            this.allocateBuffers(HashContainers.minBufferSize(expectedElements, this.loadFactor));
            if (prevKeys != null && !this.isEmpty()) {
                this.rehash(prevKeys, prevValues);
            }
        }
    }

    @Override
    public long ramBytesAllocated() {
        return (long)(RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 16 + 8 + 1) + RamUsageEstimator.shallowSizeOfArray(this.keys) + RamUsageEstimator.shallowSizeOfArray(this.values);
    }

    @Override
    public long ramBytesUsed() {
        return (long)(RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 16 + 8 + 1) + RamUsageEstimator.shallowUsedSizeOfArray(this.keys, this.size()) + RamUsageEstimator.shallowUsedSizeOfArray(this.values, this.size());
    }

    protected int nextIterationSeed() {
        this.iterationSeed = BitMixer.mixPhi(this.iterationSeed);
        return this.iterationSeed;
    }

    @Override
    public Iterator<CharObjectCursor<VType>> iterator() {
        return new EntryIterator();
    }

    @Override
    public <T extends CharObjectProcedure<? super VType>> T forEach(T procedure) {
        char[] keys = this.keys;
        Object[] values = this.values;
        if (this.hasEmptyKey) {
            procedure.apply('\u0000', (Object)values[this.mask + 1]);
        }
        int seed = this.nextIterationSeed();
        int inc = HashContainers.iterationIncrement(seed);
        int mask = this.mask;
        int slot = seed & mask;
        for (int i = 0; i <= mask; ++i) {
            if (keys[slot] != '\u0000') {
                procedure.apply(keys[slot], (Object)values[slot]);
            }
            slot = slot + inc & mask;
        }
        return procedure;
    }

    @Override
    public <T extends CharObjectPredicate<? super VType>> T forEach(T predicate) {
        char[] keys = this.keys;
        Object[] values = this.values;
        if (this.hasEmptyKey && !predicate.apply('\u0000', (Object)values[this.mask + 1])) {
            return predicate;
        }
        int seed = this.nextIterationSeed();
        int inc = HashContainers.iterationIncrement(seed);
        int mask = this.mask;
        int slot = seed & mask;
        for (int i = 0; i <= mask && (keys[slot] == '\u0000' || predicate.apply(keys[slot], (Object)values[slot])); ++i) {
            slot = slot + inc & mask;
        }
        return predicate;
    }

    @Override
    public KeysContainer keys() {
        return new KeysContainer();
    }

    @Override
    public ObjectCollection<VType> values() {
        return new ValuesContainer();
    }

    public CharObjectHashMap<VType> clone() {
        try {
            CharObjectHashMap cloned = (CharObjectHashMap)super.clone();
            cloned.keys = (char[])this.keys.clone();
            cloned.values = (Object[])this.values.clone();
            cloned.hasEmptyKey = this.hasEmptyKey;
            cloned.iterationSeed = HashContainers.nextIterationSeed();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        boolean first = true;
        for (CharObjectCursor<VType> cursor : this) {
            if (!first) {
                buffer.append(", ");
            }
            buffer.append(cursor.key);
            buffer.append("=>");
            buffer.append(cursor.value);
            first = false;
        }
        buffer.append("]");
        return buffer.toString();
    }

    @Override
    public String visualizeKeyDistribution(int characters) {
        return CharBufferVisualizer.visualizeKeyDistribution(this.keys, this.mask, characters);
    }

    public static <VType> CharObjectHashMap<VType> from(char[] keys, VType[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        CharObjectHashMap<VType> map = new CharObjectHashMap<VType>(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }

    protected int hashKey(char key) {
        assert (key != '\u0000');
        return BitMixer.mixPhi(key);
    }

    protected double verifyLoadFactor(double loadFactor) {
        HashContainers.checkLoadFactor(loadFactor, 0.01f, 0.99f);
        return loadFactor;
    }

    protected void rehash(char[] fromKeys, VType[] fromValues) {
        assert (fromKeys.length == fromValues.length && HashContainers.checkPowerOfTwo(fromKeys.length - 1));
        char[] keys = this.keys;
        Object[] values = this.values;
        int mask = this.mask;
        int from = fromKeys.length - 1;
        keys[keys.length - 1] = fromKeys[from];
        values[values.length - 1] = fromValues[from];
        while (--from >= 0) {
            char existing = fromKeys[from];
            if (existing == '\u0000') continue;
            int slot = this.hashKey(existing) & mask;
            while (keys[slot] != '\u0000') {
                slot = slot + 1 & mask;
            }
            keys[slot] = existing;
            values[slot] = fromValues[from];
        }
    }

    protected void allocateBuffers(int arraySize) {
        assert (Integer.bitCount(arraySize) == 1);
        char[] prevKeys = this.keys;
        Object[] prevValues = this.values;
        try {
            int emptyElementSlot = 1;
            this.keys = new char[arraySize + emptyElementSlot];
            this.values = new Object[arraySize + emptyElementSlot];
        }
        catch (OutOfMemoryError e) {
            this.keys = prevKeys;
            this.values = prevValues;
            throw new BufferAllocationException("Not enough memory to allocate buffers for rehashing: %,d -> %,d", (Throwable)e, this.mask + 1, arraySize);
        }
        this.resizeAt = HashContainers.expandAtCount(arraySize, this.loadFactor);
        this.mask = arraySize - 1;
    }

    protected void allocateThenInsertThenRehash(int slot, char pendingKey, VType pendingValue) {
        assert (this.assigned == this.resizeAt && this.keys[slot] == '\u0000' && pendingKey != '\u0000');
        char[] prevKeys = this.keys;
        Object[] prevValues = this.values;
        this.allocateBuffers(HashContainers.nextBufferSize(this.mask + 1, this.size(), this.loadFactor));
        assert (this.keys.length > prevKeys.length);
        prevKeys[slot] = pendingKey;
        prevValues[slot] = pendingValue;
        this.rehash(prevKeys, prevValues);
    }

    protected void shiftConflictingKeys(int gapSlot) {
        int slot;
        char existing;
        char[] keys = this.keys;
        Object[] values = this.values;
        int mask = this.mask;
        int distance = 0;
        while ((existing = keys[slot = gapSlot + ++distance & mask]) != '\u0000') {
            int idealSlot = this.hashKey(existing);
            int shift = slot - idealSlot & mask;
            if (shift < distance) continue;
            keys[gapSlot] = existing;
            values[gapSlot] = values[slot];
            gapSlot = slot;
            distance = 0;
        }
        keys[gapSlot] = '\u0000';
        values[gapSlot] = null;
        --this.assigned;
    }

    private final class EntryIterator
    extends AbstractIterator<CharObjectCursor<VType>> {
        private final CharObjectCursor<VType> cursor = new CharObjectCursor();
        private final int increment;
        private int index;
        private int slot;

        public EntryIterator() {
            int seed = CharObjectHashMap.this.nextIterationSeed();
            this.increment = HashContainers.iterationIncrement(seed);
            this.slot = seed & CharObjectHashMap.this.mask;
        }

        @Override
        protected CharObjectCursor<VType> fetch() {
            int mask = CharObjectHashMap.this.mask;
            while (this.index <= mask) {
                ++this.index;
                this.slot = this.slot + this.increment & mask;
                char existing = CharObjectHashMap.this.keys[this.slot];
                if (existing == '\u0000') continue;
                this.cursor.index = this.slot;
                this.cursor.key = existing;
                this.cursor.value = CharObjectHashMap.this.values[this.slot];
                return this.cursor;
            }
            if (this.index == mask + 1 && CharObjectHashMap.this.hasEmptyKey) {
                this.cursor.index = this.index;
                this.cursor.key = '\u0000';
                this.cursor.value = CharObjectHashMap.this.values[this.index++];
                return this.cursor;
            }
            return (CharObjectCursor)this.done();
        }
    }

    public final class KeysContainer
    extends AbstractCharCollection
    implements CharLookupContainer {
        private final CharObjectHashMap<VType> owner;

        public KeysContainer() {
            this.owner = CharObjectHashMap.this;
        }

        @Override
        public boolean contains(char e) {
            return this.owner.containsKey(e);
        }

        @Override
        public <T extends CharProcedure> T forEach(T procedure) {
            this.owner.forEach((k, v) -> procedure.apply(k));
            return procedure;
        }

        @Override
        public <T extends CharPredicate> T forEach(T predicate) {
            this.owner.forEach((key, value) -> predicate.apply(key));
            return predicate;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<CharCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(CharPredicate predicate) {
            return this.owner.removeAll(predicate);
        }

        @Override
        public int removeAll(char e) {
            if (this.owner.containsKey(e)) {
                this.owner.remove(e);
                return 1;
            }
            return 0;
        }
    }

    private final class ValuesContainer
    extends AbstractObjectCollection<VType> {
        private final CharObjectHashMap<VType> owner;

        private ValuesContainer() {
            this.owner = CharObjectHashMap.this;
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public boolean contains(VType value) {
            for (CharObjectCursor c : this.owner) {
                if (!Objects.equals(value, c.value)) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends ObjectProcedure<? super VType>> T forEach(T procedure) {
            for (CharObjectCursor c : this.owner) {
                procedure.apply(c.value);
            }
            return procedure;
        }

        @Override
        public <T extends ObjectPredicate<? super VType>> T forEach(T predicate) {
            for (CharObjectCursor c : this.owner) {
                if (predicate.apply(c.value)) continue;
                break;
            }
            return predicate;
        }

        @Override
        public Iterator<ObjectCursor<VType>> iterator() {
            return new ValuesIterator();
        }

        @Override
        public int removeAll(VType e) {
            return this.owner.removeAll((char key, ? super VType value) -> Objects.equals(e, value));
        }

        @Override
        public int removeAll(ObjectPredicate<? super VType> predicate) {
            return this.owner.removeAll((char key, ? super VType value) -> predicate.apply((Object)value));
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public void release() {
            this.owner.release();
        }
    }

    private final class ValuesIterator
    extends AbstractIterator<ObjectCursor<VType>> {
        private final ObjectCursor<VType> cursor = new ObjectCursor();
        private final int increment;
        private int index;
        private int slot;

        public ValuesIterator() {
            int seed = CharObjectHashMap.this.nextIterationSeed();
            this.increment = HashContainers.iterationIncrement(seed);
            this.slot = seed & CharObjectHashMap.this.mask;
        }

        @Override
        protected ObjectCursor<VType> fetch() {
            int mask = CharObjectHashMap.this.mask;
            while (this.index <= mask) {
                ++this.index;
                this.slot = this.slot + this.increment & mask;
                if (CharObjectHashMap.this.keys[this.slot] == '\u0000') continue;
                this.cursor.index = this.slot;
                this.cursor.value = CharObjectHashMap.this.values[this.slot];
                return this.cursor;
            }
            if (this.index == mask + 1 && CharObjectHashMap.this.hasEmptyKey) {
                this.cursor.index = this.index;
                this.cursor.value = CharObjectHashMap.this.values[this.index++];
                return this.cursor;
            }
            return (ObjectCursor)this.done();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<CharCursor> {
        private final CharCursor cursor = new CharCursor();
        private final int increment;
        private int index;
        private int slot;

        public KeysIterator() {
            int seed = CharObjectHashMap.this.nextIterationSeed();
            this.increment = HashContainers.iterationIncrement(seed);
            this.slot = seed & CharObjectHashMap.this.mask;
        }

        @Override
        protected CharCursor fetch() {
            int mask = CharObjectHashMap.this.mask;
            while (this.index <= mask) {
                ++this.index;
                this.slot = this.slot + this.increment & mask;
                char existing = CharObjectHashMap.this.keys[this.slot];
                if (existing == '\u0000') continue;
                this.cursor.index = this.slot;
                this.cursor.value = existing;
                return this.cursor;
            }
            if (this.index == mask + 1 && CharObjectHashMap.this.hasEmptyKey) {
                this.cursor.index = this.index++;
                this.cursor.value = '\u0000';
                return this.cursor;
            }
            return (CharCursor)this.done();
        }
    }
}

