/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.carrotsearch.hppc;

import com.dremio.jdbc.shaded.com.carrotsearch.hppc.AbstractIterator;
import com.dremio.jdbc.shaded.com.carrotsearch.hppc.Accountable;
import com.dremio.jdbc.shaded.com.carrotsearch.hppc.IntArrayList;
import com.dremio.jdbc.shaded.com.carrotsearch.hppc.LongArrayList;
import com.dremio.jdbc.shaded.com.carrotsearch.hppc.PgmIndexUtil;
import com.dremio.jdbc.shaded.com.carrotsearch.hppc.PlaModel;
import com.dremio.jdbc.shaded.com.carrotsearch.hppc.RamUsageEstimator;
import com.dremio.jdbc.shaded.com.carrotsearch.hppc.cursors.LongCursor;
import com.dremio.jdbc.shaded.com.carrotsearch.hppc.procedures.LongProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class LongPgmIndex
implements Accountable {
    public static final LongPgmIndex EMPTY = new LongEmptyPgmIndex();
    public static final int EPSILON = 64;
    public static final int EPSILON_RECURSIVE = 32;
    public static final int KEY_SIZE = RamUsageEstimator.primitiveSizes.get(Long.TYPE) / 4;
    public static final int DOUBLE_KEY_SIZE = KEY_SIZE * 2;
    public static final int SEGMENT_DATA_SIZE = KEY_SIZE * 3;
    public static final int BEYOND_EPSILON_JUMP = 16;
    public final LongArrayList keys;
    public final int size;
    public final long firstKey;
    public final long lastKey;
    public final int epsilon;
    public final int epsilonRecursive;
    public final int[] levelOffsets;
    public final int[] segmentData;

    private LongPgmIndex(LongArrayList keys, int size, int epsilon, int epsilonRecursive, int[] levelOffsets, int[] segmentData) {
        assert (keys.size() > 0);
        assert (size > 0 && size <= keys.size());
        assert (epsilon > 0);
        assert (epsilonRecursive > 0);
        this.keys = keys;
        this.size = size;
        this.firstKey = keys.get(0);
        this.lastKey = keys.get(keys.size() - 1);
        this.epsilon = epsilon;
        this.epsilonRecursive = epsilonRecursive;
        this.levelOffsets = levelOffsets;
        this.segmentData = segmentData;
    }

    private LongPgmIndex() {
        this.keys = new LongArrayList(0);
        this.size = 0;
        this.firstKey = 0L;
        this.lastKey = 0L;
        this.epsilon = 0;
        this.epsilonRecursive = 0;
        this.levelOffsets = new int[0];
        this.segmentData = this.levelOffsets;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean contains(long key) {
        return this.indexOf(key) >= 0;
    }

    public int indexOf(long key) {
        if (key < this.firstKey) {
            return -1;
        }
        if (key > this.lastKey) {
            return -this.keys.size() - 1;
        }
        int[] segmentData = this.segmentData;
        int segmentDataIndex = this.findSegment(key);
        int nextIntercept = (int)LongPgmIndex.getIntercept(segmentDataIndex + SEGMENT_DATA_SIZE, segmentData);
        int index = Math.min(this.approximateIndex(key, segmentDataIndex, segmentData), Math.min(nextIntercept, this.keys.size() - 1));
        assert (index >= 0 && index < this.keys.size());
        long k = this.keys.get(index);
        if (key < k) {
            int fromIndex = Math.max(index - this.epsilon - 1, 0);
            while (--index >= fromIndex) {
                k = this.keys.get(index);
                if (key > k) {
                    return -index - 2;
                }
                if (key != k) continue;
                return index;
            }
            ++index;
            int jump = 16;
            do {
                int loIndex;
                if (key >= this.keys.get(loIndex = Math.max(index - jump, 0))) {
                    return Arrays.binarySearch(this.keys.buffer, loIndex, index, key);
                }
                index = loIndex;
                jump <<= 1;
            } while (index > 0);
            return -1;
        }
        if (key == k) {
            return index;
        }
        int toIndex = Math.min(index + this.epsilon + 3, this.keys.size());
        while (++index < toIndex) {
            k = this.keys.get(index);
            if (key < k) {
                return -index - 1;
            }
            if (key != k) continue;
            return index;
        }
        int jump = 16;
        do {
            int hiIndex;
            if (key <= this.keys.get(hiIndex = Math.min(index + jump, this.keys.size()))) {
                return Arrays.binarySearch(this.keys.buffer, index, hiIndex, key);
            }
            index = hiIndex;
            jump <<= 1;
        } while (index < this.keys.size());
        return -this.keys.size() - 1;
    }

    public int rank(long x) {
        int index = this.indexOf(x);
        return index >= 0 ? index : -index - 1;
    }

    public int rangeCardinality(long minKey, long maxKey) {
        int fromIndex = this.rank(minKey);
        int maxIndex = this.indexOf(maxKey);
        int toIndex = maxIndex >= 0 ? maxIndex + 1 : -maxIndex - 1;
        return Math.max(toIndex - fromIndex, 0);
    }

    public Iterator<LongCursor> rangeIterator(long minKey, long maxKey) {
        int fromIndex = this.rank(minKey);
        return new RangeIterator(this.keys, fromIndex, maxKey);
    }

    public <T extends LongProcedure> T forEachInRange(T procedure, long minKey, long maxKey) {
        long k;
        long[] buffer = this.keys.buffer;
        int size = this.keys.size();
        for (int i = this.rank(minKey); i < size && (k = buffer[i]) <= maxKey; ++i) {
            procedure.apply(k);
        }
        return procedure;
    }

    @Override
    public long ramBytesAllocated() {
        return (long)(RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 12) + 2L * (long)KEY_SIZE * 4L + RamUsageEstimator.shallowSizeOfArray(this.levelOffsets) + RamUsageEstimator.shallowSizeOfArray(this.segmentData);
    }

    @Override
    public long ramBytesUsed() {
        return (long)(RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 12) + 2L * (long)KEY_SIZE * 4L + RamUsageEstimator.shallowSizeOfArray(this.levelOffsets) + RamUsageEstimator.shallowSizeOfArray(this.segmentData);
    }

    private int findSegment(long key) {
        assert (key >= this.firstKey && key <= this.lastKey);
        int epsilonRecursive = this.epsilonRecursive;
        int[] levelOffsets = this.levelOffsets;
        int[] segmentData = this.segmentData;
        int level = levelOffsets.length - 1;
        int segmentDataIndex = levelOffsets[level] * SEGMENT_DATA_SIZE;
        while (--level >= 0) {
            int nextIntercept = (int)LongPgmIndex.getIntercept(segmentDataIndex + SEGMENT_DATA_SIZE, segmentData);
            int index = Math.min(this.approximateIndex(key, segmentDataIndex, segmentData), nextIntercept);
            assert (index >= 0 && index <= levelOffsets[level + 1] - levelOffsets[level] - 1);
            int sdIndex = (levelOffsets[level] + index) * SEGMENT_DATA_SIZE;
            if (this.getKey(sdIndex, segmentData) <= key) {
                int levelNumSegments = levelOffsets[level + 1] - levelOffsets[level] - 1;
                int toIndex = Math.min(index + epsilonRecursive + 3, levelNumSegments);
                while (index++ < toIndex && this.getKey(sdIndex + SEGMENT_DATA_SIZE, segmentData) <= key) {
                    sdIndex += SEGMENT_DATA_SIZE;
                }
            } else {
                int fromIndex = Math.max(index - epsilonRecursive - 1, 0);
                while (index-- > fromIndex && this.getKey(sdIndex -= SEGMENT_DATA_SIZE, segmentData) > key) {
                }
            }
            segmentDataIndex = sdIndex;
        }
        assert (segmentDataIndex >= 0);
        return segmentDataIndex;
    }

    private int approximateIndex(long key, int segmentDataIndex, int[] segmentData) {
        long intercept = LongPgmIndex.getIntercept(segmentDataIndex, segmentData);
        long sKey = this.getKey(segmentDataIndex, segmentData);
        double slope = LongPgmIndex.getSlope(segmentDataIndex, segmentData);
        int index = (int)(slope * ((double)key - (double)sKey) + (double)intercept);
        return Math.max(index, 0);
    }

    private static long getIntercept(int segmentDataIndex, int[] segmentData) {
        return PgmIndexUtil.getIntercept(segmentDataIndex, segmentData, KEY_SIZE);
    }

    private long getKey(int segmentDataIndex, int[] segmentData) {
        return PgmIndexUtil.getKey(segmentDataIndex + KEY_SIZE, segmentData, 0L);
    }

    private static double getSlope(int segmentDataIndex, int[] segmentData) {
        return PgmIndexUtil.getSlope(segmentDataIndex + DOUBLE_KEY_SIZE, segmentData, KEY_SIZE);
    }

    protected static class RangeIterator
    extends AbstractIterator<LongCursor> {
        private final long[] buffer;
        private final int size;
        private final LongCursor cursor;
        private final long maxKey;

        protected RangeIterator(LongArrayList keys, int fromIndex, long maxKey) {
            this.buffer = keys.buffer;
            this.size = keys.size();
            this.cursor = new LongCursor();
            this.cursor.index = fromIndex;
            this.maxKey = maxKey;
        }

        @Override
        protected LongCursor fetch() {
            if (this.cursor.index >= this.size) {
                return (LongCursor)this.done();
            }
            this.cursor.value = this.buffer[this.cursor.index++];
            if (this.cursor.value > this.maxKey) {
                this.cursor.index = this.size;
                return (LongCursor)this.done();
            }
            return this.cursor;
        }
    }

    private static class LongEmptyPgmIndex
    extends LongPgmIndex {
        private final Iterator<LongCursor> emptyIterator = new LongEmptyIterator();

        private LongEmptyPgmIndex() {
        }

        @Override
        public int indexOf(long key) {
            return -1;
        }

        @Override
        public Iterator<LongCursor> rangeIterator(long minKey, long maxKey) {
            return this.emptyIterator;
        }

        @Override
        public <T extends LongProcedure> T forEachInRange(T procedure, long minKey, long maxKey) {
            return procedure;
        }

        private static class LongEmptyIterator
        extends AbstractIterator<LongCursor> {
            private LongEmptyIterator() {
            }

            @Override
            protected LongCursor fetch() {
                return (LongCursor)this.done();
            }
        }
    }

    public static class LongBuilder
    implements PlaModel.SegmentConsumer,
    Accountable {
        protected LongArrayList keys;
        protected int epsilon = 64;
        protected int epsilonRecursive = 32;
        protected PlaModel plam;
        protected int size;
        protected IntArrayList segmentData;
        protected int numSegments;

        public LongBuilder setSortedKeys(LongArrayList keys) {
            this.keys = keys;
            return this;
        }

        public LongBuilder setSortedKeys(long[] keys, int length) {
            LongArrayList keyList = new LongArrayList(0);
            keyList.buffer = keys;
            keyList.elementsCount = length;
            return this.setSortedKeys(keyList);
        }

        public LongBuilder setEpsilon(int epsilon) {
            if (epsilon <= 0) {
                throw new IllegalArgumentException("epsilon must be > 0");
            }
            this.epsilon = epsilon;
            return this;
        }

        public LongBuilder setEpsilonRecursive(int epsilonRecursive) {
            if (epsilonRecursive <= 0) {
                throw new IllegalArgumentException("epsilonRecursive must be > 0");
            }
            this.epsilonRecursive = epsilonRecursive;
            return this;
        }

        public LongPgmIndex build() {
            if (this.keys == null || this.keys.size() == 0) {
                return EMPTY;
            }
            this.plam = new PlaModel(this.epsilon);
            int segmentsInitialCapacity = Math.min(Math.max(this.keys.size() / (2 * this.epsilon * this.epsilon) * SEGMENT_DATA_SIZE, 16), 524288);
            this.segmentData = new IntArrayList(segmentsInitialCapacity);
            IntArrayList levelOffsets = new IntArrayList(16);
            int levelOffset = 0;
            levelOffsets.add(levelOffset);
            int levelNumSegments = this.buildFirstLevel();
            while (levelNumSegments > 1) {
                int nextLevelOffset = this.numSegments;
                levelOffsets.add(nextLevelOffset);
                levelNumSegments = this.buildUpperLevel(levelOffset, levelNumSegments);
                levelOffset = nextLevelOffset;
            }
            int[] segmentDataFinal = this.segmentData.toArray();
            int[] levelOffsetsFinal = levelOffsets.toArray();
            return new LongPgmIndex(this.keys, this.size, this.epsilon, this.epsilonRecursive, levelOffsetsFinal, segmentDataFinal);
        }

        private int buildFirstLevel() {
            assert (this.numSegments == 0);
            int numKeys = this.keys.size();
            int size = 0;
            long key = this.keys.get(0);
            ++size;
            this.plam.addKey(key, 0, this);
            for (int i = 1; i < numKeys; ++i) {
                long nextKey = this.keys.get(i);
                if (nextKey == key) continue;
                key = nextKey;
                this.plam.addKey(key, i, this);
                ++size;
            }
            this.plam.finish(this);
            this.addSentinelSegment(numKeys);
            this.size = size;
            return this.numSegments - 1;
        }

        private int buildUpperLevel(int levelOffset, int levelNumSegments) {
            this.plam.setEpsilon(this.epsilonRecursive);
            assert (this.numSegments > 0);
            int initialNumSegments = this.numSegments;
            int segmentDataIndex = levelOffset * SEGMENT_DATA_SIZE;
            long key = this.getKey(segmentDataIndex, this.segmentData.buffer);
            this.plam.addKey(key, 0, this);
            for (int i = 1; i < levelNumSegments; ++i) {
                long nextKey = this.getKey(segmentDataIndex += SEGMENT_DATA_SIZE, this.segmentData.buffer);
                if (nextKey == key) continue;
                key = nextKey;
                this.plam.addKey(key, i, this);
            }
            this.plam.finish(this);
            this.addSentinelSegment(levelNumSegments);
            return this.numSegments - initialNumSegments - 1;
        }

        private long getKey(int segmentDataIndex, int[] segmentData) {
            return PgmIndexUtil.getKey(segmentDataIndex + KEY_SIZE, segmentData, 0L);
        }

        private void addSentinelSegment(int endIndex) {
            this.accept(Double.MAX_VALUE, 0.0, endIndex);
        }

        @Override
        public void accept(double firstKey, double slope, long intercept) {
            PgmIndexUtil.addIntercept(intercept, this.segmentData, KEY_SIZE);
            PgmIndexUtil.addKey((long)firstKey, this.segmentData);
            PgmIndexUtil.addSlope(slope, this.segmentData, KEY_SIZE);
            ++this.numSegments;
            assert (this.segmentData.size() == this.numSegments * SEGMENT_DATA_SIZE);
        }

        @Override
        public long ramBytesAllocated() {
            return (long)(RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 16) + this.plam.ramBytesAllocated() + this.segmentData.ramBytesAllocated();
        }

        @Override
        public long ramBytesUsed() {
            return (long)(RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 16) + this.plam.ramBytesUsed() + this.segmentData.ramBytesUsed();
        }
    }
}

