/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.carrotsearch.hppc;

import com.dremio.jdbc.shaded.com.carrotsearch.hppc.IntArrayList;

final class PgmIndexUtil {
    PgmIndexUtil() {
    }

    static <KType> void addKey(KType key, IntArrayList segmentData) {
        throw new UnsupportedOperationException("Invalid for generic type: " + String.valueOf(key));
    }

    static void addKey(int key, IntArrayList segmentData) {
        segmentData.add(key);
    }

    static void addKey(float key, IntArrayList segmentData) {
        PgmIndexUtil.addKey(Float.floatToIntBits(key), segmentData);
    }

    static void addKey(long key, IntArrayList segmentData) {
        segmentData.add((int)key);
        segmentData.add((int)(key >> 32));
    }

    static void addKey(double key, IntArrayList segmentData) {
        PgmIndexUtil.addKey(Double.doubleToRawLongBits(key), segmentData);
    }

    static <KType> KType getKey(int segmentDataIndex, int[] segmentData, KType keyType) {
        throw new UnsupportedOperationException("Invalid for generic type: " + String.valueOf(keyType));
    }

    static int getKey(int segmentDataIndex, int[] segmentData, int keyType) {
        return segmentData[segmentDataIndex];
    }

    static float getKey(int segmentDataIndex, int[] segmentData, float keyType) {
        return Float.intBitsToFloat(PgmIndexUtil.getKey(segmentDataIndex, segmentData, 0));
    }

    static long getKey(int segmentDataIndex, int[] segmentData, long keyType) {
        return (long)segmentData[segmentDataIndex] & 0xFFFFFFFFL | (long)segmentData[segmentDataIndex + 1] << 32;
    }

    static double getKey(int segmentDataIndex, int[] segmentData, double keyType) {
        return Double.longBitsToDouble(PgmIndexUtil.getKey(segmentDataIndex, segmentData, 0L));
    }

    static void addIntercept(long intercept, IntArrayList segmentData, int keySize) {
        assert (keySize >= 1 && keySize <= 2);
        if (keySize == 1) {
            PgmIndexUtil.addKey((int)intercept, segmentData);
        } else {
            PgmIndexUtil.addKey(intercept, segmentData);
        }
    }

    static long getIntercept(int segmentDataIndex, int[] segmentData, int keySize) {
        assert (keySize >= 1 && keySize <= 2);
        if (keySize == 1) {
            return PgmIndexUtil.getKey(segmentDataIndex, segmentData, 0);
        }
        return PgmIndexUtil.getKey(segmentDataIndex, segmentData, 0L);
    }

    static void addSlope(double slope, IntArrayList segmentData, int keySize) {
        assert (keySize >= 1 && keySize <= 2);
        if (keySize == 1) {
            PgmIndexUtil.addKey((float)slope, segmentData);
        } else {
            PgmIndexUtil.addKey(slope, segmentData);
        }
    }

    static double getSlope(int segmentDataIndex, int[] segmentData, int keySize) {
        assert (keySize >= 1 && keySize <= 2);
        if (keySize == 1) {
            return PgmIndexUtil.getKey(segmentDataIndex, segmentData, 0.0f);
        }
        return PgmIndexUtil.getKey(segmentDataIndex, segmentData, 0.0);
    }
}

