/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.carrotsearch.hppc;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;

final class RamUsageEstimator {
    static final boolean COMPRESSED_REFS_ENABLED;
    static final int NUM_BYTES_OBJECT_REF;
    static final int NUM_BYTES_OBJECT_HEADER;
    static final int NUM_BYTES_ARRAY_HEADER;
    static final int NUM_BYTES_OBJECT_ALIGNMENT;
    static final Map<Class<?>, Integer> primitiveSizes;
    static final boolean JRE_IS_64BIT;
    static final String MANAGEMENT_FACTORY_CLASS = "java.lang.management.ManagementFactory";
    static final String HOTSPOT_BEAN_CLASS = "com.sun.management.HotSpotDiagnosticMXBean";
    static final String OS_ARCH;

    private RamUsageEstimator() {
    }

    static long alignObjectSize(long size) {
        return (size += (long)NUM_BYTES_OBJECT_ALIGNMENT - 1L) - size % (long)NUM_BYTES_OBJECT_ALIGNMENT;
    }

    static long shallowUsedSizeOfArray(Object array, int usedSize) {
        long size = NUM_BYTES_ARRAY_HEADER;
        if (usedSize > 0) {
            Class<?> arrayElementClazz = array.getClass().getComponentType();
            size = arrayElementClazz.isPrimitive() ? (size += (long)usedSize * (long)primitiveSizes.get(arrayElementClazz).intValue()) : (size += (long)NUM_BYTES_OBJECT_REF * (long)usedSize);
        }
        return RamUsageEstimator.alignObjectSize(size);
    }

    static long shallowSizeOfArray(Object array) {
        return RamUsageEstimator.shallowUsedSizeOfArray(array, Array.getLength(array));
    }

    static {
        IdentityHashMap<Class<Comparable<Boolean>>, Integer> primitiveSizesMap = new IdentityHashMap<Class<Comparable<Boolean>>, Integer>();
        primitiveSizesMap.put(Boolean.TYPE, 1);
        primitiveSizesMap.put(Byte.TYPE, 1);
        primitiveSizesMap.put(Character.TYPE, 2);
        primitiveSizesMap.put(Short.TYPE, 2);
        primitiveSizesMap.put(Integer.TYPE, 4);
        primitiveSizesMap.put(Float.TYPE, 4);
        primitiveSizesMap.put(Double.TYPE, 8);
        primitiveSizesMap.put(Long.TYPE, 8);
        primitiveSizes = Collections.unmodifiableMap(primitiveSizesMap);
        OS_ARCH = System.getProperty("os.arch");
        boolean is64Bit = false;
        String datamodel = null;
        try {
            datamodel = System.getProperty("sun.arch.data.model");
            if (datamodel != null) {
                is64Bit = datamodel.contains("64");
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (datamodel == null) {
            boolean bl = is64Bit = OS_ARCH != null && OS_ARCH.contains("64");
        }
        if (JRE_IS_64BIT = is64Bit) {
            int objectAlignment;
            boolean compressedOops;
            block12: {
                compressedOops = false;
                objectAlignment = 8;
                try {
                    Object vmOption2;
                    Class<?> beanClazz = Class.forName(HOTSPOT_BEAN_CLASS);
                    Object hotSpotBean = Class.forName(MANAGEMENT_FACTORY_CLASS).getMethod("getPlatformMXBean", Class.class).invoke(null, beanClazz);
                    if (hotSpotBean == null) break block12;
                    Method getVMOptionMethod = beanClazz.getMethod("getVMOption", String.class);
                    try {
                        vmOption2 = getVMOptionMethod.invoke(hotSpotBean, "UseCompressedOops");
                        compressedOops = Boolean.parseBoolean(vmOption2.getClass().getMethod("getValue", new Class[0]).invoke(vmOption2, new Object[0]).toString());
                    }
                    catch (ReflectiveOperationException | RuntimeException vmOption2) {
                        // empty catch block
                    }
                    try {
                        vmOption2 = getVMOptionMethod.invoke(hotSpotBean, "ObjectAlignmentInBytes");
                        objectAlignment = Integer.parseInt(vmOption2.getClass().getMethod("getValue", new Class[0]).invoke(vmOption2, new Object[0]).toString());
                    }
                    catch (ReflectiveOperationException | RuntimeException exception) {}
                }
                catch (ReflectiveOperationException | RuntimeException exception) {
                    // empty catch block
                }
            }
            COMPRESSED_REFS_ENABLED = compressedOops;
            NUM_BYTES_OBJECT_ALIGNMENT = objectAlignment;
            NUM_BYTES_OBJECT_REF = COMPRESSED_REFS_ENABLED ? 4 : 8;
            NUM_BYTES_OBJECT_HEADER = 8 + NUM_BYTES_OBJECT_REF;
            NUM_BYTES_ARRAY_HEADER = (int)RamUsageEstimator.alignObjectSize(NUM_BYTES_OBJECT_HEADER + 4);
        } else {
            COMPRESSED_REFS_ENABLED = false;
            NUM_BYTES_OBJECT_ALIGNMENT = 8;
            NUM_BYTES_OBJECT_REF = 4;
            NUM_BYTES_OBJECT_HEADER = 8;
            NUM_BYTES_ARRAY_HEADER = NUM_BYTES_OBJECT_HEADER + 4;
        }
    }
}

