/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.carrotsearch.hppc;

import com.dremio.jdbc.shaded.com.carrotsearch.hppc.AbstractFloatCollection;
import com.dremio.jdbc.shaded.com.carrotsearch.hppc.AbstractIterator;
import com.dremio.jdbc.shaded.com.carrotsearch.hppc.AbstractShortCollection;
import com.dremio.jdbc.shaded.com.carrotsearch.hppc.Accountable;
import com.dremio.jdbc.shaded.com.carrotsearch.hppc.BitMixer;
import com.dremio.jdbc.shaded.com.carrotsearch.hppc.BufferAllocationException;
import com.dremio.jdbc.shaded.com.carrotsearch.hppc.FloatCollection;
import com.dremio.jdbc.shaded.com.carrotsearch.hppc.HashContainers;
import com.dremio.jdbc.shaded.com.carrotsearch.hppc.Preallocable;
import com.dremio.jdbc.shaded.com.carrotsearch.hppc.RamUsageEstimator;
import com.dremio.jdbc.shaded.com.carrotsearch.hppc.ShortBufferVisualizer;
import com.dremio.jdbc.shaded.com.carrotsearch.hppc.ShortContainer;
import com.dremio.jdbc.shaded.com.carrotsearch.hppc.ShortFloatAssociativeContainer;
import com.dremio.jdbc.shaded.com.carrotsearch.hppc.ShortFloatMap;
import com.dremio.jdbc.shaded.com.carrotsearch.hppc.ShortLookupContainer;
import com.dremio.jdbc.shaded.com.carrotsearch.hppc.cursors.FloatCursor;
import com.dremio.jdbc.shaded.com.carrotsearch.hppc.cursors.ShortCursor;
import com.dremio.jdbc.shaded.com.carrotsearch.hppc.cursors.ShortFloatCursor;
import com.dremio.jdbc.shaded.com.carrotsearch.hppc.predicates.FloatPredicate;
import com.dremio.jdbc.shaded.com.carrotsearch.hppc.predicates.ShortFloatPredicate;
import com.dremio.jdbc.shaded.com.carrotsearch.hppc.predicates.ShortPredicate;
import com.dremio.jdbc.shaded.com.carrotsearch.hppc.procedures.FloatProcedure;
import com.dremio.jdbc.shaded.com.carrotsearch.hppc.procedures.ShortFloatProcedure;
import com.dremio.jdbc.shaded.com.carrotsearch.hppc.procedures.ShortProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class ShortFloatHashMap
implements ShortFloatMap,
Preallocable,
Cloneable,
Accountable {
    public short[] keys;
    public float[] values;
    protected int assigned;
    protected int mask;
    protected int resizeAt;
    protected boolean hasEmptyKey;
    protected double loadFactor;
    protected int iterationSeed;

    public ShortFloatHashMap() {
        this(4);
    }

    public ShortFloatHashMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public ShortFloatHashMap(int expectedElements, double loadFactor) {
        this.loadFactor = this.verifyLoadFactor(loadFactor);
        this.iterationSeed = HashContainers.nextIterationSeed();
        this.ensureCapacity(expectedElements);
    }

    public ShortFloatHashMap(ShortFloatAssociativeContainer container) {
        this(container.size());
        this.putAll(container);
    }

    @Override
    public float put(short key, float value) {
        short existing;
        assert (this.assigned < this.mask + 1);
        int mask = this.mask;
        if (key == 0) {
            float previousValue = this.hasEmptyKey ? this.values[mask + 1] : 0.0f;
            this.hasEmptyKey = true;
            this.values[mask + 1] = value;
            return previousValue;
        }
        short[] keys = this.keys;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != 0) {
            if (key == existing) {
                float previousValue = this.values[slot];
                this.values[slot] = value;
                return previousValue;
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(slot, key, value);
        } else {
            keys[slot] = key;
            this.values[slot] = value;
        }
        ++this.assigned;
        return 0.0f;
    }

    @Override
    public int putAll(ShortFloatAssociativeContainer container) {
        int count = this.size();
        for (ShortFloatCursor c : container) {
            this.put(c.key, c.value);
        }
        return this.size() - count;
    }

    @Override
    public int putAll(Iterable<? extends ShortFloatCursor> iterable) {
        int count = this.size();
        for (ShortFloatCursor shortFloatCursor : iterable) {
            this.put(shortFloatCursor.key, shortFloatCursor.value);
        }
        return this.size() - count;
    }

    @Override
    public float putOrAdd(short key, float putValue, float incrementValue) {
        assert (this.assigned < this.mask + 1);
        int keyIndex = this.indexOf(key);
        if (this.indexExists(keyIndex)) {
            putValue = this.values[keyIndex] + incrementValue;
            this.indexReplace(keyIndex, putValue);
        } else {
            this.indexInsert(keyIndex, key, putValue);
        }
        return putValue;
    }

    @Override
    public float addTo(short key, float incrementValue) {
        return this.putOrAdd(key, incrementValue, incrementValue);
    }

    @Override
    public float remove(short key) {
        short existing;
        int mask = this.mask;
        if (key == 0) {
            if (!this.hasEmptyKey) {
                return 0.0f;
            }
            this.hasEmptyKey = false;
            float previousValue = this.values[mask + 1];
            this.values[mask + 1] = 0.0f;
            return previousValue;
        }
        short[] keys = this.keys;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != 0) {
            if (key == existing) {
                float previousValue = this.values[slot];
                this.shiftConflictingKeys(slot);
                return previousValue;
            }
            slot = slot + 1 & mask;
        }
        return 0.0f;
    }

    @Override
    public int removeAll(ShortContainer other) {
        int before = this.size();
        if (other.size() >= this.size() && other instanceof ShortLookupContainer) {
            if (this.hasEmptyKey && other.contains((short)0)) {
                this.hasEmptyKey = false;
                this.values[this.mask + 1] = 0.0f;
            }
            short[] keys = this.keys;
            int slot = 0;
            int max = this.mask;
            while (slot <= max) {
                short existing = keys[slot];
                if (existing != 0 && other.contains(existing)) {
                    this.shiftConflictingKeys(slot);
                    continue;
                }
                ++slot;
            }
        } else {
            for (ShortCursor c : other) {
                this.remove(c.value);
            }
        }
        return before - this.size();
    }

    @Override
    public int removeAll(ShortFloatPredicate predicate) {
        int before = this.size();
        int mask = this.mask;
        if (this.hasEmptyKey && predicate.apply((short)0, this.values[mask + 1])) {
            this.hasEmptyKey = false;
            this.values[mask + 1] = 0.0f;
        }
        short[] keys = this.keys;
        float[] values = this.values;
        int slot = 0;
        while (slot <= mask) {
            short existing = keys[slot];
            if (existing != 0 && predicate.apply(existing, values[slot])) {
                this.shiftConflictingKeys(slot);
                continue;
            }
            ++slot;
        }
        return before - this.size();
    }

    @Override
    public int removeAll(ShortPredicate predicate) {
        int before = this.size();
        if (this.hasEmptyKey && predicate.apply((short)0)) {
            this.hasEmptyKey = false;
            this.values[this.mask + 1] = 0.0f;
        }
        short[] keys = this.keys;
        int slot = 0;
        int max = this.mask;
        while (slot <= max) {
            short existing = keys[slot];
            if (existing != 0 && predicate.apply(existing)) {
                this.shiftConflictingKeys(slot);
                continue;
            }
            ++slot;
        }
        return before - this.size();
    }

    @Override
    public float get(short key) {
        short existing;
        if (key == 0) {
            return this.hasEmptyKey ? this.values[this.mask + 1] : 0.0f;
        }
        short[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != 0) {
            if (key == existing) {
                return this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return 0.0f;
    }

    @Override
    public float getOrDefault(short key, float defaultValue) {
        short existing;
        if (key == 0) {
            return this.hasEmptyKey ? this.values[this.mask + 1] : defaultValue;
        }
        short[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != 0) {
            if (key == existing) {
                return this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return defaultValue;
    }

    @Override
    public boolean containsKey(short key) {
        short existing;
        if (key == 0) {
            return this.hasEmptyKey;
        }
        short[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != 0) {
            if (key == existing) {
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    @Override
    public int indexOf(short key) {
        short existing;
        int mask = this.mask;
        if (key == 0) {
            return this.hasEmptyKey ? mask + 1 : ~(mask + 1);
        }
        short[] keys = this.keys;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != 0) {
            if (key == existing) {
                return slot;
            }
            slot = slot + 1 & mask;
        }
        return ~slot;
    }

    @Override
    public boolean indexExists(int index) {
        assert (index < 0 || index >= 0 && index <= this.mask || index == this.mask + 1 && this.hasEmptyKey);
        return index >= 0;
    }

    @Override
    public float indexGet(int index) {
        assert (index >= 0) : "The index must point at an existing key.";
        assert (index <= this.mask || index == this.mask + 1 && this.hasEmptyKey);
        return this.values[index];
    }

    @Override
    public float indexReplace(int index, float newValue) {
        assert (index >= 0) : "The index must point at an existing key.";
        assert (index <= this.mask || index == this.mask + 1 && this.hasEmptyKey);
        float previousValue = this.values[index];
        this.values[index] = newValue;
        return previousValue;
    }

    @Override
    public void indexInsert(int index, short key, float value) {
        assert (index < 0) : "The index must not point at an existing key.";
        index ^= 0xFFFFFFFF;
        if (key == 0) {
            assert (index == this.mask + 1);
            this.values[index] = value;
            this.hasEmptyKey = true;
        } else {
            assert (this.keys[index] == 0);
            if (this.assigned == this.resizeAt) {
                this.allocateThenInsertThenRehash(index, key, value);
            } else {
                this.keys[index] = key;
                this.values[index] = value;
            }
            ++this.assigned;
        }
    }

    @Override
    public float indexRemove(int index) {
        assert (index >= 0) : "The index must point at an existing key.";
        assert (index <= this.mask || index == this.mask + 1 && this.hasEmptyKey);
        float previousValue = this.values[index];
        if (index > this.mask) {
            assert (index == this.mask + 1);
            this.hasEmptyKey = false;
            this.values[index] = 0.0f;
        } else {
            this.shiftConflictingKeys(index);
        }
        return previousValue;
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        Arrays.fill(this.keys, (short)0);
    }

    @Override
    public void release() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        this.keys = null;
        this.values = null;
        this.ensureCapacity(4);
    }

    @Override
    public int size() {
        return this.assigned + (this.hasEmptyKey ? 1 : 0);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int hashCode() {
        int h2 = this.hasEmptyKey ? -559038737 : 0;
        for (ShortFloatCursor c : this) {
            h2 += BitMixer.mix(c.key) + BitMixer.mix(c.value);
        }
        return h2;
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj != null && this.getClass() == obj.getClass() && this.equalElements((ShortFloatHashMap)this.getClass().cast(obj));
    }

    protected boolean equalElements(ShortFloatHashMap other) {
        if (other.size() != this.size()) {
            return false;
        }
        for (ShortFloatCursor c : other) {
            short key = c.key;
            if (this.containsKey(key) && Float.floatToIntBits(c.value) == Float.floatToIntBits(this.get(key))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void ensureCapacity(int expectedElements) {
        if (expectedElements > this.resizeAt || this.keys == null) {
            short[] prevKeys = this.keys;
            float[] prevValues = this.values;
            this.allocateBuffers(HashContainers.minBufferSize(expectedElements, this.loadFactor));
            if (prevKeys != null && !this.isEmpty()) {
                this.rehash(prevKeys, prevValues);
            }
        }
    }

    @Override
    public long ramBytesAllocated() {
        return (long)(RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 16 + 8 + 1) + RamUsageEstimator.shallowSizeOfArray(this.keys) + RamUsageEstimator.shallowSizeOfArray(this.values);
    }

    @Override
    public long ramBytesUsed() {
        return (long)(RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 16 + 8 + 1) + RamUsageEstimator.shallowUsedSizeOfArray(this.keys, this.size()) + RamUsageEstimator.shallowUsedSizeOfArray(this.values, this.size());
    }

    protected int nextIterationSeed() {
        this.iterationSeed = BitMixer.mixPhi(this.iterationSeed);
        return this.iterationSeed;
    }

    @Override
    public Iterator<ShortFloatCursor> iterator() {
        return new EntryIterator();
    }

    @Override
    public <T extends ShortFloatProcedure> T forEach(T procedure) {
        short[] keys = this.keys;
        float[] values = this.values;
        if (this.hasEmptyKey) {
            procedure.apply((short)0, values[this.mask + 1]);
        }
        int seed = this.nextIterationSeed();
        int inc = HashContainers.iterationIncrement(seed);
        int mask = this.mask;
        int slot = seed & mask;
        for (int i = 0; i <= mask; ++i) {
            if (keys[slot] != 0) {
                procedure.apply(keys[slot], values[slot]);
            }
            slot = slot + inc & mask;
        }
        return procedure;
    }

    @Override
    public <T extends ShortFloatPredicate> T forEach(T predicate) {
        short[] keys = this.keys;
        float[] values = this.values;
        if (this.hasEmptyKey && !predicate.apply((short)0, values[this.mask + 1])) {
            return predicate;
        }
        int seed = this.nextIterationSeed();
        int inc = HashContainers.iterationIncrement(seed);
        int mask = this.mask;
        int slot = seed & mask;
        for (int i = 0; i <= mask && (keys[slot] == 0 || predicate.apply(keys[slot], values[slot])); ++i) {
            slot = slot + inc & mask;
        }
        return predicate;
    }

    @Override
    public KeysContainer keys() {
        return new KeysContainer();
    }

    @Override
    public FloatCollection values() {
        return new ValuesContainer();
    }

    public ShortFloatHashMap clone() {
        try {
            ShortFloatHashMap cloned = (ShortFloatHashMap)super.clone();
            cloned.keys = (short[])this.keys.clone();
            cloned.values = (float[])this.values.clone();
            cloned.hasEmptyKey = this.hasEmptyKey;
            cloned.iterationSeed = HashContainers.nextIterationSeed();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        boolean first = true;
        for (ShortFloatCursor cursor : this) {
            if (!first) {
                buffer.append(", ");
            }
            buffer.append(cursor.key);
            buffer.append("=>");
            buffer.append(cursor.value);
            first = false;
        }
        buffer.append("]");
        return buffer.toString();
    }

    @Override
    public String visualizeKeyDistribution(int characters) {
        return ShortBufferVisualizer.visualizeKeyDistribution(this.keys, this.mask, characters);
    }

    public static ShortFloatHashMap from(short[] keys, float[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        ShortFloatHashMap map = new ShortFloatHashMap(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }

    protected int hashKey(short key) {
        assert (key != 0);
        return BitMixer.mixPhi(key);
    }

    protected double verifyLoadFactor(double loadFactor) {
        HashContainers.checkLoadFactor(loadFactor, 0.01f, 0.99f);
        return loadFactor;
    }

    protected void rehash(short[] fromKeys, float[] fromValues) {
        assert (fromKeys.length == fromValues.length && HashContainers.checkPowerOfTwo(fromKeys.length - 1));
        short[] keys = this.keys;
        float[] values = this.values;
        int mask = this.mask;
        int from = fromKeys.length - 1;
        keys[keys.length - 1] = fromKeys[from];
        values[values.length - 1] = fromValues[from];
        while (--from >= 0) {
            short existing = fromKeys[from];
            if (existing == 0) continue;
            int slot = this.hashKey(existing) & mask;
            while (keys[slot] != 0) {
                slot = slot + 1 & mask;
            }
            keys[slot] = existing;
            values[slot] = fromValues[from];
        }
    }

    protected void allocateBuffers(int arraySize) {
        assert (Integer.bitCount(arraySize) == 1);
        short[] prevKeys = this.keys;
        float[] prevValues = this.values;
        try {
            int emptyElementSlot = 1;
            this.keys = new short[arraySize + emptyElementSlot];
            this.values = new float[arraySize + emptyElementSlot];
        }
        catch (OutOfMemoryError e) {
            this.keys = prevKeys;
            this.values = prevValues;
            throw new BufferAllocationException("Not enough memory to allocate buffers for rehashing: %,d -> %,d", (Throwable)e, this.mask + 1, arraySize);
        }
        this.resizeAt = HashContainers.expandAtCount(arraySize, this.loadFactor);
        this.mask = arraySize - 1;
    }

    protected void allocateThenInsertThenRehash(int slot, short pendingKey, float pendingValue) {
        assert (this.assigned == this.resizeAt && this.keys[slot] == 0 && pendingKey != 0);
        short[] prevKeys = this.keys;
        float[] prevValues = this.values;
        this.allocateBuffers(HashContainers.nextBufferSize(this.mask + 1, this.size(), this.loadFactor));
        assert (this.keys.length > prevKeys.length);
        prevKeys[slot] = pendingKey;
        prevValues[slot] = pendingValue;
        this.rehash(prevKeys, prevValues);
    }

    protected void shiftConflictingKeys(int gapSlot) {
        int slot;
        short existing;
        short[] keys = this.keys;
        float[] values = this.values;
        int mask = this.mask;
        int distance = 0;
        while ((existing = keys[slot = gapSlot + ++distance & mask]) != 0) {
            int idealSlot = this.hashKey(existing);
            int shift = slot - idealSlot & mask;
            if (shift < distance) continue;
            keys[gapSlot] = existing;
            values[gapSlot] = values[slot];
            gapSlot = slot;
            distance = 0;
        }
        keys[gapSlot] = 0;
        values[gapSlot] = 0.0f;
        --this.assigned;
    }

    private final class EntryIterator
    extends AbstractIterator<ShortFloatCursor> {
        private final ShortFloatCursor cursor = new ShortFloatCursor();
        private final int increment;
        private int index;
        private int slot;

        public EntryIterator() {
            int seed = ShortFloatHashMap.this.nextIterationSeed();
            this.increment = HashContainers.iterationIncrement(seed);
            this.slot = seed & ShortFloatHashMap.this.mask;
        }

        @Override
        protected ShortFloatCursor fetch() {
            int mask = ShortFloatHashMap.this.mask;
            while (this.index <= mask) {
                ++this.index;
                this.slot = this.slot + this.increment & mask;
                short existing = ShortFloatHashMap.this.keys[this.slot];
                if (existing == 0) continue;
                this.cursor.index = this.slot;
                this.cursor.key = existing;
                this.cursor.value = ShortFloatHashMap.this.values[this.slot];
                return this.cursor;
            }
            if (this.index == mask + 1 && ShortFloatHashMap.this.hasEmptyKey) {
                this.cursor.index = this.index;
                this.cursor.key = 0;
                this.cursor.value = ShortFloatHashMap.this.values[this.index++];
                return this.cursor;
            }
            return (ShortFloatCursor)this.done();
        }
    }

    public final class KeysContainer
    extends AbstractShortCollection
    implements ShortLookupContainer {
        private final ShortFloatHashMap owner;

        public KeysContainer() {
            this.owner = ShortFloatHashMap.this;
        }

        @Override
        public boolean contains(short e) {
            return this.owner.containsKey(e);
        }

        @Override
        public <T extends ShortProcedure> T forEach(T procedure) {
            this.owner.forEach((k, v) -> procedure.apply(k));
            return procedure;
        }

        @Override
        public <T extends ShortPredicate> T forEach(T predicate) {
            this.owner.forEach((key, value) -> predicate.apply(key));
            return predicate;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<ShortCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(ShortPredicate predicate) {
            return this.owner.removeAll(predicate);
        }

        @Override
        public int removeAll(short e) {
            if (this.owner.containsKey(e)) {
                this.owner.remove(e);
                return 1;
            }
            return 0;
        }
    }

    private final class ValuesContainer
    extends AbstractFloatCollection {
        private final ShortFloatHashMap owner;

        private ValuesContainer() {
            this.owner = ShortFloatHashMap.this;
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public boolean contains(float value) {
            for (ShortFloatCursor c : this.owner) {
                if (Float.floatToIntBits(value) != Float.floatToIntBits(c.value)) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends FloatProcedure> T forEach(T procedure) {
            for (ShortFloatCursor c : this.owner) {
                procedure.apply(c.value);
            }
            return procedure;
        }

        @Override
        public <T extends FloatPredicate> T forEach(T predicate) {
            for (ShortFloatCursor c : this.owner) {
                if (predicate.apply(c.value)) continue;
                break;
            }
            return predicate;
        }

        @Override
        public Iterator<FloatCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public int removeAll(float e) {
            return this.owner.removeAll((short key, float value) -> Float.floatToIntBits(e) == Float.floatToIntBits(value));
        }

        @Override
        public int removeAll(FloatPredicate predicate) {
            return this.owner.removeAll((short key, float value) -> predicate.apply(value));
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public void release() {
            this.owner.release();
        }
    }

    private final class ValuesIterator
    extends AbstractIterator<FloatCursor> {
        private final FloatCursor cursor = new FloatCursor();
        private final int increment;
        private int index;
        private int slot;

        public ValuesIterator() {
            int seed = ShortFloatHashMap.this.nextIterationSeed();
            this.increment = HashContainers.iterationIncrement(seed);
            this.slot = seed & ShortFloatHashMap.this.mask;
        }

        @Override
        protected FloatCursor fetch() {
            int mask = ShortFloatHashMap.this.mask;
            while (this.index <= mask) {
                ++this.index;
                this.slot = this.slot + this.increment & mask;
                if (ShortFloatHashMap.this.keys[this.slot] == 0) continue;
                this.cursor.index = this.slot;
                this.cursor.value = ShortFloatHashMap.this.values[this.slot];
                return this.cursor;
            }
            if (this.index == mask + 1 && ShortFloatHashMap.this.hasEmptyKey) {
                this.cursor.index = this.index;
                this.cursor.value = ShortFloatHashMap.this.values[this.index++];
                return this.cursor;
            }
            return (FloatCursor)this.done();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<ShortCursor> {
        private final ShortCursor cursor = new ShortCursor();
        private final int increment;
        private int index;
        private int slot;

        public KeysIterator() {
            int seed = ShortFloatHashMap.this.nextIterationSeed();
            this.increment = HashContainers.iterationIncrement(seed);
            this.slot = seed & ShortFloatHashMap.this.mask;
        }

        @Override
        protected ShortCursor fetch() {
            int mask = ShortFloatHashMap.this.mask;
            while (this.index <= mask) {
                ++this.index;
                this.slot = this.slot + this.increment & mask;
                short existing = ShortFloatHashMap.this.keys[this.slot];
                if (existing == 0) continue;
                this.cursor.index = this.slot;
                this.cursor.value = existing;
                return this.cursor;
            }
            if (this.index == mask + 1 && ShortFloatHashMap.this.hasEmptyKey) {
                this.cursor.index = this.index++;
                this.cursor.value = 0;
                return this.cursor;
            }
            return (ShortCursor)this.done();
        }
    }
}

