/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.carrotsearch.hppc;

import com.dremio.jdbc.shaded.com.carrotsearch.hppc.AbstractCharCollection;
import com.dremio.jdbc.shaded.com.carrotsearch.hppc.AbstractIterator;
import com.dremio.jdbc.shaded.com.carrotsearch.hppc.AbstractLongCollection;
import com.dremio.jdbc.shaded.com.carrotsearch.hppc.CharCollection;
import com.dremio.jdbc.shaded.com.carrotsearch.hppc.CharContainer;
import com.dremio.jdbc.shaded.com.carrotsearch.hppc.CharLongAssociativeContainer;
import com.dremio.jdbc.shaded.com.carrotsearch.hppc.CharLongHashMap;
import com.dremio.jdbc.shaded.com.carrotsearch.hppc.CharLongMap;
import com.dremio.jdbc.shaded.com.carrotsearch.hppc.CharLookupContainer;
import com.dremio.jdbc.shaded.com.carrotsearch.hppc.LongContainer;
import com.dremio.jdbc.shaded.com.carrotsearch.hppc.comparators.CharComparator;
import com.dremio.jdbc.shaded.com.carrotsearch.hppc.comparators.CharLongComparator;
import com.dremio.jdbc.shaded.com.carrotsearch.hppc.cursors.CharCursor;
import com.dremio.jdbc.shaded.com.carrotsearch.hppc.cursors.CharLongCursor;
import com.dremio.jdbc.shaded.com.carrotsearch.hppc.cursors.LongCursor;
import com.dremio.jdbc.shaded.com.carrotsearch.hppc.predicates.CharLongPredicate;
import com.dremio.jdbc.shaded.com.carrotsearch.hppc.predicates.CharPredicate;
import com.dremio.jdbc.shaded.com.carrotsearch.hppc.predicates.LongPredicate;
import com.dremio.jdbc.shaded.com.carrotsearch.hppc.procedures.CharLongProcedure;
import com.dremio.jdbc.shaded.com.carrotsearch.hppc.procedures.CharProcedure;
import com.dremio.jdbc.shaded.com.carrotsearch.hppc.procedures.LongProcedure;
import com.dremio.jdbc.shaded.com.carrotsearch.hppc.sorting.QuickSort;
import java.util.Iterator;
import java.util.function.IntBinaryOperator;

public class SortedIterationCharLongHashMap
implements CharLongMap {
    public final CharLongHashMap delegate;
    public final int[] iterationOrder;

    public SortedIterationCharLongHashMap(CharLongHashMap delegate, CharComparator comparator) {
        this.delegate = delegate;
        this.iterationOrder = this.sortIterationOrder(this.createEntryIndexes(), comparator);
    }

    public SortedIterationCharLongHashMap(CharLongHashMap delegate, CharLongComparator comparator) {
        this.delegate = delegate;
        this.iterationOrder = this.sortIterationOrder(this.createEntryIndexes(), comparator);
    }

    private int[] createEntryIndexes() {
        char[] keys = this.delegate.keys;
        int size = this.delegate.size();
        int[] entryIndexes = new int[size];
        int entry = 0;
        if (this.delegate.hasEmptyKey) {
            entryIndexes[entry++] = this.delegate.mask + 1;
        }
        int keyIndex = 0;
        while (entry < size) {
            if (keys[keyIndex] != '\u0000') {
                entryIndexes[entry++] = keyIndex;
            }
            ++keyIndex;
        }
        return entryIndexes;
    }

    protected int[] sortIterationOrder(int[] entryIndexes, CharComparator comparator) {
        QuickSort.sort(entryIndexes, (i, j) -> {
            char[] keys = this.delegate.keys;
            return comparator.compare(keys[entryIndexes[i]], keys[entryIndexes[j]]);
        });
        return entryIndexes;
    }

    protected int[] sortIterationOrder(final int[] entryIndexes, final CharLongComparator comparator) {
        QuickSort.sort(entryIndexes, new IntBinaryOperator(){
            final char[] keys;
            final long[] values;
            {
                this.keys = SortedIterationCharLongHashMap.this.delegate.keys;
                this.values = SortedIterationCharLongHashMap.this.delegate.values;
            }

            @Override
            public int applyAsInt(int i, int j) {
                int index1 = entryIndexes[i];
                int index2 = entryIndexes[j];
                return comparator.compare(this.keys[index1], this.values[index1], this.keys[index2], this.values[index2]);
            }
        });
        return entryIndexes;
    }

    @Override
    public Iterator<CharLongCursor> iterator() {
        assert (this.checkUnmodified());
        return new EntryIterator();
    }

    @Override
    public boolean containsKey(char key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public int size() {
        assert (this.checkUnmodified());
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public int removeAll(CharContainer container) {
        throw SortedIterationCharLongHashMap.readOnlyException();
    }

    @Override
    public int removeAll(CharPredicate predicate) {
        throw SortedIterationCharLongHashMap.readOnlyException();
    }

    @Override
    public int removeAll(CharLongPredicate predicate) {
        throw SortedIterationCharLongHashMap.readOnlyException();
    }

    @Override
    public <T extends CharLongProcedure> T forEach(T procedure) {
        assert (this.checkUnmodified());
        int[] iterationOrder = this.iterationOrder;
        char[] keys = this.delegate.keys;
        long[] values = this.delegate.values;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            int slot = iterationOrder[i];
            procedure.apply(keys[slot], values[slot]);
        }
        return procedure;
    }

    @Override
    public <T extends CharLongPredicate> T forEach(T predicate) {
        int slot;
        assert (this.checkUnmodified());
        int[] iterationOrder = this.iterationOrder;
        char[] keys = this.delegate.keys;
        long[] values = this.delegate.values;
        int size = this.size();
        for (int i = 0; i < size && predicate.apply(keys[slot = iterationOrder[i]], values[slot]); ++i) {
        }
        return predicate;
    }

    @Override
    public CharCollection keys() {
        assert (this.checkUnmodified());
        return new KeysContainer();
    }

    @Override
    public LongContainer values() {
        assert (this.checkUnmodified());
        return new ValuesContainer();
    }

    @Override
    public long get(char key) {
        return this.delegate.get(key);
    }

    @Override
    public long getOrDefault(char key, long defaultValue) {
        return this.delegate.getOrDefault(key, defaultValue);
    }

    @Override
    public long put(char key, long value) {
        throw SortedIterationCharLongHashMap.readOnlyException();
    }

    @Override
    public int putAll(CharLongAssociativeContainer container) {
        throw SortedIterationCharLongHashMap.readOnlyException();
    }

    @Override
    public int putAll(Iterable<? extends CharLongCursor> iterable) {
        throw SortedIterationCharLongHashMap.readOnlyException();
    }

    @Override
    public long putOrAdd(char key, long putValue, long incrementValue) {
        throw SortedIterationCharLongHashMap.readOnlyException();
    }

    @Override
    public long addTo(char key, long additionValue) {
        throw SortedIterationCharLongHashMap.readOnlyException();
    }

    @Override
    public long remove(char key) {
        throw SortedIterationCharLongHashMap.readOnlyException();
    }

    @Override
    public int indexOf(char key) {
        return this.delegate.indexOf(key);
    }

    @Override
    public boolean indexExists(int index) {
        return this.delegate.indexExists(index);
    }

    @Override
    public long indexGet(int index) {
        return this.delegate.indexGet(index);
    }

    @Override
    public long indexReplace(int index, long newValue) {
        throw SortedIterationCharLongHashMap.readOnlyException();
    }

    @Override
    public void indexInsert(int index, char key, long value) {
        throw SortedIterationCharLongHashMap.readOnlyException();
    }

    @Override
    public long indexRemove(int index) {
        throw SortedIterationCharLongHashMap.readOnlyException();
    }

    @Override
    public void clear() {
        throw SortedIterationCharLongHashMap.readOnlyException();
    }

    @Override
    public void release() {
        throw SortedIterationCharLongHashMap.readOnlyException();
    }

    @Override
    public String visualizeKeyDistribution(int characters) {
        return this.delegate.visualizeKeyDistribution(characters);
    }

    private static RuntimeException readOnlyException() {
        throw new UnsupportedOperationException("Read-only view cannot be modified");
    }

    private boolean checkUnmodified() {
        assert (this.delegate.size() == this.iterationOrder.length) : "The delegate map changed; this is not supported by this read-only view";
        return true;
    }

    private final class EntryIterator
    extends AbstractIterator<CharLongCursor> {
        private final CharLongCursor cursor = new CharLongCursor();
        private int index;

        private EntryIterator() {
        }

        @Override
        protected CharLongCursor fetch() {
            if (this.index < SortedIterationCharLongHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationCharLongHashMap.this.iterationOrder[this.index++];
                this.cursor.key = SortedIterationCharLongHashMap.this.delegate.keys[slot];
                this.cursor.value = SortedIterationCharLongHashMap.this.delegate.values[slot];
                return this.cursor;
            }
            return (CharLongCursor)this.done();
        }
    }

    private final class KeysContainer
    extends AbstractCharCollection
    implements CharLookupContainer {
        private final SortedIterationCharLongHashMap owner;

        private KeysContainer() {
            this.owner = SortedIterationCharLongHashMap.this;
        }

        @Override
        public boolean contains(char e) {
            return this.owner.containsKey(e);
        }

        @Override
        public <T extends CharProcedure> T forEach(T procedure) {
            this.owner.forEach((k, v) -> procedure.apply(k));
            return procedure;
        }

        @Override
        public <T extends CharPredicate> T forEach(T predicate) {
            this.owner.forEach((key, value) -> predicate.apply(key));
            return predicate;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<CharCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public void clear() {
            throw SortedIterationCharLongHashMap.readOnlyException();
        }

        @Override
        public void release() {
            throw SortedIterationCharLongHashMap.readOnlyException();
        }

        @Override
        public int removeAll(CharPredicate predicate) {
            throw SortedIterationCharLongHashMap.readOnlyException();
        }

        @Override
        public int removeAll(char e) {
            throw SortedIterationCharLongHashMap.readOnlyException();
        }
    }

    private final class ValuesContainer
    extends AbstractLongCollection {
        private final SortedIterationCharLongHashMap owner;

        private ValuesContainer() {
            this.owner = SortedIterationCharLongHashMap.this;
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public boolean contains(long value) {
            for (CharLongCursor c : this.owner) {
                if (value != c.value) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends LongProcedure> T forEach(T procedure) {
            this.owner.forEach((k, v) -> procedure.apply(v));
            return procedure;
        }

        @Override
        public <T extends LongPredicate> T forEach(T predicate) {
            this.owner.forEach((k, v) -> predicate.apply(v));
            return predicate;
        }

        @Override
        public Iterator<LongCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public int removeAll(long e) {
            throw SortedIterationCharLongHashMap.readOnlyException();
        }

        @Override
        public int removeAll(LongPredicate predicate) {
            throw SortedIterationCharLongHashMap.readOnlyException();
        }

        @Override
        public void clear() {
            throw SortedIterationCharLongHashMap.readOnlyException();
        }

        @Override
        public void release() {
            throw SortedIterationCharLongHashMap.readOnlyException();
        }
    }

    private final class ValuesIterator
    extends AbstractIterator<LongCursor> {
        private final LongCursor cursor = new LongCursor();
        private int index;

        private ValuesIterator() {
        }

        @Override
        protected LongCursor fetch() {
            if (this.index < SortedIterationCharLongHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationCharLongHashMap.this.iterationOrder[this.index++];
                this.cursor.value = SortedIterationCharLongHashMap.this.delegate.values[slot];
                return this.cursor;
            }
            return (LongCursor)this.done();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<CharCursor> {
        private final CharCursor cursor = new CharCursor();
        private int index;

        private KeysIterator() {
        }

        @Override
        protected CharCursor fetch() {
            if (this.index < SortedIterationCharLongHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationCharLongHashMap.this.iterationOrder[this.index++];
                this.cursor.value = SortedIterationCharLongHashMap.this.delegate.keys[slot];
                return this.cursor;
            }
            return (CharCursor)this.done();
        }
    }
}

