/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.carrotsearch.hppc;

import com.dremio.jdbc.shaded.com.carrotsearch.hppc.AbstractIntCollection;
import com.dremio.jdbc.shaded.com.carrotsearch.hppc.AbstractIterator;
import com.dremio.jdbc.shaded.com.carrotsearch.hppc.IntCollection;
import com.dremio.jdbc.shaded.com.carrotsearch.hppc.IntContainer;
import com.dremio.jdbc.shaded.com.carrotsearch.hppc.IntIntAssociativeContainer;
import com.dremio.jdbc.shaded.com.carrotsearch.hppc.IntIntHashMap;
import com.dremio.jdbc.shaded.com.carrotsearch.hppc.IntIntMap;
import com.dremio.jdbc.shaded.com.carrotsearch.hppc.IntLookupContainer;
import com.dremio.jdbc.shaded.com.carrotsearch.hppc.comparators.IntComparator;
import com.dremio.jdbc.shaded.com.carrotsearch.hppc.comparators.IntIntComparator;
import com.dremio.jdbc.shaded.com.carrotsearch.hppc.cursors.IntCursor;
import com.dremio.jdbc.shaded.com.carrotsearch.hppc.cursors.IntIntCursor;
import com.dremio.jdbc.shaded.com.carrotsearch.hppc.predicates.IntIntPredicate;
import com.dremio.jdbc.shaded.com.carrotsearch.hppc.predicates.IntPredicate;
import com.dremio.jdbc.shaded.com.carrotsearch.hppc.procedures.IntIntProcedure;
import com.dremio.jdbc.shaded.com.carrotsearch.hppc.procedures.IntProcedure;
import com.dremio.jdbc.shaded.com.carrotsearch.hppc.sorting.QuickSort;
import java.util.Iterator;
import java.util.function.IntBinaryOperator;

public class SortedIterationIntIntHashMap
implements IntIntMap {
    public final IntIntHashMap delegate;
    public final int[] iterationOrder;

    public SortedIterationIntIntHashMap(IntIntHashMap delegate, IntComparator comparator) {
        this.delegate = delegate;
        this.iterationOrder = this.sortIterationOrder(this.createEntryIndexes(), comparator);
    }

    public SortedIterationIntIntHashMap(IntIntHashMap delegate, IntIntComparator comparator) {
        this.delegate = delegate;
        this.iterationOrder = this.sortIterationOrder(this.createEntryIndexes(), comparator);
    }

    private int[] createEntryIndexes() {
        int[] keys = this.delegate.keys;
        int size = this.delegate.size();
        int[] entryIndexes = new int[size];
        int entry = 0;
        if (this.delegate.hasEmptyKey) {
            entryIndexes[entry++] = this.delegate.mask + 1;
        }
        int keyIndex = 0;
        while (entry < size) {
            if (keys[keyIndex] != 0) {
                entryIndexes[entry++] = keyIndex;
            }
            ++keyIndex;
        }
        return entryIndexes;
    }

    protected int[] sortIterationOrder(int[] entryIndexes, IntComparator comparator) {
        QuickSort.sort(entryIndexes, (i, j) -> {
            int[] keys = this.delegate.keys;
            return comparator.compare(keys[entryIndexes[i]], keys[entryIndexes[j]]);
        });
        return entryIndexes;
    }

    protected int[] sortIterationOrder(final int[] entryIndexes, final IntIntComparator comparator) {
        QuickSort.sort(entryIndexes, new IntBinaryOperator(){
            final int[] keys;
            final int[] values;
            {
                this.keys = SortedIterationIntIntHashMap.this.delegate.keys;
                this.values = SortedIterationIntIntHashMap.this.delegate.values;
            }

            @Override
            public int applyAsInt(int i, int j) {
                int index1 = entryIndexes[i];
                int index2 = entryIndexes[j];
                return comparator.compare(this.keys[index1], this.values[index1], this.keys[index2], this.values[index2]);
            }
        });
        return entryIndexes;
    }

    @Override
    public Iterator<IntIntCursor> iterator() {
        assert (this.checkUnmodified());
        return new EntryIterator();
    }

    @Override
    public boolean containsKey(int key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public int size() {
        assert (this.checkUnmodified());
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public int removeAll(IntContainer container) {
        throw SortedIterationIntIntHashMap.readOnlyException();
    }

    @Override
    public int removeAll(IntPredicate predicate) {
        throw SortedIterationIntIntHashMap.readOnlyException();
    }

    @Override
    public int removeAll(IntIntPredicate predicate) {
        throw SortedIterationIntIntHashMap.readOnlyException();
    }

    @Override
    public <T extends IntIntProcedure> T forEach(T procedure) {
        assert (this.checkUnmodified());
        int[] iterationOrder = this.iterationOrder;
        int[] keys = this.delegate.keys;
        int[] values = this.delegate.values;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            int slot = iterationOrder[i];
            procedure.apply(keys[slot], values[slot]);
        }
        return procedure;
    }

    @Override
    public <T extends IntIntPredicate> T forEach(T predicate) {
        int slot;
        assert (this.checkUnmodified());
        int[] iterationOrder = this.iterationOrder;
        int[] keys = this.delegate.keys;
        int[] values = this.delegate.values;
        int size = this.size();
        for (int i = 0; i < size && predicate.apply(keys[slot = iterationOrder[i]], values[slot]); ++i) {
        }
        return predicate;
    }

    @Override
    public IntCollection keys() {
        assert (this.checkUnmodified());
        return new KeysContainer();
    }

    @Override
    public IntContainer values() {
        assert (this.checkUnmodified());
        return new ValuesContainer();
    }

    @Override
    public int get(int key) {
        return this.delegate.get(key);
    }

    @Override
    public int getOrDefault(int key, int defaultValue) {
        return this.delegate.getOrDefault(key, defaultValue);
    }

    @Override
    public int put(int key, int value) {
        throw SortedIterationIntIntHashMap.readOnlyException();
    }

    @Override
    public int putAll(IntIntAssociativeContainer container) {
        throw SortedIterationIntIntHashMap.readOnlyException();
    }

    @Override
    public int putAll(Iterable<? extends IntIntCursor> iterable) {
        throw SortedIterationIntIntHashMap.readOnlyException();
    }

    @Override
    public int putOrAdd(int key, int putValue, int incrementValue) {
        throw SortedIterationIntIntHashMap.readOnlyException();
    }

    @Override
    public int addTo(int key, int additionValue) {
        throw SortedIterationIntIntHashMap.readOnlyException();
    }

    @Override
    public int remove(int key) {
        throw SortedIterationIntIntHashMap.readOnlyException();
    }

    @Override
    public int indexOf(int key) {
        return this.delegate.indexOf(key);
    }

    @Override
    public boolean indexExists(int index) {
        return this.delegate.indexExists(index);
    }

    @Override
    public int indexGet(int index) {
        return this.delegate.indexGet(index);
    }

    @Override
    public int indexReplace(int index, int newValue) {
        throw SortedIterationIntIntHashMap.readOnlyException();
    }

    @Override
    public void indexInsert(int index, int key, int value) {
        throw SortedIterationIntIntHashMap.readOnlyException();
    }

    @Override
    public int indexRemove(int index) {
        throw SortedIterationIntIntHashMap.readOnlyException();
    }

    @Override
    public void clear() {
        throw SortedIterationIntIntHashMap.readOnlyException();
    }

    @Override
    public void release() {
        throw SortedIterationIntIntHashMap.readOnlyException();
    }

    @Override
    public String visualizeKeyDistribution(int characters) {
        return this.delegate.visualizeKeyDistribution(characters);
    }

    private static RuntimeException readOnlyException() {
        throw new UnsupportedOperationException("Read-only view cannot be modified");
    }

    private boolean checkUnmodified() {
        assert (this.delegate.size() == this.iterationOrder.length) : "The delegate map changed; this is not supported by this read-only view";
        return true;
    }

    private final class EntryIterator
    extends AbstractIterator<IntIntCursor> {
        private final IntIntCursor cursor = new IntIntCursor();
        private int index;

        private EntryIterator() {
        }

        @Override
        protected IntIntCursor fetch() {
            if (this.index < SortedIterationIntIntHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationIntIntHashMap.this.iterationOrder[this.index++];
                this.cursor.key = SortedIterationIntIntHashMap.this.delegate.keys[slot];
                this.cursor.value = SortedIterationIntIntHashMap.this.delegate.values[slot];
                return this.cursor;
            }
            return (IntIntCursor)this.done();
        }
    }

    private final class KeysContainer
    extends AbstractIntCollection
    implements IntLookupContainer {
        private final SortedIterationIntIntHashMap owner;

        private KeysContainer() {
            this.owner = SortedIterationIntIntHashMap.this;
        }

        @Override
        public boolean contains(int e) {
            return this.owner.containsKey(e);
        }

        @Override
        public <T extends IntProcedure> T forEach(T procedure) {
            this.owner.forEach((k, v) -> procedure.apply(k));
            return procedure;
        }

        @Override
        public <T extends IntPredicate> T forEach(T predicate) {
            this.owner.forEach((key, value) -> predicate.apply(key));
            return predicate;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<IntCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public void clear() {
            throw SortedIterationIntIntHashMap.readOnlyException();
        }

        @Override
        public void release() {
            throw SortedIterationIntIntHashMap.readOnlyException();
        }

        @Override
        public int removeAll(IntPredicate predicate) {
            throw SortedIterationIntIntHashMap.readOnlyException();
        }

        @Override
        public int removeAll(int e) {
            throw SortedIterationIntIntHashMap.readOnlyException();
        }
    }

    private final class ValuesContainer
    extends AbstractIntCollection {
        private final SortedIterationIntIntHashMap owner;

        private ValuesContainer() {
            this.owner = SortedIterationIntIntHashMap.this;
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public boolean contains(int value) {
            for (IntIntCursor c : this.owner) {
                if (value != c.value) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends IntProcedure> T forEach(T procedure) {
            this.owner.forEach((k, v) -> procedure.apply(v));
            return procedure;
        }

        @Override
        public <T extends IntPredicate> T forEach(T predicate) {
            this.owner.forEach((k, v) -> predicate.apply(v));
            return predicate;
        }

        @Override
        public Iterator<IntCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public int removeAll(int e) {
            throw SortedIterationIntIntHashMap.readOnlyException();
        }

        @Override
        public int removeAll(IntPredicate predicate) {
            throw SortedIterationIntIntHashMap.readOnlyException();
        }

        @Override
        public void clear() {
            throw SortedIterationIntIntHashMap.readOnlyException();
        }

        @Override
        public void release() {
            throw SortedIterationIntIntHashMap.readOnlyException();
        }
    }

    private final class ValuesIterator
    extends AbstractIterator<IntCursor> {
        private final IntCursor cursor = new IntCursor();
        private int index;

        private ValuesIterator() {
        }

        @Override
        protected IntCursor fetch() {
            if (this.index < SortedIterationIntIntHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationIntIntHashMap.this.iterationOrder[this.index++];
                this.cursor.value = SortedIterationIntIntHashMap.this.delegate.values[slot];
                return this.cursor;
            }
            return (IntCursor)this.done();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<IntCursor> {
        private final IntCursor cursor = new IntCursor();
        private int index;

        private KeysIterator() {
        }

        @Override
        protected IntCursor fetch() {
            if (this.index < SortedIterationIntIntHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationIntIntHashMap.this.iterationOrder[this.index++];
                this.cursor.value = SortedIterationIntIntHashMap.this.delegate.keys[slot];
                return this.cursor;
            }
            return (IntCursor)this.done();
        }
    }
}

