/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.carrotsearch.hppc.sorting;

import java.util.Comparator;
import java.util.function.IntBinaryOperator;

public final class IndirectSort {
    static int MIN_LENGTH_FOR_INSERTION_SORT = 30;

    private IndirectSort() {
    }

    public static int[] mergesort(int start, int length, IntBinaryOperator comparator) {
        int[] src = IndirectSort.createOrderArray(start, length);
        return IndirectSort.mergesort(src, comparator);
    }

    public static int[] mergesort(int[] orderArray, IntBinaryOperator comparator) {
        if (orderArray.length <= 1) {
            return orderArray;
        }
        int[] dst = (int[])orderArray.clone();
        IndirectSort.topDownMergeSort(orderArray, dst, 0, orderArray.length, comparator);
        return dst;
    }

    public static <T> int[] mergesort(T[] input, int start, int length, Comparator<? super T> comparator) {
        return IndirectSort.mergesort(start, length, (a, b) -> comparator.compare(input[a], input[b]));
    }

    private static void topDownMergeSort(int[] src, int[] dst, int fromIndex, int toIndex, IntBinaryOperator comp) {
        if (toIndex - fromIndex <= MIN_LENGTH_FOR_INSERTION_SORT) {
            IndirectSort.insertionSort(fromIndex, toIndex - fromIndex, dst, comp);
            return;
        }
        int mid = fromIndex + toIndex >>> 1;
        IndirectSort.topDownMergeSort(dst, src, fromIndex, mid, comp);
        IndirectSort.topDownMergeSort(dst, src, mid, toIndex, comp);
        if (comp.applyAsInt(src[mid - 1], src[mid]) <= 0) {
            System.arraycopy(src, fromIndex, dst, fromIndex, toIndex - fromIndex);
        } else {
            int i = fromIndex;
            int j = mid;
            for (int k = fromIndex; k < toIndex; ++k) {
                dst[k] = j == toIndex || i < mid && comp.applyAsInt(src[i], src[j]) <= 0 ? src[i++] : src[j++];
            }
        }
    }

    private static void insertionSort(int off, int len, int[] order, IntBinaryOperator intComparator) {
        for (int i = off + 1; i < off + len; ++i) {
            int t2;
            int v = order[i];
            int j = i;
            while (j > off && intComparator.applyAsInt(t2 = order[j - 1], v) > 0) {
                order[j--] = t2;
            }
            order[j] = v;
        }
    }

    private static int[] createOrderArray(int start, int length) {
        int[] order = new int[length];
        for (int i = 0; i < length; ++i) {
            order[i] = start + i;
        }
        return order;
    }
}

