/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.codahale.metrics.jetty9;

import com.dremio.jdbc.shaded.com.codahale.metrics.Counter;
import com.dremio.jdbc.shaded.com.codahale.metrics.Timer;
import com.dremio.jdbc.shaded.org.eclipse.jetty.io.Connection;
import com.dremio.jdbc.shaded.org.eclipse.jetty.io.EndPoint;
import com.dremio.jdbc.shaded.org.eclipse.jetty.server.ConnectionFactory;
import com.dremio.jdbc.shaded.org.eclipse.jetty.server.Connector;
import com.dremio.jdbc.shaded.org.eclipse.jetty.util.component.ContainerLifeCycle;
import java.util.List;

public class InstrumentedConnectionFactory
extends ContainerLifeCycle
implements ConnectionFactory {
    private final ConnectionFactory connectionFactory;
    private final Timer timer;
    private final Counter counter;

    public InstrumentedConnectionFactory(ConnectionFactory connectionFactory, Timer timer) {
        this(connectionFactory, timer, null);
    }

    public InstrumentedConnectionFactory(ConnectionFactory connectionFactory, Timer timer, Counter counter) {
        this.connectionFactory = connectionFactory;
        this.timer = timer;
        this.counter = counter;
        this.addBean(connectionFactory);
    }

    public String getProtocol() {
        return this.connectionFactory.getProtocol();
    }

    public List<String> getProtocols() {
        return this.connectionFactory.getProtocols();
    }

    public Connection newConnection(Connector connector, EndPoint endPoint) {
        Connection connection = this.connectionFactory.newConnection(connector, endPoint);
        connection.addListener(new Connection.Listener(){
            private Timer.Context context;

            public void onOpened(Connection connection) {
                this.context = InstrumentedConnectionFactory.this.timer.time();
                if (InstrumentedConnectionFactory.this.counter != null) {
                    InstrumentedConnectionFactory.this.counter.inc();
                }
            }

            public void onClosed(Connection connection) {
                this.context.stop();
                if (InstrumentedConnectionFactory.this.counter != null) {
                    InstrumentedConnectionFactory.this.counter.dec();
                }
            }
        });
        return connection;
    }
}

