/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.codahale.metrics.jmx;

import com.dremio.jdbc.shaded.com.codahale.metrics.jmx.JmxReporter;
import com.dremio.jdbc.shaded.com.codahale.metrics.jmx.ObjectNameFactory;
import com.dremio.jdbc.shaded.org.slf4j.Logger;
import com.dremio.jdbc.shaded.org.slf4j.LoggerFactory;
import java.util.Hashtable;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class DefaultObjectNameFactory
implements ObjectNameFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(JmxReporter.class);

    @Override
    public ObjectName createName(String type, String domain, String name) {
        try {
            Hashtable<String, String> properties = new Hashtable<String, String>();
            properties.put("name", name);
            properties.put("type", type);
            ObjectName objectName = new ObjectName(domain, properties);
            if (objectName.isDomainPattern()) {
                domain = ObjectName.quote(domain);
            }
            if (objectName.isPropertyValuePattern("name")) {
                properties.put("name", ObjectName.quote(name));
            }
            if (objectName.isPropertyValuePattern("type")) {
                properties.put("type", ObjectName.quote(type));
            }
            objectName = new ObjectName(domain, properties);
            return objectName;
        }
        catch (MalformedObjectNameException e) {
            try {
                return new ObjectName(domain, "name", ObjectName.quote(name));
            }
            catch (MalformedObjectNameException e1) {
                LOGGER.warn("Unable to register {} {}", type, name, e1);
                throw new RuntimeException(e1);
            }
        }
    }
}

