/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.codahale.metrics.jvm;

import com.dremio.jdbc.shaded.com.codahale.metrics.Gauge;
import com.dremio.jdbc.shaded.com.codahale.metrics.Metric;
import com.dremio.jdbc.shaded.com.codahale.metrics.MetricSet;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class JvmAttributeGaugeSet
implements MetricSet {
    private final RuntimeMXBean runtime;

    public JvmAttributeGaugeSet() {
        this(ManagementFactory.getRuntimeMXBean());
    }

    public JvmAttributeGaugeSet(RuntimeMXBean runtime) {
        this.runtime = runtime;
    }

    @Override
    public Map<String, Metric> getMetrics() {
        HashMap<String, Gauge<Object>> gauges = new HashMap<String, Gauge<Object>>();
        gauges.put("name", this.runtime::getName);
        gauges.put("vendor", () -> String.format(Locale.US, "%s %s %s (%s)", this.runtime.getVmVendor(), this.runtime.getVmName(), this.runtime.getVmVersion(), this.runtime.getSpecVersion()));
        gauges.put("uptime", this.runtime::getUptime);
        return Collections.unmodifiableMap(gauges);
    }
}

