/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.common;

import com.dremio.jdbc.shaded.com.dremio.common.DeferredException;
import java.util.LinkedList;

public abstract class EventProcessor<T> {
    private final LinkedList<T> queuedEvents = new LinkedList();
    private volatile boolean isProcessing = false;
    private volatile boolean started = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendEvent(T newEvent) {
        LinkedList<T> linkedList = this.queuedEvents;
        synchronized (linkedList) {
            this.queuedEvents.addLast(newEvent);
            if (!this.started || this.isProcessing) {
                return;
            }
            this.isProcessing = true;
        }
        this.processEvents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        LinkedList<T> linkedList = this.queuedEvents;
        synchronized (linkedList) {
            if (this.started) {
                return;
            }
            this.started = true;
            this.isProcessing = true;
        }
        this.processEvents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processEvents() {
        DeferredException deferredException = new DeferredException();
        while (true) {
            T event;
            LinkedList<T> linkedList = this.queuedEvents;
            synchronized (linkedList) {
                if (this.queuedEvents.isEmpty()) {
                    this.isProcessing = false;
                    break;
                }
                event = this.queuedEvents.removeFirst();
            }
            try {
                this.processEvent(event);
            }
            catch (Exception e) {
                deferredException.addException(e);
            }
            catch (AssertionError ae) {
                deferredException.addException(new RuntimeException("Caught an assertion", (Throwable)((Object)ae)));
            }
        }
        try {
            deferredException.close();
        }
        catch (Exception e) {
            throw new RuntimeException("Exceptions caught during event processing", e);
        }
    }

    protected abstract void processEvent(T var1);
}

