/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.common;

import com.dremio.jdbc.shaded.com.dremio.common.DeferredException;
import com.dremio.jdbc.shaded.com.dremio.service.Service;
import com.dremio.jdbc.shaded.com.google.common.annotations.VisibleForTesting;
import com.dremio.jdbc.shaded.com.google.common.base.Throwables;
import com.dremio.jdbc.shaded.com.google.inject.AbstractModule;
import com.dremio.jdbc.shaded.com.google.inject.Binding;
import com.dremio.jdbc.shaded.com.google.inject.Scopes;
import com.dremio.jdbc.shaded.com.google.inject.matcher.Matchers;
import com.dremio.jdbc.shaded.com.google.inject.spi.ProvisionListener;
import com.dremio.jdbc.shaded.org.slf4j.Logger;
import com.dremio.jdbc.shaded.org.slf4j.LoggerFactory;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class GuiceServiceModule
extends AbstractModule {
    private static final Logger logger = LoggerFactory.getLogger(GuiceServiceModule.class);
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private final Deque<Service> startedServices = new ArrayDeque<Service>();

    protected void configure() {
        this.binder().bindListener(Matchers.any(), new ProvisionListener[]{this::onProvisionInstance});
        this.binder().requireAtInjectOnConstructors();
        this.binder().requireExactBindingAnnotations();
        this.binder().disableCircularProxies();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void onProvisionInstance(ProvisionListener.ProvisionInvocation<T> provision) {
        Binding binding = provision.getBinding();
        Class targetType = binding.getKey().getTypeLiteral().getRawType();
        if (this.isClosed.get()) {
            throw new IllegalStateException("Unable to provision after close: " + String.valueOf(targetType));
        }
        Object object = provision.provision();
        if (!Service.class.isInstance(object)) {
            return;
        }
        if (!Scopes.isSingleton((Binding)binding)) {
            if (targetType.getSimpleName().endsWith("Factory")) {
                logger.debug("Provisioned Service is not a Singleton and will not be started: {} (for {})", object, (Object)targetType);
                return;
            }
            throw new IllegalStateException("Missing Singleton scope for service: " + String.valueOf(object) + " (for " + String.valueOf(targetType) + ")");
        }
        Service service = (Service)Service.class.cast(object);
        try {
            logger.info("Starting Service Singleton: {} (for {})", (Object)service, (Object)targetType);
            service.start();
            Deque<Service> deque = this.startedServices;
            synchronized (deque) {
                this.startedServices.push(service);
            }
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws Exception {
        if (this.isClosed.compareAndSet(false, true)) {
            Deque<Service> deque = this.startedServices;
            synchronized (deque) {
                try (DeferredException deferred = new DeferredException();){
                    this.startedServices.forEach(service -> deferred.suppressingClose(() -> this.closeServiceSingleton((Service)service)));
                }
            }
        }
    }

    private void closeServiceSingleton(Service service) {
        try {
            logger.info("Stopping Service Singleton: {}", (Object)service);
            service.close();
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }

    @VisibleForTesting
    protected List<Service> getServiceList() {
        return new ArrayList<Service>(this.startedServices);
    }
}

