/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.common;

import com.dremio.jdbc.shaded.com.dremio.exec.proto.beans.DremioExitCodes;
import com.dremio.jdbc.shaded.org.slf4j.Logger;
import com.dremio.jdbc.shaded.org.slf4j.LoggerFactory;
import java.io.PrintStream;

public final class ProcessExit {
    private static final Logger logger = LoggerFactory.getLogger("root");

    private ProcessExit() {
    }

    public static void exit(String message, DremioExitCodes code) {
        ProcessExit.exit(null, message, code);
    }

    public static void exitHeap(Throwable t2) {
        boolean heapExitCode = true;
        try {
            ProcessExit.exit(t2, "There was insufficient heap memory to continue operating.", DremioExitCodes.OUT_OF_HEAP_FAILURE);
        }
        finally {
            Runtime.getRuntime().halt(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exit(Throwable t2, String message, DremioExitCodes code) {
        try {
            logger.error("Dremio is exiting. {}", (Object)message, (Object)t2);
            PrintStream out = "true".equals(System.getProperty("dremio.catastrophic_to_standard_out", "true")) ? System.out : System.err;
            out.println("Dremio is exiting. " + message);
            if (t2 != null) {
                t2.printStackTrace(out);
            }
            out.flush();
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        finally {
            Runtime.getRuntime().halt(code.getNumber());
        }
    }
}

