/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.common;

import com.dremio.jdbc.shaded.com.dremio.context.RequestContext;
import com.dremio.jdbc.shaded.com.google.common.base.Preconditions;
import com.dremio.jdbc.shaded.org.slf4j.Logger;
import com.dremio.jdbc.shaded.org.slf4j.LoggerFactory;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Provider;

public class WakeupHandler {
    private static final Logger logger = LoggerFactory.getLogger(WakeupHandler.class);
    private final AtomicBoolean wakeup = new AtomicBoolean();
    private final AtomicBoolean running = new AtomicBoolean();
    private final Runnable manager;
    private final ExecutorService executor;
    private final Provider<RequestContext> requestContextProvider;

    public WakeupHandler(ExecutorService executor, Runnable manager) {
        this(executor, manager, null);
    }

    public WakeupHandler(ExecutorService executor, Runnable manager, Provider<RequestContext> requestContextProvider) {
        this.executor = Preconditions.checkNotNull(executor, "executor service required");
        this.manager = Preconditions.checkNotNull(manager, "runnable manager required");
        this.requestContextProvider = requestContextProvider;
    }

    public Future<?> handle(final String reason) {
        logger.trace("waking up manager, reason: {}", (Object)reason);
        if (!this.wakeup.compareAndSet(false, true)) {
            return CompletableFuture.completedFuture(null);
        }
        if (this.running.get()) {
            return CompletableFuture.completedFuture(null);
        }
        return this.executor.submit(new Runnable(){

            @Override
            public void run() {
                while (WakeupHandler.this.wakeup.get()) {
                    if (!WakeupHandler.this.running.compareAndSet(false, true)) {
                        return;
                    }
                    try {
                        WakeupHandler.this.wakeup.set(false);
                        if (WakeupHandler.this.requestContextProvider != null) {
                            ((RequestContext)WakeupHandler.this.requestContextProvider.get()).run(() -> WakeupHandler.this.manager.run());
                            continue;
                        }
                        WakeupHandler.this.manager.run();
                    }
                    catch (Exception e) {
                        logger.error("manager failed to run, reason: {}", (Object)reason, (Object)e);
                    }
                    finally {
                        WakeupHandler.this.running.set(false);
                    }
                }
            }
        });
    }
}

