/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.common.arrow;

import com.dremio.jdbc.shaded.com.dremio.common.serde.BackwardCompatibleSchemaDe;
import com.dremio.jdbc.shaded.com.google.common.base.Preconditions;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.types.pojo.ArrowType;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.types.pojo.Field;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.types.pojo.Schema;
import java.io.IOException;
import java.util.Map;

public final class DremioArrowSchema {
    public static final String DREMIO_ARROW_SCHEMA = "dremio.arrow.schema";
    public static final String DREMIO_ARROW_SCHEMA_2_1 = "dremio.arrow.schema.2.1";

    public static Schema fromJSON(String json) throws IOException {
        return BackwardCompatibleSchemaDe.fromJSON(json);
    }

    public static Schema fromMetaData(Map<String, String> properties) throws IOException {
        Preconditions.checkNotNull(properties);
        String jsonArrowSchema = properties.get(DREMIO_ARROW_SCHEMA);
        String jsonArrowSchema2_1 = properties.get(DREMIO_ARROW_SCHEMA_2_1);
        if (jsonArrowSchema != null) {
            return DremioArrowSchema.discardSchemaWithNullTypeUnits(DremioArrowSchema.fromJSON(jsonArrowSchema));
        }
        if (jsonArrowSchema2_1 != null) {
            return DremioArrowSchema.discardSchemaWithNullTypeUnits(DremioArrowSchema.fromJSON(jsonArrowSchema2_1));
        }
        return null;
    }

    private static Schema discardSchemaWithNullTypeUnits(Schema arrowSchema) {
        if (arrowSchema != null) {
            for (Field f : arrowSchema.getFields()) {
                if (f.getType().getTypeID() == ArrowType.ArrowTypeID.Date && ((ArrowType.Date)f.getType()).getUnit() == null) {
                    return null;
                }
                if (f.getType().getTypeID() == ArrowType.ArrowTypeID.Timestamp && ((ArrowType.Timestamp)f.getType()).getUnit() == null) {
                    return null;
                }
                if (f.getType().getTypeID() != ArrowType.ArrowTypeID.Time || ((ArrowType.Time)f.getType()).getUnit() != null) continue;
                return null;
            }
        }
        return arrowSchema;
    }

    public static boolean isArrowSchemaPresent(Map<String, String> properties) {
        Preconditions.checkNotNull(properties);
        String jsonArrowSchema = properties.get(DREMIO_ARROW_SCHEMA);
        String jsonArrowSchema2_1 = properties.get(DREMIO_ARROW_SCHEMA_2_1);
        return jsonArrowSchema != null || jsonArrowSchema2_1 != null;
    }
}

