/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.common.concurrent;

import com.dremio.jdbc.shaded.com.dremio.common.concurrent.NamedThreadFactory;
import com.dremio.jdbc.shaded.com.google.common.base.Preconditions;
import com.dremio.jdbc.shaded.org.slf4j.Logger;
import com.dremio.jdbc.shaded.org.slf4j.LoggerFactory;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class CloseableSchedulerThreadPool
extends ScheduledThreadPoolExecutor
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(CloseableSchedulerThreadPool.class);
    private final String name;

    public CloseableSchedulerThreadPool(String name, int corePoolSize) {
        super(corePoolSize, new NamedThreadFactory(name));
        this.name = name;
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t2) {
        if (t2 != null) {
            logger.error("{}.run() leaked an exception.", (Object)r.getClass().getName(), (Object)t2);
        }
        super.afterExecute(r, t2);
    }

    @Override
    public void close() {
        CloseableSchedulerThreadPool.close(this, logger);
    }

    public static void close(ExecutorService executor, Logger logger) {
        executor.shutdown();
        try {
            if (!executor.awaitTermination(1L, TimeUnit.SECONDS)) {
                executor.shutdownNow();
                if (!executor.awaitTermination(1L, TimeUnit.SECONDS)) {
                    logger.error("Pool did not terminate");
                }
            }
        }
        catch (InterruptedException ie) {
            logger.warn("Executor interrupted while awaiting termination");
            executor.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public static AutoCloseable of(final ExecutorService executor, final Logger logger) {
        Preconditions.checkNotNull(executor);
        Preconditions.checkNotNull(logger);
        return new AutoCloseable(){

            @Override
            public void close() throws Exception {
                CloseableSchedulerThreadPool.close(executor, logger);
            }
        };
    }
}

