/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.common.concurrent;

import com.dremio.jdbc.shaded.com.dremio.common.concurrent.CloseableExecutorService;
import com.dremio.jdbc.shaded.com.dremio.common.concurrent.CloseableSchedulerThreadPool;
import com.dremio.jdbc.shaded.com.dremio.common.concurrent.NamedThreadFactory;
import com.dremio.jdbc.shaded.org.slf4j.Logger;
import com.dremio.jdbc.shaded.org.slf4j.LoggerFactory;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class CloseableThreadPool
extends ThreadPoolExecutor
implements CloseableExecutorService {
    private static final Logger logger = LoggerFactory.getLogger(CloseableThreadPool.class);

    public static CloseableThreadPool newSingleThreadExecutor(String name) {
        return CloseableThreadPool.newFixedThreadPool(name, 1);
    }

    public static CloseableThreadPool newFixedThreadPool(String name, int fixedPoolSize) {
        return new CloseableThreadPool(name, fixedPoolSize, fixedPoolSize, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
    }

    public static CloseableThreadPool newCachedThreadPool(String name) {
        return new CloseableThreadPool(name);
    }

    @Deprecated
    public CloseableThreadPool(String name) {
        this(name, 0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
    }

    public CloseableThreadPool(String name, int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, new NamedThreadFactory(name));
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t2) {
        if (t2 != null) {
            logger.error("{}.run() leaked an exception.", (Object)r.getClass().getName(), (Object)t2);
        }
        super.afterExecute(r, t2);
    }

    @Override
    public void close() {
        CloseableSchedulerThreadPool.close(this, logger);
    }
}

