/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.common.concurrent;

import com.dremio.jdbc.shaded.io.opentelemetry.context.Context;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class ContextAwareCompletableFuture<T>
extends CompletableFuture<T> {
    private final Context context;

    public ContextAwareCompletableFuture() {
        this.context = Context.current();
    }

    public ContextAwareCompletableFuture(Context context) {
        this.context = context;
    }

    private ContextAwareCompletableFuture(Context context, CompletionStage<T> dep) {
        this.context = context;
        dep.whenComplete((? super T result, ? super Throwable error) -> {
            if (error == null) {
                this.complete(result);
            } else {
                this.completeExceptionally((Throwable)error);
            }
        });
    }

    public static <U> ContextAwareCompletableFuture<U> of(U result) {
        ContextAwareCompletableFuture<U> cf = new ContextAwareCompletableFuture<U>();
        cf.complete(result);
        return cf;
    }

    public static <U> ContextAwareCompletableFuture<U> createFrom(CompletionStage<U> dep) {
        return ContextAwareCompletableFuture.createFrom(dep, Context.current());
    }

    public static <U> ContextAwareCompletableFuture<U> createFrom(CompletionStage<U> dep, Context context) {
        if (dep instanceof ContextAwareCompletableFuture) {
            ContextAwareCompletableFuture contextAware = (ContextAwareCompletableFuture)dep;
            if (contextAware.context == context) {
                return contextAware;
            }
        }
        return new ContextAwareCompletableFuture<U>(context, dep);
    }

    @Override
    public <U> CompletableFuture<U> thenApply(Function<? super T, ? extends U> fn) {
        return super.thenApply((Function)this.context.wrapFunction(fn));
    }

    @Override
    public <U> CompletableFuture<U> thenApplyAsync(Function<? super T, ? extends U> fn) {
        return super.thenApplyAsync((Function)this.context.wrapFunction(fn));
    }

    @Override
    public <U> CompletableFuture<U> thenApplyAsync(Function<? super T, ? extends U> fn, Executor executor) {
        return super.thenApplyAsync((Function)this.context.wrapFunction(fn), executor);
    }

    @Override
    public CompletableFuture<Void> thenAccept(Consumer<? super T> action) {
        return super.thenAccept((Consumer)this.context.wrapConsumer(action));
    }

    @Override
    public CompletableFuture<Void> thenAcceptAsync(Consumer<? super T> action) {
        return super.thenAcceptAsync((Consumer)this.context.wrapConsumer(action));
    }

    @Override
    public CompletableFuture<Void> thenAcceptAsync(Consumer<? super T> action, Executor executor) {
        return super.thenAcceptAsync((Consumer)this.context.wrapConsumer(action), executor);
    }

    @Override
    public CompletableFuture<Void> thenRun(Runnable action) {
        return super.thenRun(this.context.wrap(action));
    }

    @Override
    public CompletableFuture<Void> thenRunAsync(Runnable action) {
        return super.thenRunAsync(this.context.wrap(action));
    }

    @Override
    public CompletableFuture<Void> thenRunAsync(Runnable action, Executor executor) {
        return super.thenRunAsync(this.context.wrap(action), executor);
    }

    @Override
    public <U, V> CompletableFuture<V> thenCombine(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn) {
        return super.thenCombine((CompletionStage)other, (BiFunction)this.context.wrapFunction(fn));
    }

    @Override
    public <U, V> CompletableFuture<V> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn) {
        return super.thenCombineAsync((CompletionStage)other, (BiFunction)this.context.wrapFunction(fn));
    }

    @Override
    public <U, V> CompletableFuture<V> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn, Executor executor) {
        return super.thenCombineAsync((CompletionStage)other, (BiFunction)this.context.wrapFunction(fn), executor);
    }

    @Override
    public <U> CompletableFuture<Void> thenAcceptBoth(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action) {
        return super.thenAcceptBoth((CompletionStage)other, (BiConsumer)this.context.wrapConsumer(action));
    }

    @Override
    public <U> CompletableFuture<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action) {
        return super.thenAcceptBothAsync((CompletionStage)other, (BiConsumer)this.context.wrapConsumer(action));
    }

    @Override
    public <U> CompletableFuture<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action, Executor executor) {
        return super.thenAcceptBothAsync((CompletionStage)other, (BiConsumer)this.context.wrapConsumer(action), executor);
    }

    @Override
    public CompletableFuture<Void> runAfterBoth(CompletionStage<?> other, Runnable action) {
        return super.runAfterBoth((CompletionStage)other, this.context.wrap(action));
    }

    @Override
    public CompletableFuture<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action) {
        return super.runAfterBothAsync((CompletionStage)other, this.context.wrap(action));
    }

    @Override
    public CompletableFuture<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        return super.runAfterBothAsync((CompletionStage)other, this.context.wrap(action), executor);
    }

    @Override
    public <U> CompletableFuture<U> applyToEither(CompletionStage<? extends T> other, Function<? super T, U> fn) {
        return super.applyToEither((CompletionStage)other, (Function)this.context.wrapFunction(fn));
    }

    @Override
    public <U> CompletableFuture<U> applyToEitherAsync(CompletionStage<? extends T> other, Function<? super T, U> fn) {
        return super.applyToEitherAsync((CompletionStage)other, (Function)this.context.wrapFunction(fn));
    }

    @Override
    public <U> CompletableFuture<U> applyToEitherAsync(CompletionStage<? extends T> other, Function<? super T, U> fn, Executor executor) {
        return super.applyToEitherAsync((CompletionStage)other, (Function)this.context.wrapFunction(fn), executor);
    }

    @Override
    public CompletableFuture<Void> acceptEither(CompletionStage<? extends T> other, Consumer<? super T> action) {
        return super.acceptEither((CompletionStage)other, (Consumer)this.context.wrapConsumer(action));
    }

    @Override
    public CompletableFuture<Void> acceptEitherAsync(CompletionStage<? extends T> other, Consumer<? super T> action) {
        return super.acceptEitherAsync((CompletionStage)other, (Consumer)this.context.wrapConsumer(action));
    }

    @Override
    public CompletableFuture<Void> acceptEitherAsync(CompletionStage<? extends T> other, Consumer<? super T> action, Executor executor) {
        return super.acceptEitherAsync((CompletionStage)other, (Consumer)this.context.wrapConsumer(action), executor);
    }

    @Override
    public CompletableFuture<Void> runAfterEither(CompletionStage<?> other, Runnable action) {
        return super.runAfterEither((CompletionStage)other, this.context.wrap(action));
    }

    @Override
    public CompletableFuture<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action) {
        return super.runAfterEitherAsync((CompletionStage)other, this.context.wrap(action));
    }

    @Override
    public CompletableFuture<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        return super.runAfterEitherAsync((CompletionStage)other, this.context.wrap(action), executor);
    }

    @Override
    public <U> CompletableFuture<U> thenCompose(Function<? super T, ? extends CompletionStage<U>> fn) {
        return super.thenCompose((Function)this.context.wrapFunction(fn));
    }

    @Override
    public <U> CompletableFuture<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> fn) {
        return super.thenComposeAsync((Function)this.context.wrapFunction(fn));
    }

    @Override
    public <U> CompletableFuture<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> fn, Executor executor) {
        return super.thenComposeAsync((Function)this.context.wrapFunction(fn), executor);
    }

    @Override
    public CompletableFuture<T> whenComplete(BiConsumer<? super T, ? super Throwable> action) {
        return super.whenComplete((BiConsumer)this.context.wrapConsumer(action));
    }

    @Override
    public CompletableFuture<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> action) {
        return super.whenCompleteAsync((BiConsumer)this.context.wrapConsumer(action));
    }

    @Override
    public CompletableFuture<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> action, Executor executor) {
        return super.whenCompleteAsync((BiConsumer)this.context.wrapConsumer(action), executor);
    }

    @Override
    public <U> CompletableFuture<U> handle(BiFunction<? super T, Throwable, ? extends U> fn) {
        return super.handle((BiFunction)this.context.wrapFunction(fn));
    }

    @Override
    public <U> CompletableFuture<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> fn) {
        return super.handleAsync((BiFunction)this.context.wrapFunction(fn));
    }

    @Override
    public <U> CompletableFuture<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> fn, Executor executor) {
        return super.handleAsync((BiFunction)this.context.wrapFunction(fn), executor);
    }

    @Override
    public CompletableFuture<T> exceptionally(Function<Throwable, ? extends T> fn) {
        return super.exceptionally((Function)this.context.wrapFunction(fn));
    }

    @Override
    public <U> CompletableFuture<U> newIncompleteFuture() {
        return new ContextAwareCompletableFuture<T>(this.context);
    }

    @Override
    public CompletableFuture<T> completeAsync(Supplier<? extends T> supplier, Executor executor) {
        return super.completeAsync(this.context.wrapSupplier(supplier), executor);
    }

    @Override
    public CompletableFuture<T> completeAsync(Supplier<? extends T> supplier) {
        return super.completeAsync(this.context.wrapSupplier(supplier));
    }
}

