/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.common.concurrent;

import com.dremio.jdbc.shaded.com.dremio.common.concurrent.CloseableExecutorService;
import com.dremio.jdbc.shaded.com.dremio.common.concurrent.ContextMigratingRunnableTask;
import com.dremio.jdbc.shaded.com.dremio.common.concurrent.ContextMigratingTask;
import com.dremio.jdbc.shaded.com.dremio.common.tracing.TracingUtils;
import com.dremio.jdbc.shaded.com.dremio.common.util.Closeable;
import com.dremio.jdbc.shaded.com.dremio.context.RequestContext;
import com.dremio.jdbc.shaded.com.google.common.base.Preconditions;
import com.dremio.jdbc.shaded.io.opentracing.Scope;
import com.dremio.jdbc.shaded.io.opentracing.Span;
import com.dremio.jdbc.shaded.io.opentracing.Tracer;
import com.dremio.jdbc.shaded.io.opentracing.noop.NoopTracerFactory;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;

public class ContextMigratingExecutorService<E extends ExecutorService>
implements ExecutorService {
    public static final String WORK_OPERATION_NAME = "thread-pool-work";
    public static final String WAITING_OPERATION_NAME = "blocked-on-thread-pool";
    private final E delegate;
    private final Tracer tracer;

    public ContextMigratingExecutorService(E delegate) {
        this.delegate = delegate;
        this.tracer = NoopTracerFactory.create();
    }

    public static Runnable makeContextMigratingTask(final Runnable runnable, final String taskName) {
        return new ContextMigratingRunnableTask(){

            @Override
            public String getSpanName() {
                return taskName;
            }

            @Override
            public void run() {
                runnable.run();
            }
        };
    }

    @Override
    public void shutdown() {
        this.delegate.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.delegate.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.awaitTermination(timeout, unit);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.delegate.submit(this.decorate(task));
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.delegate.submit(this.decorate(task), result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.delegate.submit(this.decorate(task));
    }

    @Override
    public void execute(Runnable command) {
        this.delegate.execute(this.decorate(command));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        throw new UnsupportedOperationException("ContextMigrator does not support invoke methods.");
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        throw new UnsupportedOperationException("ContextMigrator does not support invoke methods.");
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        throw new UnsupportedOperationException("ContextMigrator does not support invoke methods.");
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        throw new UnsupportedOperationException("ContextMigrator does not support invoke methods.");
    }

    private Span makeWaitingSpan() {
        return TracingUtils.buildChildSpan(this.tracer, WAITING_OPERATION_NAME, new String[0]);
    }

    <T> Callable<T> decorate(Callable<T> inner) {
        Span parentSpan = this.tracer.activeSpan();
        Span waitingSpan = this.makeWaitingSpan();
        RequestContext savedContext = RequestContext.current();
        return () -> {
            String childSpanName = inner instanceof ContextMigratingTask ? ((ContextMigratingTask)((Object)inner)).getSpanName() : WORK_OPERATION_NAME;
            Span workSpan = ContextMigratingExecutorService.atTaskStart(this.tracer, waitingSpan, parentSpan, childSpanName);
            try {
                Scope s2 = this.tracer.activateSpan(workSpan);
                try {
                    Object v = savedContext.call(inner);
                    if (s2 != null) {
                        s2.close();
                    }
                    return v;
                }
                catch (Throwable throwable) {
                    if (s2 != null) {
                        try {
                            s2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
            finally {
                workSpan.finish();
            }
        };
    }

    public static Closeable getCloseableSpan(Tracer tracer, Span parentSpan, String spanName) {
        Thread thisThread = Thread.currentThread();
        Span childSpan = TracingUtils.childSpanBuilder(tracer, parentSpan, spanName, "thread-group", thisThread.getThreadGroup().getName(), "thread-name", thisThread.getName()).start();
        return () -> childSpan.finish();
    }

    private static Span atTaskStart(Tracer tracer, Span waitingSpan, Span parentSpan, String spanName) {
        Thread thisThread = Thread.currentThread();
        waitingSpan.finish();
        return TracingUtils.childSpanBuilder(tracer, parentSpan, spanName, "thread-group", thisThread.getThreadGroup().getName(), "thread-name", thisThread.getName()).start();
    }

    Runnable decorate(Runnable inner) {
        Span parentSpan = this.tracer.activeSpan();
        Span waitingSpan = this.makeWaitingSpan();
        Function<Runnable, Runnable> factory = inner instanceof Comparable ? runnable -> new ComparableRunnable(inner, (Runnable)runnable) : runnable -> runnable;
        RequestContext savedContext = RequestContext.current();
        return factory.apply(() -> {
            String childSpanName = inner instanceof ContextMigratingTask ? ((ContextMigratingTask)((Object)inner)).getSpanName() : WORK_OPERATION_NAME;
            Span workSpan = ContextMigratingExecutorService.atTaskStart(this.tracer, waitingSpan, parentSpan, childSpanName);
            try (Scope s2 = this.tracer.activateSpan(workSpan);){
                savedContext.run(inner);
            }
            finally {
                workSpan.finish();
            }
        });
    }

    public E getDelegate() {
        return this.delegate;
    }

    private static class ComparableRunnable
    implements Comparable<ComparableRunnable>,
    Runnable {
        private final Runnable comparableDelegate;
        private final Runnable work;

        ComparableRunnable(Runnable original, Runnable work) {
            Preconditions.checkArgument(original instanceof Comparable, "The delegate must be comparable");
            this.comparableDelegate = original;
            this.work = work;
        }

        @Override
        public int compareTo(ComparableRunnable o) {
            return ((Comparable)((Object)this.comparableDelegate)).compareTo(o.comparableDelegate);
        }

        @Override
        public void run() {
            this.work.run();
        }
    }

    public static class ContextMigratingCloseableExecutorService<C extends AutoCloseable & ExecutorService>
    extends ContextMigratingExecutorService<C>
    implements CloseableExecutorService {
        private final C delegate;

        public ContextMigratingCloseableExecutorService(C delegate) {
            super(delegate);
            this.delegate = delegate;
        }

        @Override
        public void close() {
            try {
                this.delegate.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

