/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.common.concurrent;

import com.dremio.jdbc.shaded.org.slf4j.Logger;
import com.dremio.jdbc.shaded.org.slf4j.LoggerFactory;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class ExtendedLatch
extends CountDownLatch {
    private static final Logger logger = LoggerFactory.getLogger(ExtendedLatch.class);

    public ExtendedLatch() {
        super(1);
    }

    public ExtendedLatch(int count) {
        super(count);
    }

    public boolean awaitUninterruptibly(long waitMillis) {
        long targetMillis = System.currentTimeMillis() + waitMillis;
        while (System.currentTimeMillis() < targetMillis) {
            long wait = targetMillis - System.currentTimeMillis();
            if (wait < 1L) {
                return false;
            }
            try {
                return this.await(wait, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
            }
        }
        return false;
    }

    public void awaitUninterruptibly() {
        while (true) {
            try {
                this.await();
                return;
            }
            catch (InterruptedException e) {
                logger.warn("Interrupted while waiting for event latch.", e);
                continue;
            }
            break;
        }
    }
}

