/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.common.concurrent;

import com.dremio.jdbc.shaded.org.slf4j.Logger;
import com.dremio.jdbc.shaded.org.slf4j.LoggerFactory;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class NamedThreadFactory
implements ThreadFactory {
    private static final Logger logger = LoggerFactory.getLogger(NamedThreadFactory.class);
    private final AtomicInteger nextId = new AtomicInteger();
    private final String prefix;

    public NamedThreadFactory(String prefix) {
        this.prefix = prefix;
    }

    @Override
    public Thread newThread(Runnable runnable) {
        Thread thread = new Thread(runnable, this.prefix + this.nextId.incrementAndGet());
        thread.setDaemon(true);
        try {
            if (thread.getPriority() != 10) {
                thread.setPriority(10);
            }
        }
        catch (Exception ignored) {
            logger.info("ignored exception " + String.valueOf(ignored));
        }
        return thread;
    }
}

