/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.common.concurrent.bulk;

import com.dremio.jdbc.shaded.com.dremio.common.concurrent.bulk.BulkFunction;
import com.dremio.jdbc.shaded.com.dremio.common.concurrent.bulk.BulkResponse;
import com.dremio.jdbc.shaded.com.dremio.common.concurrent.bulk.ValueTransformer;
import com.dremio.jdbc.shaded.com.google.common.base.Stopwatch;
import com.dremio.jdbc.shaded.com.google.common.collect.ImmutableMap;
import com.dremio.jdbc.shaded.com.google.common.collect.Multimap;
import com.dremio.jdbc.shaded.com.google.common.collect.MultimapBuilder;
import com.dremio.jdbc.shaded.org.apache.commons.lang3.mutable.MutableLong;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class BulkRequest<KEY> {
    private final Map<KEY, Long> requests;

    BulkRequest(Set<KEY> requests) {
        this.requests = requests.stream().collect(Collectors.toMap(Function.identity(), r -> 0L));
    }

    BulkRequest(Map<KEY, Long> requests) {
        this.requests = requests;
    }

    public Set<KEY> requests() {
        return Collections.unmodifiableSet(this.requests.keySet());
    }

    public int size() {
        return this.requests.size();
    }

    public void forEach(Consumer<? super KEY> action) {
        this.requests.keySet().forEach(action);
    }

    public <PAR> Map<PAR, BulkRequest<KEY>> partition(Function<KEY, PAR> partitioner) {
        Map<Object, Map<Object, Long>> partitionedRequests = this.requests.entrySet().stream().collect(Collectors.groupingBy(e -> partitioner.apply(e.getKey()), Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        return partitionedRequests.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new BulkRequest((Map)entry.getValue())));
    }

    public <VAL> BulkResponse<KEY, VAL> handleRequests(VAL constantResponseValue) {
        BulkResponse.Builder responseBuilder = BulkResponse.builder(this.requests.size());
        this.requests.forEach((? super K key, ? super V elapsed) -> responseBuilder.add(key, CompletableFuture.completedFuture(constantResponseValue), (long)elapsed));
        return responseBuilder.build();
    }

    public <VAL> BulkResponse<KEY, VAL> handleRequests(Function<KEY, CompletionStage<VAL>> asyncValueSupplier) {
        BulkResponse.Builder responseBuilder = BulkResponse.builder(this.requests.size());
        this.requests.forEach((? super K key, ? super V elapsed) -> {
            MutableLong elapsedNanos = new MutableLong((Number)elapsed);
            Stopwatch stopwatch = Stopwatch.createStarted();
            try {
                CompletionStage asyncVal = (CompletionStage)asyncValueSupplier.apply(key);
                elapsedNanos.add(stopwatch.elapsed().toNanos());
                asyncVal = BulkRequest.timedFuture(asyncVal, elapsedNanos);
                responseBuilder.add(key, asyncVal, elapsedNanos);
            }
            catch (Exception ex) {
                elapsedNanos.add(stopwatch.elapsed().toNanos());
                CompletableFuture failed = CompletableFuture.failedFuture(ex);
                responseBuilder.add(key, failed, elapsedNanos);
            }
        });
        return responseBuilder.build();
    }

    public <VAL, KEY2> BulkResponse<KEY, VAL> bulkTransformAndHandleRequests(BulkFunction<KEY2, VAL> bulkFunction, Function<KEY, KEY2> keyTransformer) {
        Multimap reverseKeyLookup = MultimapBuilder.hashKeys(this.size()).arrayListValues().build();
        HashMap keyTransformationTime = new HashMap();
        Builder<KEY> requestBuilder = BulkRequest.builder(this.size());
        BulkResponse.Builder responseBuilder = BulkResponse.builder(this.size());
        BulkRequest.transformKeys(this.requests, keyTransformer, reverseKeyLookup, keyTransformationTime, requestBuilder, responseBuilder);
        BulkRequest<KEY> transformedRequest = requestBuilder.build();
        BulkResponse<KEY2, VAL> responses = bulkFunction.apply(transformedRequest);
        responses.forEach((? super BulkResponse.Response<KEY, VAL> response) -> {
            Collection originalKeys = reverseKeyLookup.get(response.key());
            originalKeys.forEach((? super T originalKey) -> {
                MutableLong elapsedNanos = new MutableLong((Number)keyTransformationTime.get(originalKey));
                CompletionStage asyncVal = BulkRequest.addElapsedTime(response, elapsedNanos);
                responseBuilder.add(originalKey, asyncVal, elapsedNanos);
            });
        });
        return responseBuilder.build();
    }

    public <VAL, KEY2, VAL2> BulkResponse<KEY, VAL> bulkTransformAndHandleRequests(BulkFunction<KEY2, VAL2> bulkFunction, Function<KEY, KEY2> keyTransformer, ValueTransformer<KEY2, VAL2, KEY, VAL> valueTransformer) {
        Multimap reverseKeyLookup = MultimapBuilder.hashKeys(this.size()).arrayListValues().build();
        HashMap keyTransformationTime = new HashMap();
        Builder<KEY> requestBuilder = BulkRequest.builder(this.size());
        BulkResponse.Builder responseBuilder = BulkResponse.builder(this.size());
        BulkRequest.transformKeys(this.requests, keyTransformer, reverseKeyLookup, keyTransformationTime, requestBuilder, responseBuilder);
        BulkRequest<KEY> transformedRequest = requestBuilder.build();
        BulkResponse<KEY2, VAL2> responses = bulkFunction.apply(transformedRequest);
        responses.forEach((? super BulkResponse.Response<KEY, VAL> response) -> {
            Collection originalKeys = reverseKeyLookup.get(response.key());
            originalKeys.forEach((? super T originalKey) -> {
                MutableLong elapsedNanos = new MutableLong((Number)keyTransformationTime.get(originalKey));
                BulkResponse.Response transformedResponse = response.transform(ignored -> originalKey, valueTransformer);
                CompletionStage asyncVal = BulkRequest.addElapsedTime(transformedResponse, elapsedNanos);
                responseBuilder.add(originalKey, asyncVal, elapsedNanos);
            });
        });
        return responseBuilder.build();
    }

    public <VAL, KEY2, VAL2> BulkResponse<KEY, VAL> bulkTransformAndHandleRequestsAsync(BulkFunction<KEY2, VAL2> bulkFunction, Function<KEY, KEY2> keyTransformer, ValueTransformer<KEY2, VAL2, KEY, CompletionStage<VAL>> valueTransformer) {
        Multimap reverseKeyLookup = MultimapBuilder.hashKeys(this.size()).arrayListValues().build();
        HashMap keyTransformationTime = new HashMap();
        Builder<KEY> requestBuilder = BulkRequest.builder(this.size());
        BulkResponse.Builder responseBuilder = BulkResponse.builder(this.size());
        BulkRequest.transformKeys(this.requests, keyTransformer, reverseKeyLookup, keyTransformationTime, requestBuilder, responseBuilder);
        BulkRequest<KEY> transformedRequest = requestBuilder.build();
        BulkResponse<KEY2, VAL2> responses = bulkFunction.apply(transformedRequest);
        responses.forEach((? super BulkResponse.Response<KEY, VAL> response) -> {
            Collection originalKeys = reverseKeyLookup.get(response.key());
            originalKeys.forEach((? super T originalKey) -> {
                MutableLong elapsedNanos = new MutableLong((Number)keyTransformationTime.get(originalKey));
                BulkResponse.Response transformedResponse = response.transformAsync(ignored -> originalKey, valueTransformer);
                CompletionStage asyncVal = BulkRequest.addElapsedTime(transformedResponse, elapsedNanos);
                responseBuilder.add(originalKey, asyncVal, elapsedNanos);
            });
        });
        return responseBuilder.build();
    }

    public <PAR, VAL, KEY2, VAL2> BulkResponse<KEY, VAL> bulkPartitionAndHandleRequests(Function<KEY, PAR> partitioner, Function<PAR, BulkFunction<KEY2, VAL2>> partitionBulkFunction, Function<KEY, KEY2> keyTransformer, ValueTransformer<KEY2, VAL2, KEY, VAL> valueTransformer) {
        Map<Object, Map<Object, Long>> partitionedRequests = this.requests.entrySet().stream().collect(Collectors.groupingBy(e -> partitioner.apply(e.getKey()), Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        return partitionedRequests.entrySet().stream().map(entry -> {
            Object partition = entry.getKey();
            BulkRequest partitionRequest = new BulkRequest((Map)entry.getValue());
            return partitionRequest.bulkTransformAndHandleRequests((BulkFunction)partitionBulkFunction.apply(partition), keyTransformer, valueTransformer);
        }).collect(BulkResponse.collector());
    }

    public static <KEY> Builder<KEY> builder() {
        return new Builder();
    }

    public static <KEY> Builder<KEY> builder(int expectedSize) {
        return new Builder(expectedSize);
    }

    private static <KEY, KEY2, VAL> void transformKeys(Map<KEY, Long> keys, Function<KEY, KEY2> keyTransformer, Multimap<KEY2, KEY> reverseKeyLookup, Map<KEY, Long> keyTransformationTime, Builder<KEY2> requestBuilder, BulkResponse.Builder<KEY, VAL> responseBuilder) {
        keys.forEach((? super K key, ? super V elapsed) -> {
            Stopwatch stopwatch = Stopwatch.createStarted();
            long elapsedNanos = elapsed;
            try {
                Object transformedKey = keyTransformer.apply(key);
                keyTransformationTime.put(key, elapsedNanos += stopwatch.elapsed().toNanos());
                reverseKeyLookup.put(transformedKey, key);
                requestBuilder.add(transformedKey);
            }
            catch (Exception ex) {
                CompletableFuture failed = CompletableFuture.failedFuture(ex);
                responseBuilder.add(key, failed, elapsedNanos += stopwatch.elapsed().toNanos());
            }
        });
    }

    private static <T> CompletionStage<T> timedFuture(CompletionStage<T> f, MutableLong elapsedNanos) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        return f.whenComplete((r, ex) -> elapsedNanos.add(stopwatch.elapsed().toNanos()));
    }

    private static <K, V> CompletionStage<V> addElapsedTime(BulkResponse.Response<K, V> response, MutableLong elapsedNanos) {
        return response.response().whenComplete((r, ex) -> elapsedNanos.add(response.elapsed(TimeUnit.NANOSECONDS)));
    }

    public static final class Builder<KEY> {
        private final ImmutableMap.Builder<KEY, Long> setBuilder;

        Builder() {
            this.setBuilder = ImmutableMap.builder();
        }

        Builder(int expectedSize) {
            this.setBuilder = ImmutableMap.builderWithExpectedSize(expectedSize);
        }

        public BulkRequest<KEY> build() {
            return new BulkRequest<KEY>(this.setBuilder.buildKeepingLast());
        }

        public Builder<KEY> add(KEY request) {
            this.setBuilder.put(request, 0L);
            return this;
        }

        public Builder<KEY> add(KEY request, long elapsed) {
            this.setBuilder.put(request, elapsed);
            return this;
        }

        public Builder<KEY> addAll(Iterable<KEY> requests) {
            requests.forEach(key -> this.setBuilder.put(key, 0L));
            return this;
        }
    }
}

