/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.common.concurrent.bulk;

import com.dremio.jdbc.shaded.com.dremio.common.concurrent.bulk.ValueTransformer;
import com.dremio.jdbc.shaded.com.google.common.base.Preconditions;
import com.dremio.jdbc.shaded.com.google.common.base.Stopwatch;
import com.dremio.jdbc.shaded.com.google.common.base.Throwables;
import com.dremio.jdbc.shaded.com.google.common.collect.ImmutableMap;
import com.dremio.jdbc.shaded.com.google.common.collect.ImmutableSet;
import com.dremio.jdbc.shaded.com.google.common.collect.Sets;
import com.dremio.jdbc.shaded.org.apache.commons.lang3.mutable.MutableLong;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;

public final class BulkResponse<KEY, VAL> {
    private final Map<KEY, Response<KEY, VAL>> responses;

    private BulkResponse(Map<KEY, Response<KEY, VAL>> responses) {
        this.responses = responses;
    }

    public Response<KEY, VAL> get(KEY key) {
        return this.responses.get(key);
    }

    public Set<KEY> keys() {
        return Collections.unmodifiableSet(this.responses.keySet());
    }

    public Collection<Response<KEY, VAL>> responses() {
        return Collections.unmodifiableCollection(this.responses.values());
    }

    public void forEach(Consumer<? super Response<KEY, VAL>> action) {
        this.responses.values().forEach(action);
    }

    public <KEY2> BulkResponse<KEY2, VAL> transform(Function<KEY, KEY2> keyTransformer) {
        return new BulkResponse<KEY, VAL>((Map)this.responses.entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> keyTransformer.apply(entry.getKey()), entry -> ((Response)entry.getValue()).transform(keyTransformer))));
    }

    public <KEY2, VAL2> BulkResponse<KEY2, VAL2> transform(Function<KEY, KEY2> keyTransformer, ValueTransformer<KEY, VAL, KEY2, VAL2> valueTransformer) {
        return new BulkResponse<KEY, VAL>((Map)this.responses.entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> keyTransformer.apply(entry.getKey()), entry -> ((Response)entry.getValue()).transform(keyTransformer, valueTransformer))));
    }

    public <KEY2, VAL2> BulkResponse<KEY2, VAL2> transformAsync(Function<KEY, KEY2> keyTransformer, ValueTransformer<KEY, VAL, KEY2, CompletionStage<VAL2>> valueTransformer) {
        return new BulkResponse<KEY, VAL>((Map)this.responses.entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> keyTransformer.apply(entry.getKey()), entry -> ((Response)entry.getValue()).transformAsync(keyTransformer, valueTransformer))));
    }

    public BulkResponse<KEY, VAL> combineWith(BulkResponse<KEY, VAL> other, BiFunction<VAL, VAL, VAL> valueCombiner) {
        Sets.SetView<KEY> allKeys = Sets.union(this.responses.keySet(), other.responses.keySet());
        return new BulkResponse<KEY, VAL>(allKeys.stream().map(key -> Response.combine(this.responses.get(key), other.responses.get(key), valueCombiner)).filter(Objects::nonNull).collect(ImmutableMap.toImmutableMap(Response::key, Function.identity())));
    }

    public static <KEY, VAL> BulkResponse<KEY, VAL> empty() {
        return new BulkResponse(ImmutableMap.of());
    }

    public static <KEY, VAL> Builder<KEY, VAL> builder() {
        return new Builder();
    }

    public static <KEY, VAL> Builder<KEY, VAL> builder(int expectedSize) {
        return new Builder(expectedSize);
    }

    public static <KEY, VAL> Collector<BulkResponse<KEY, VAL>, Builder<KEY, VAL>, BulkResponse<KEY, VAL>> collector() {
        return new ResponseCollector();
    }

    public static final class Response<KEY, VAL> {
        private final MutableLong elapsedNanos;
        private final KEY key;
        private final CompletionStage<VAL> response;

        public Response(KEY key, VAL precomputedValue) {
            this.elapsedNanos = new MutableLong(0L);
            this.key = key;
            this.response = CompletableFuture.completedFuture(precomputedValue);
        }

        public Response(KEY key, CompletionStage<VAL> response) {
            this.elapsedNanos = new MutableLong(0L);
            this.key = key;
            this.response = this.timedFuture(response);
        }

        public Response(KEY key, CompletionStage<VAL> response, MutableLong elapsedNanos) {
            this.elapsedNanos = elapsedNanos;
            this.key = key;
            this.response = response;
        }

        public <KEY2> Response<KEY2, VAL> transform(Function<KEY, KEY2> keyTransformer) {
            KEY2 transformedKey = keyTransformer.apply(this.key);
            return new Response<KEY2, VAL>(transformedKey, this.response, this.elapsedNanos);
        }

        public <KEY2, VAL2> Response<KEY2, VAL2> transform(Function<KEY, KEY2> keyTransformer, ValueTransformer<KEY, VAL, KEY2, VAL2> valueTransformer) {
            Object transformedKey = keyTransformer.apply(this.key);
            CompletionStage<Object> transformedValue = this.response.thenApply(v -> this.timedCall(() -> valueTransformer.apply(this.key, transformedKey, v)));
            return new Response<KEY2, Object>(transformedKey, transformedValue, this.elapsedNanos);
        }

        public <KEY2, VAL2> Response<KEY2, VAL2> transformAsync(Function<KEY, KEY2> keyTransformer, ValueTransformer<KEY, VAL, KEY2, CompletionStage<VAL2>> valueTransformer) {
            Object transformedKey = keyTransformer.apply(this.key);
            CompletionStage transformedValue = this.response.thenCompose(v -> this.timedCall(() -> this.timedFuture((CompletionStage)valueTransformer.apply(this.key, transformedKey, v))));
            return new Response(transformedKey, transformedValue, this.elapsedNanos);
        }

        public KEY key() {
            return this.key;
        }

        public CompletionStage<VAL> response() {
            return this.response;
        }

        public long elapsed(TimeUnit timeUnit) {
            return timeUnit.convert(this.elapsedNanos.longValue(), TimeUnit.NANOSECONDS);
        }

        private static <KEY, VAL> Response<KEY, VAL> combine(Response<KEY, VAL> first, Response<KEY, VAL> second, BiFunction<VAL, VAL, VAL> valueCombiner) {
            Response<KEY, Object> combinedResponse;
            if (first != null) {
                if (second != null) {
                    Preconditions.checkArgument(first.key.equals(second.key), "Responses with different keys cannot be combined");
                    MutableLong elapsed = new MutableLong(0L);
                    CompletionStage<Object> combinedStage = first.response.thenCombine(second.response, (f, s2) -> {
                        elapsed.add(Math.max(first.elapsedNanos.longValue(), second.elapsedNanos.longValue()));
                        return valueCombiner.apply(f, s2);
                    });
                    combinedResponse = new Response<KEY, Object>(first.key, combinedStage, elapsed);
                } else {
                    combinedResponse = first;
                }
            } else {
                combinedResponse = second;
            }
            return combinedResponse;
        }

        private <T> T timedCall(Callable<T> callable) {
            Stopwatch stopwatch = Stopwatch.createStarted();
            try {
                T t2 = callable.call();
                return t2;
            }
            catch (Exception ex) {
                Throwables.throwIfUnchecked(ex);
                throw new RuntimeException(ex);
            }
            finally {
                this.elapsedNanos.addAndGet(stopwatch.elapsed().toNanos());
            }
        }

        private <T> CompletionStage<T> timedFuture(CompletionStage<T> f) {
            Stopwatch stopwatch = Stopwatch.createStarted();
            return f.whenComplete((k, v) -> this.elapsedNanos.addAndGet(stopwatch.elapsed().toNanos()));
        }
    }

    public static final class Builder<KEY, VAL> {
        private final ImmutableMap.Builder<KEY, Response<KEY, VAL>> mapBuilder;

        Builder() {
            this.mapBuilder = ImmutableMap.builder();
        }

        Builder(int expectedSize) {
            this.mapBuilder = ImmutableMap.builderWithExpectedSize(expectedSize);
        }

        public BulkResponse<KEY, VAL> build() {
            return new BulkResponse<KEY, VAL>(this.mapBuilder.build());
        }

        public Builder<KEY, VAL> add(Response<KEY, VAL> response) {
            this.mapBuilder.put(response.key(), response);
            return this;
        }

        public Builder<KEY, VAL> add(KEY key, VAL precomputedValue) {
            this.mapBuilder.put(key, new Response<KEY, VAL>(key, precomputedValue));
            return this;
        }

        public Builder<KEY, VAL> add(KEY key, CompletionStage<VAL> response) {
            this.mapBuilder.put(key, new Response<KEY, VAL>(key, response));
            return this;
        }

        public Builder<KEY, VAL> add(KEY key, CompletionStage<VAL> response, MutableLong elapsedNanos) {
            this.mapBuilder.put(key, new Response<KEY, VAL>(key, response, elapsedNanos));
            return this;
        }

        public Builder<KEY, VAL> add(KEY key, CompletionStage<VAL> response, long elapsedNanos) {
            this.mapBuilder.put(key, new Response<KEY, VAL>(key, response, new MutableLong(elapsedNanos)));
            return this;
        }

        public Builder<KEY, VAL> addAll(BulkResponse<KEY, VAL> bulkResponse) {
            this.mapBuilder.putAll(bulkResponse.responses);
            return this;
        }

        public Builder<KEY, VAL> addAll(Builder<KEY, VAL> responseBuilder) {
            this.mapBuilder.putAll(responseBuilder.mapBuilder.build());
            return this;
        }
    }

    private static final class ResponseCollector<KEY, VAL>
    implements Collector<BulkResponse<KEY, VAL>, Builder<KEY, VAL>, BulkResponse<KEY, VAL>> {
        private static final Set<Collector.Characteristics> CHARACTERISTICS = ImmutableSet.of(Collector.Characteristics.UNORDERED);

        private ResponseCollector() {
        }

        @Override
        public Supplier<Builder<KEY, VAL>> supplier() {
            return Builder::new;
        }

        @Override
        public BiConsumer<Builder<KEY, VAL>, BulkResponse<KEY, VAL>> accumulator() {
            return Builder::addAll;
        }

        @Override
        public BinaryOperator<Builder<KEY, VAL>> combiner() {
            return Builder::addAll;
        }

        @Override
        public Function<Builder<KEY, VAL>, BulkResponse<KEY, VAL>> finisher() {
            return Builder::build;
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return CHARACTERISTICS;
        }
    }
}

