/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.common.config;

import com.dremio.jdbc.shaded.com.dremio.common.config.NestedConfig;
import com.dremio.jdbc.shaded.com.dremio.common.config.SabotConfigurationException;
import com.dremio.jdbc.shaded.com.dremio.common.exceptions.UserException;
import com.dremio.jdbc.shaded.com.dremio.common.scanner.ClassPathScanner;
import com.dremio.jdbc.shaded.com.google.common.annotations.VisibleForTesting;
import com.dremio.jdbc.shaded.com.google.common.base.Preconditions;
import com.dremio.jdbc.shaded.com.google.common.base.Stopwatch;
import com.dremio.jdbc.shaded.com.typesafe.config.Config;
import com.dremio.jdbc.shaded.com.typesafe.config.ConfigException;
import com.dremio.jdbc.shaded.com.typesafe.config.ConfigFactory;
import com.dremio.jdbc.shaded.com.typesafe.config.ConfigRenderOptions;
import com.dremio.jdbc.shaded.com.typesafe.config.ConfigValue;
import com.dremio.jdbc.shaded.org.reflections.util.ClasspathHelper;
import com.dremio.jdbc.shaded.org.slf4j.Logger;
import com.dremio.jdbc.shaded.org.slf4j.LoggerFactory;
import java.io.File;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;

public class SabotConfig
extends NestedConfig {
    private static final Logger logger = LoggerFactory.getLogger(SabotConfig.class);

    @VisibleForTesting
    public SabotConfig(Config config) {
        super(config);
        logger.debug("Setting up SabotConfig object.");
        if (logger.isTraceEnabled()) {
            String configObject = config.root().render(ConfigRenderOptions.defaults());
            logger.trace("Given Config object is:\n{}", (Object)configObject);
        }
    }

    public <T> T getInstance(String path, Class<T> iface, Object ... constructorArgs) {
        try {
            String className = this.getString(path);
            Class<?> clazz = Class.forName(className);
            return this.instantiate(iface, clazz, constructorArgs);
        }
        catch (Exception e) {
            throw UserException.unsupportedError(e).message("Failure while attempting to load instance of the class of type %s requested at path %s.", iface.getName(), path).build(logger);
        }
    }

    public <T> T getInstanceWithConstructorArgType(String path, Class<T> iface, Class<?> constructorArgClass, Object ... constructorArgs) {
        try {
            String className = this.getString(path);
            Class<?> clazz = Class.forName(className);
            return this.instantiateWithConstructorArgType(iface, clazz, constructorArgClass, constructorArgs);
        }
        catch (Exception e) {
            throw UserException.unsupportedError(e).message("Failure while attempting to load instance of the class of type %s requested at path %s.", iface.getName(), path).build(logger);
        }
    }

    public <T> T getInstance(String path, Class<T> iface, Class<? extends T> defaultImpl) {
        if (this.hasPath(path)) {
            return this.getInstance(path, iface, new Object[0]);
        }
        try {
            return this.instantiate(iface, defaultImpl, new Object[0]);
        }
        catch (Exception e) {
            throw UserException.unsupportedError(e).message("Failure while attempting to instantiate default implementation class %s for interface  %s. The sabot config key is %s ", defaultImpl.getName(), iface.getName(), path).build(logger);
        }
    }

    public <T> T getInstance(String path, Class<T> iface, T defaultInstance, Object ... constructorArgs) {
        if (this.hasPath(path)) {
            return this.getInstance(path, iface, constructorArgs);
        }
        return defaultInstance;
    }

    public <T> T getInstanceWithConstructorArgType(String path, Class<T> iface, T defaultInstance, Class<?> constructorArgClass, Object ... constructorArgs) {
        if (this.hasPath(path)) {
            return this.getInstanceWithConstructorArgType(path, iface, constructorArgClass, constructorArgs);
        }
        return defaultInstance;
    }

    public <T> Class<? extends T> getClass(String path, Class<T> iface, Class<? extends T> defaultImpl) {
        if (this.hasPath(path)) {
            String className = this.getString(path);
            try {
                Class<?> clazz = Class.forName(className);
                Preconditions.checkArgument(iface.isAssignableFrom(clazz));
                return clazz;
            }
            catch (ClassNotFoundException e) {
                throw UserException.unsupportedError(e).message("Failure while attempting to find implementation class %s for interface  %s. The sabot config key is %s ", defaultImpl.getName(), iface.getName(), path).build(logger);
            }
        }
        return defaultImpl;
    }

    private <T> T instantiate(Class<T> iface, Class<?> clazz, Object ... constructorArgs) throws ReflectiveOperationException {
        Preconditions.checkArgument(iface.isAssignableFrom(clazz));
        Class[] argClasses = new Class[constructorArgs.length];
        for (int i = 0; i < constructorArgs.length; ++i) {
            argClasses[i] = constructorArgs[i].getClass();
        }
        Constructor<?> constructor = clazz.getConstructor(argClasses);
        return (T)constructor.newInstance(constructorArgs);
    }

    private <T> T instantiateWithConstructorArgType(Class<T> iface, Class<?> clazz, Class<?> constructorArgClass, Object ... constructorArgs) throws ReflectiveOperationException {
        Preconditions.checkArgument(iface.isAssignableFrom(clazz));
        Class[] argClasses = new Class[constructorArgs.length];
        for (int i = 0; i < constructorArgs.length; ++i) {
            argClasses[i] = constructorArgClass;
        }
        Constructor<?> constructor = clazz.getConstructor(argClasses);
        return (T)constructor.newInstance(constructorArgs);
    }

    public static SabotConfig create() {
        return SabotConfig.create(null, null);
    }

    public static SabotConfig forClient() {
        return SabotConfig.create(null, null);
    }

    public static SabotConfig create(String overrideFileResourcePathname) {
        return SabotConfig.create(overrideFileResourcePathname, null);
    }

    @VisibleForTesting
    public static SabotConfig create(Properties testConfigurations) {
        return SabotConfig.create(null, testConfigurations);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SabotConfig create(String overrideFileResourcePathname, Properties overriderProps) {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(SabotConfig.class.getClassLoader());
        try {
            SabotConfig sabotConfig = SabotConfig.doCreate(overrideFileResourcePathname, overriderProps);
            return sabotConfig;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    private static SabotConfig createFromSavedSabotConfig() {
        String savedSabotConfigFile = System.getProperty("com.dremio.jdbc.shaded.com.dremio.savedSabotConfig");
        if (savedSabotConfigFile == null) {
            return null;
        }
        File savedSabotConfig = new File(savedSabotConfigFile);
        if (savedSabotConfig.exists()) {
            try {
                Config config = ConfigFactory.parseFile(savedSabotConfig);
                return new SabotConfig(config);
            }
            catch (ConfigException e) {
                logger.warn("Unable to read saved SabotConfig from '{}' (proceeding to slow path): {}", (Object)savedSabotConfigFile, (Object)e.toString());
            }
        }
        return null;
    }

    private static SabotConfig doCreate(String overrideFileResourcePathname, Properties overriderProps) {
        ClassLoader[] classLoaders;
        StringBuilder logString = new StringBuilder();
        Stopwatch watch = Stopwatch.createStarted();
        overrideFileResourcePathname = overrideFileResourcePathname == null ? "sabot-override.conf" : overrideFileResourcePathname;
        SabotConfig preCreated = SabotConfig.createFromSavedSabotConfig();
        if (preCreated != null) {
            return preCreated;
        }
        Config fallback = null;
        for (ClassLoader classLoader : classLoaders = ClasspathHelper.classLoaders(new ClassLoader[0])) {
            URL url = classLoader.getResource("sabot-default.conf");
            if (null == url) continue;
            logString.append("Base Configuration:\n\t- ").append(url).append("\n");
            fallback = ConfigFactory.load(classLoader, "sabot-default.conf");
            break;
        }
        Collection<URL> urls = ClassPathScanner.getConfigURLs();
        logString.append("Intermediate Configuration and Plugin files, in order of precedence:");
        for (URL url : urls) {
            logString.append("\n\t- ").append(url);
            fallback = ConfigFactory.parseURL(url).withFallback(fallback);
        }
        URL overrideFileUrl = Thread.currentThread().getContextClassLoader().getResource(overrideFileResourcePathname);
        if (null != overrideFileUrl) {
            logString.append("\nOverride File: ").append(overrideFileUrl);
        }
        Config effectiveConfig = ConfigFactory.load(overrideFileResourcePathname).withFallback(fallback);
        if (overriderProps != null) {
            logString.append("\nOverridden Properties:");
            for (Map.Entry<Object, Object> entry : overriderProps.entrySet()) {
                logString.append("\n\t- ").append(entry.getKey()).append(" = ").append(entry.getValue());
            }
            effectiveConfig = ConfigFactory.parseProperties(overriderProps).withFallback(effectiveConfig);
        }
        logger.info("Configuration and plugin file(s) identified in {}ms.\n{}", (Object)watch.elapsed(TimeUnit.MILLISECONDS), (Object)logString);
        return new SabotConfig(effectiveConfig.resolve());
    }

    public <T> Class<? extends T> getClassAt(String location, Class<T> clazz) throws SabotConfigurationException {
        Class<T> c = this.getClassAt(location, clazz, null);
        if (c != null) {
            return c;
        }
        throw new SabotConfigurationException(String.format("No class defined at location '%s'. Expected a definition of the class [%s]", location, clazz.getCanonicalName()));
    }

    public <T> Class<? extends T> getClassAt(String location, Class<T> clazz, Class<? extends T> defaultClazz) throws SabotConfigurationException {
        String className = this.getString(location);
        if (className == null) {
            return defaultClazz;
        }
        try {
            Class<?> c = Class.forName(className);
            if (clazz.isAssignableFrom(c)) {
                Class<?> t2 = c;
                return t2;
            }
            throw new SabotConfigurationException(String.format("The class [%s] listed at location '%s' should be of type [%s].  It isn't.", className, location, clazz.getCanonicalName()));
        }
        catch (Exception ex) {
            if (ex instanceof SabotConfigurationException) {
                throw (SabotConfigurationException)ex;
            }
            throw new SabotConfigurationException(String.format("Failure while initializing class [%s] described at configuration value '%s'.", className, location), ex);
        }
    }

    public <T> T getInstanceOf(String location, Class<T> clazz) throws SabotConfigurationException {
        Class<T> c = this.getClassAt(location, clazz);
        try {
            return c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception ex) {
            throw new SabotConfigurationException(String.format("Failure while instantiating class [%s] located at '%s.", clazz.getCanonicalName(), location), ex);
        }
    }

    @Override
    public SabotConfig withValue(String path, ConfigValue value) {
        return new SabotConfig(this.getInnerConfig().withValue(path, value));
    }

    public String toString() {
        return this.root().render();
    }
}

