/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.common.exceptions;

import com.dremio.jdbc.shaded.com.dremio.exec.proto.UserBitShared;
import java.util.EnumSet;

public class ErrorCompatibility {
    private static final EnumSet<UserBitShared.DremioPBError.ErrorType> incompatibleErrorTypes = EnumSet.of(UserBitShared.DremioPBError.ErrorType.SCHEMA_CHANGE, new UserBitShared.DremioPBError.ErrorType[]{UserBitShared.DremioPBError.ErrorType.OUT_OF_MEMORY, UserBitShared.DremioPBError.ErrorType.IO_EXCEPTION, UserBitShared.DremioPBError.ErrorType.CONCURRENT_MODIFICATION, UserBitShared.DremioPBError.ErrorType.INVALID_DATASET_METADATA, UserBitShared.DremioPBError.ErrorType.REFLECTION_ERROR, UserBitShared.DremioPBError.ErrorType.SOURCE_BAD_STATE, UserBitShared.DremioPBError.ErrorType.JSON_FIELD_CHANGE, UserBitShared.DremioPBError.ErrorType.RESOURCE_TIMEOUT});

    private static boolean needsConversion(UserBitShared.DremioPBError error) {
        return incompatibleErrorTypes.contains(error.getErrorType());
    }

    public static UserBitShared.DremioPBError convertIfNecessary(UserBitShared.DremioPBError error) {
        if (!ErrorCompatibility.needsConversion(error)) {
            return error;
        }
        switch (error.getErrorType()) {
            case JSON_FIELD_CHANGE: 
            case SCHEMA_CHANGE: 
            case SOURCE_BAD_STATE: {
                return UserBitShared.DremioPBError.newBuilder(error).setErrorType(UserBitShared.DremioPBError.ErrorType.DATA_READ).build();
            }
            case REFLECTION_ERROR: {
                return UserBitShared.DremioPBError.newBuilder(error).setErrorType(UserBitShared.DremioPBError.ErrorType.SYSTEM).build();
            }
            case OUT_OF_MEMORY: 
            case IO_EXCEPTION: 
            case CONCURRENT_MODIFICATION: 
            case INVALID_DATASET_METADATA: 
            case RESOURCE_TIMEOUT: {
                return UserBitShared.DremioPBError.newBuilder(error).setErrorType(UserBitShared.DremioPBError.ErrorType.RESOURCE).build();
            }
        }
        throw new IllegalStateException("Unhandled error type: " + String.valueOf(error.getErrorType()));
    }

    public static UserBitShared.QueryResult convertIfNecessary(UserBitShared.QueryResult result) {
        if (result.getErrorCount() == 0) {
            return result;
        }
        int numErrors = result.getErrorCount();
        boolean convert = false;
        for (int i = 0; i < numErrors && !convert; ++i) {
            if (!ErrorCompatibility.needsConversion(result.getError(i))) continue;
            convert = true;
        }
        if (!convert) {
            return result;
        }
        UserBitShared.QueryResult.Builder resultBuilder = UserBitShared.QueryResult.newBuilder(result);
        for (int i = 0; i < numErrors; ++i) {
            resultBuilder.setError(i, ErrorCompatibility.convertIfNecessary(result.getError(i)));
        }
        return resultBuilder.build();
    }
}

