/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.common.exceptions;

import com.dremio.jdbc.shaded.com.dremio.common.exceptions.UserException;
import com.dremio.jdbc.shaded.org.slf4j.Logger;

public final class FieldSizeLimitExceptionHelper {
    private FieldSizeLimitExceptionHelper() {
    }

    public static void checkSizeLimit(int size, int maxSize, Logger logger) {
        if (size > maxSize) {
            throw FieldSizeLimitExceptionHelper.createFieldSizeLimitException(size, maxSize, logger);
        }
    }

    public static void checkSizeLimit(int size, int maxSize, int fieldIndex, Logger logger) {
        if (size > maxSize) {
            throw FieldSizeLimitExceptionHelper.createFieldSizeLimitException(size, maxSize, fieldIndex, logger);
        }
    }

    public static void checkSizeLimit(int size, int maxSize, String fieldName, Logger logger) {
        if (size > maxSize) {
            throw FieldSizeLimitExceptionHelper.createFieldSizeLimitException(size, maxSize, fieldName, logger);
        }
    }

    public static UserException createListChildrenLimitException(String fieldName, long maxSize, long size) {
        return UserException.unsupportedError(new FieldSizeLimitException()).message("List field '%s' exceeded the maximum number of elements %d, actual number of elements is %d", fieldName, maxSize, size).addContext("limit", maxSize).build();
    }

    public static UserException createFieldSizeLimitException(int size, int maxSize, Logger logger) {
        return UserException.unsupportedError(new FieldSizeLimitException()).message("Field exceeds the size limit of %d bytes, actual size is %d bytes.", maxSize, size).addContext("size", size).addContext("limit", maxSize).build(logger);
    }

    public static UserException createFieldSizeLimitException(int size, int maxSize) {
        return UserException.unsupportedError(new FieldSizeLimitException()).message("Field exceeds the size limit of %d bytes , actual size is %d bytes.", maxSize, size).addContext("size", size).addContext("limit", maxSize).build();
    }

    public static UserException createFieldSizeLimitException(int size, int maxSize, int fieldIndex, Logger logger) {
        return UserException.unsupportedError(new FieldSizeLimitException()).message("Field with index %d exceeds the size limit of %d bytes, actual size is %d bytes.", fieldIndex, maxSize, size).addContext("fieldIndex", fieldIndex).addContext("size", size).addContext("limit", maxSize).build(logger);
    }

    public static UserException createFieldSizeLimitException(int size, int maxSize, String fieldName, Logger logger) {
        return UserException.unsupportedError(new FieldSizeLimitException()).message("Field '%s' exceeds the size limit of %d bytes, actual size is %d bytes.", fieldName, maxSize, size).addContext("fieldName", fieldName).addContext("size", size).addContext("limit", maxSize).build(logger);
    }

    public static class FieldSizeLimitException
    extends Exception {
        FieldSizeLimitException() {
        }
    }
}

