/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.common.exceptions;

import com.dremio.jdbc.shaded.com.dremio.common.exceptions.UserException;
import com.dremio.jdbc.shaded.com.dremio.common.exceptions.UserRemoteException;
import com.dremio.jdbc.shaded.com.dremio.exec.proto.UserBitShared;
import com.dremio.jdbc.shaded.com.google.protobuf.Any;
import com.dremio.jdbc.shaded.com.google.protobuf.InvalidProtocolBufferException;
import com.dremio.jdbc.shaded.com.google.rpc.Status;
import com.dremio.jdbc.shaded.io.grpc.Status;
import com.dremio.jdbc.shaded.io.grpc.StatusException;
import com.dremio.jdbc.shaded.io.grpc.StatusRuntimeException;
import com.dremio.jdbc.shaded.io.grpc.protobuf.StatusProto;
import com.dremio.jdbc.shaded.io.grpc.stub.StreamObserver;
import com.dremio.jdbc.shaded.org.slf4j.Logger;
import com.dremio.jdbc.shaded.org.slf4j.LoggerFactory;
import java.security.AccessControlException;
import java.util.Optional;

public final class GrpcExceptionUtil {
    private static final Logger logger = LoggerFactory.getLogger(GrpcExceptionUtil.class);

    private static Status.Code toCode(UserBitShared.DremioPBError.ErrorType errorType) {
        switch (errorType) {
            case DATA_READ: 
            case DATA_WRITE: {
                return Status.Code.FAILED_PRECONDITION;
            }
            case PERMISSION: {
                return Status.Code.PERMISSION_DENIED;
            }
            case RESOURCE: 
            case RESOURCE_TIMEOUT: {
                return Status.Code.RESOURCE_EXHAUSTED;
            }
            case UNSUPPORTED_OPERATION: {
                return Status.Code.UNIMPLEMENTED;
            }
            case PARSE: 
            case PLAN: 
            case VALIDATION: {
                return Status.Code.INVALID_ARGUMENT;
            }
            case CONCURRENT_MODIFICATION: {
                return Status.Code.ABORTED;
            }
            case FUNCTION: 
            case IO_EXCEPTION: 
            case CONNECTION: 
            case SCHEMA_CHANGE: 
            case INVALID_DATASET_METADATA: 
            case REFLECTION_ERROR: 
            case SOURCE_BAD_STATE: 
            case JSON_FIELD_CHANGE: 
            case SYSTEM: 
            case OUT_OF_MEMORY: {
                return Status.Code.INTERNAL;
            }
        }
        return Status.Code.UNKNOWN;
    }

    public static StatusRuntimeException toStatusRuntimeException(UserBitShared.DremioPBError error) {
        return GrpcExceptionUtil.toStatusRuntimeException(error.getMessage(), GrpcExceptionUtil.toCode(error.getErrorType()), UserRemoteException.create(error));
    }

    public static StatusRuntimeException toStatusRuntimeException(UserException ue) {
        return GrpcExceptionUtil.toStatusRuntimeException(ue.getMessage(), GrpcExceptionUtil.toCode(ue.getErrorType()), ue);
    }

    public static StatusRuntimeException toStatusRuntimeException(String message, Status.Code code, UserException ue) {
        return StatusProto.toStatusRuntimeException((Status)Status.newBuilder().setCode(code.value()).setMessage(message).addDetails(Any.pack(ue.getOrCreatePBError(false), "dremio.com/v1/types")).build());
    }

    public static <V> void fallbackHandleException(StreamObserver<V> responseObserver, Throwable t2, String message) {
        logger.warn("Using fallback to handle unknown exception", t2);
        if (t2 instanceof UserException) {
            responseObserver.onError((Throwable)GrpcExceptionUtil.toStatusRuntimeException((UserException)t2));
        } else if (t2 instanceof StatusException) {
            responseObserver.onError((Throwable)((StatusException)t2));
        } else if (t2 instanceof StatusRuntimeException) {
            responseObserver.onError((Throwable)GrpcExceptionUtil.statusRuntimeExceptionMapper(t2));
        } else {
            responseObserver.onError((Throwable)GrpcExceptionUtil.toErrorStatus(t2, message).asRuntimeException());
        }
    }

    public static com.dremio.jdbc.shaded.io.grpc.Status toErrorStatus(Throwable t2, String message) {
        if (t2 instanceof IllegalArgumentException) {
            return com.dremio.jdbc.shaded.io.grpc.Status.INVALID_ARGUMENT.withCause(t2).withDescription(message);
        }
        if (t2 instanceof IllegalStateException) {
            return com.dremio.jdbc.shaded.io.grpc.Status.INTERNAL.withCause(t2).withDescription(message);
        }
        if (t2 instanceof AccessControlException) {
            return com.dremio.jdbc.shaded.io.grpc.Status.PERMISSION_DENIED.withCause(t2).withDescription(message);
        }
        return com.dremio.jdbc.shaded.io.grpc.Status.UNKNOWN.withCause(t2).withDescription(message);
    }

    private static StatusRuntimeException statusRuntimeExceptionMapper(Throwable t2) {
        if (!(t2 instanceof StatusRuntimeException)) {
            return new StatusRuntimeException(com.dremio.jdbc.shaded.io.grpc.Status.UNKNOWN.withDescription("The server encountered an unexpected error. Please retry your request.").withCause(t2));
        }
        StatusRuntimeException sre = (StatusRuntimeException)t2;
        if (sre.getStatus().getCode() == Status.Code.UNAVAILABLE) {
            return new StatusRuntimeException(com.dremio.jdbc.shaded.io.grpc.Status.UNAVAILABLE.withDescription("The service is temporarily unavailable. Please retry your request.").withCause(t2));
        }
        return sre;
    }

    public static <V> void fallbackHandleException(StreamObserver<V> responseObserver, Throwable t2) {
        GrpcExceptionUtil.fallbackHandleException(responseObserver, t2, t2.getMessage());
    }

    public static Optional<UserException> fromStatusRuntimeException(StatusRuntimeException sre) {
        Status statusProto = StatusProto.fromThrowable((Throwable)sre);
        if (statusProto == null) {
            return Optional.empty();
        }
        return GrpcExceptionUtil.fromStatus(statusProto);
    }

    public static Optional<UserException> fromStatus(Status statusProto) {
        for (Any details : statusProto.getDetailsList()) {
            if (!details.is(UserBitShared.DremioPBError.class)) continue;
            try {
                return Optional.of(UserRemoteException.create(details.unpack(UserBitShared.DremioPBError.class)));
            }
            catch (InvalidProtocolBufferException e) {
                logger.warn("Received an invalid UserException, ignoring", e);
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    public static void throwIfUserException(StatusRuntimeException e) {
        Optional<UserException> userException = GrpcExceptionUtil.fromStatusRuntimeException(e);
        if (userException.isPresent()) {
            throw userException.get();
        }
    }

    private GrpcExceptionUtil() {
    }
}

