/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.common.exceptions;

import com.dremio.jdbc.shaded.com.dremio.common.exceptions.AdditionalExceptionContext;
import com.dremio.jdbc.shaded.com.dremio.common.exceptions.UserException;
import com.dremio.jdbc.shaded.com.dremio.common.serde.ProtobufByteStringSerDe;
import com.dremio.jdbc.shaded.com.fasterxml.jackson.core.JsonGenerator;
import com.dremio.jdbc.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import com.dremio.jdbc.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import com.dremio.jdbc.shaded.com.google.protobuf.ByteString;
import com.dremio.jdbc.shaded.org.slf4j.Logger;
import com.dremio.jdbc.shaded.org.slf4j.LoggerFactory;
import java.io.IOException;

public abstract class JsonAdditionalExceptionContext
implements AdditionalExceptionContext {
    private static final Logger logger = LoggerFactory.getLogger(JsonAdditionalExceptionContext.class);
    private static final ObjectMapper contextMapper = new ObjectMapper();

    protected static <T extends AdditionalExceptionContext> T fromUserException(Class<T> clazz, UserException ex) {
        if (ex.getRawAdditionalExceptionContext() == null) {
            logger.debug("missing additional context in UserException");
            return null;
        }
        try {
            return (T)((AdditionalExceptionContext)ProtobufByteStringSerDe.readValue(contextMapper.readerFor(clazz), ex.getRawAdditionalExceptionContext(), ProtobufByteStringSerDe.Codec.NONE, logger));
        }
        catch (IOException ignored) {
            logger.debug("unable to deserialize additional exception context", ignored);
            return null;
        }
    }

    @Override
    public ByteString toByteString() {
        try {
            return ProtobufByteStringSerDe.writeValue(contextMapper, this, ProtobufByteStringSerDe.Codec.NONE);
        }
        catch (JsonProcessingException ignored) {
            logger.debug("unable to serialize additional exception context", ignored);
            return null;
        }
    }

    static {
        contextMapper.enable(JsonGenerator.Feature.IGNORE_UNKNOWN);
    }
}

