/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.common.exceptions;

import com.dremio.jdbc.shaded.com.dremio.common.exceptions.JsonAdditionalExceptionContext;
import com.dremio.jdbc.shaded.com.dremio.common.exceptions.UserException;
import com.dremio.jdbc.shaded.com.dremio.exec.proto.UserBitShared;
import com.dremio.jdbc.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import com.dremio.jdbc.shaded.com.fasterxml.jackson.annotation.JsonTypeName;
import com.dremio.jdbc.shaded.com.google.common.base.Preconditions;

@JsonTypeName(value="OutOfMemoryOrResource")
public class OutOfMemoryOrResourceExceptionContext
extends JsonAdditionalExceptionContext {
    private final MemoryType memoryType;
    private final String additionalInfo;

    public OutOfMemoryOrResourceExceptionContext(@JsonProperty(value="memoryType") MemoryType memoryType, @JsonProperty(value="additionalInfo") String additionalInfo) {
        this.memoryType = memoryType;
        this.additionalInfo = additionalInfo;
    }

    @Override
    public UserBitShared.DremioPBError.ErrorType getErrorType() {
        return UserBitShared.DremioPBError.ErrorType.OUT_OF_MEMORY;
    }

    public MemoryType getMemoryType() {
        return this.memoryType;
    }

    public String getAdditionalInfo() {
        return this.additionalInfo;
    }

    public static OutOfMemoryOrResourceExceptionContext fromUserException(UserException ex) {
        Preconditions.checkState(ex.getErrorType() == UserBitShared.DremioPBError.ErrorType.OUT_OF_MEMORY || ex.getErrorType() == UserBitShared.DremioPBError.ErrorType.RESOURCE, "exception type mismatch");
        return JsonAdditionalExceptionContext.fromUserException(OutOfMemoryOrResourceExceptionContext.class, ex);
    }

    public static enum MemoryType {
        UNKNOWN_TYPE,
        DIRECT_MEMORY,
        HEAP_MEMORY;

    }
}

