/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.common.exceptions;

import com.dremio.jdbc.shaded.com.dremio.common.exceptions.FieldSizeLimitExceptionHelper;
import com.dremio.jdbc.shaded.com.dremio.common.exceptions.UserException;
import com.dremio.jdbc.shaded.org.slf4j.Logger;

public final class RowSizeLimitExceptionHelper {
    private RowSizeLimitExceptionHelper() {
    }

    public static void checkSizeLimit(int size, int maxSize, RowSizeLimitExceptionType type, Logger logger) {
        if (size > maxSize) {
            throw RowSizeLimitExceptionHelper.createRowSizeLimitException(maxSize, type, logger);
        }
    }

    public static UserException createRowSizeLimitException(int maxSize, RowSizeLimitExceptionType type, Logger logger) {
        String whereExceptionHappened;
        switch (type.ordinal()) {
            case 0: {
                whereExceptionHappened = "reading";
                break;
            }
            case 1: {
                whereExceptionHappened = "writing";
                break;
            }
            case 2: {
                whereExceptionHappened = "processing";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported RowSizeLimitExceptionType: " + String.valueOf((Object)type));
            }
        }
        return UserException.unsupportedError(new FieldSizeLimitExceptionHelper.FieldSizeLimitException()).message("Exceeded maximum allowed row size of %d bytes %s data.", maxSize, whereExceptionHappened).addContext("limit", maxSize).build(logger);
    }

    public static enum RowSizeLimitExceptionType {
        READ,
        WRITE,
        PROCESSING;

    }
}

