/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.common.exceptions;

import com.dremio.jdbc.shaded.com.dremio.common.exceptions.AdditionalExceptionContext;
import com.dremio.jdbc.shaded.com.dremio.common.exceptions.ErrorHelper;
import com.dremio.jdbc.shaded.com.dremio.common.exceptions.UserExceptionContext;
import com.dremio.jdbc.shaded.com.dremio.exec.proto.CoordinationProtos;
import com.dremio.jdbc.shaded.com.dremio.exec.proto.UserBitShared;
import com.dremio.jdbc.shaded.com.google.errorprone.annotations.FormatMethod;
import com.dremio.jdbc.shaded.com.google.protobuf.ByteString;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.util.SchemaChangeRuntimeException;
import com.dremio.jdbc.shaded.org.slf4j.Logger;
import com.dremio.jdbc.shaded.org.slf4j.LoggerFactory;
import java.util.List;

public class UserException
extends RuntimeException {
    private static final Logger logger = LoggerFactory.getLogger(UserException.class);
    public static final String MEMORY_ERROR_MSG = "Query was cancelled because it exceeded the memory limits set by the administrator.";
    public static final String OOM_MSG = "Query canceled - out of memory, check the query profile for details";
    public static final String SYSTEM_ERROR_MSG = "Unexpected error occurred.";
    public static final String QUERY_REJECTED_MSG = "Rejecting query because it exceeded the maximum allowed number of live queries in a single coordinator";
    public static final String REFRESH_METADATA_FAILED_CONCURRENT_UPDATE_MSG = "Unable to refresh metadata for the dataset (due to concurrent updates). Please retry.";
    public static final String UNCLASSIFIED_ERROR_ORIGIN = "UNCLASSIFIED_ERROR_ORIGIN";
    private final UserBitShared.DremioPBError.ErrorType errorType;
    private final UserExceptionContext context;
    private final ByteString rawAdditionalContext;
    private final AttemptCompletionState attemptCompletionState;

    public static Builder invalidMetadataError() {
        return UserException.invalidMetadataError(null);
    }

    public static Builder invalidMetadataError(Throwable cause) {
        return UserException.builder(UserBitShared.DremioPBError.ErrorType.INVALID_DATASET_METADATA, cause);
    }

    public static Builder schemaChangeError() {
        return UserException.schemaChangeError(new SchemaChangeRuntimeException("Schema change error"));
    }

    public static Builder schemaChangeError(Throwable cause) {
        return UserException.builder(UserBitShared.DremioPBError.ErrorType.SCHEMA_CHANGE, cause);
    }

    public static Builder resourceTimeoutError() {
        return UserException.resourceTimeoutError(null);
    }

    public static Builder resourceTimeoutError(Throwable cause) {
        return UserException.builder(UserBitShared.DremioPBError.ErrorType.RESOURCE_TIMEOUT, cause);
    }

    public static Builder jsonFieldChangeError() {
        return UserException.jsonFieldChangeError(null);
    }

    public static Builder jsonFieldChangeError(Throwable cause) {
        return UserException.builder(UserBitShared.DremioPBError.ErrorType.JSON_FIELD_CHANGE, cause);
    }

    public static Builder memoryError(Throwable cause) {
        Builder b = UserException.builder(UserBitShared.DremioPBError.ErrorType.OUT_OF_MEMORY, cause).message(MEMORY_ERROR_MSG);
        if (cause != null) {
            b.addContext(cause.getMessage());
        }
        return b;
    }

    public static Builder memoryError() {
        return UserException.memoryError(null);
    }

    @Deprecated
    public static Builder systemError(Throwable cause) {
        return UserException.builder(UserBitShared.DremioPBError.ErrorType.SYSTEM, cause);
    }

    public static Builder connectionError() {
        return UserException.connectionError(null);
    }

    public static Builder connectionError(Throwable cause) {
        return UserException.builder(UserBitShared.DremioPBError.ErrorType.CONNECTION, cause);
    }

    public static Builder dataReadError() {
        return UserException.dataReadError(null);
    }

    public static Builder dataReadError(Throwable cause) {
        return UserException.builder(UserBitShared.DremioPBError.ErrorType.DATA_READ, cause);
    }

    public static Builder sourceInBadState() {
        return UserException.sourceInBadState(null);
    }

    public static Builder sourceInBadState(Throwable cause) {
        return UserException.builder(UserBitShared.DremioPBError.ErrorType.SOURCE_BAD_STATE, cause);
    }

    public static Builder dataWriteError() {
        return UserException.dataWriteError(null);
    }

    public static Builder dataWriteError(Throwable cause) {
        return UserException.builder(UserBitShared.DremioPBError.ErrorType.DATA_WRITE, cause);
    }

    public static Builder functionError() {
        return UserException.functionError(null);
    }

    public static Builder functionError(Throwable cause) {
        return UserException.builder(UserBitShared.DremioPBError.ErrorType.FUNCTION, cause);
    }

    public static Builder parseError() {
        return UserException.parseError(null);
    }

    public static Builder parseError(Throwable cause) {
        return UserException.builder(UserBitShared.DremioPBError.ErrorType.PARSE, cause);
    }

    public static Builder validationError() {
        return UserException.validationError(null);
    }

    public static Builder validationError(Throwable cause) {
        return UserException.builder(UserBitShared.DremioPBError.ErrorType.VALIDATION, cause);
    }

    @Deprecated
    public static Builder pdfsRetriableError() {
        return UserException.pdfsRetriableError(null);
    }

    public static Builder pdfsRetriableError(Throwable cause) {
        return UserException.builder(UserBitShared.DremioPBError.ErrorType.PDFS_RETRIABLE_ERROR, cause);
    }

    public static Builder retryAttemptError() {
        return UserException.retryAttemptError(null);
    }

    public static Builder retryAttemptError(Throwable cause) {
        return UserException.builder(UserBitShared.DremioPBError.ErrorType.RETRY_ATTEMPT_ERROR, cause);
    }

    public static Builder reflectionError() {
        return UserException.reflectionError(null);
    }

    public static Builder reflectionError(Throwable cause) {
        return UserException.builder(UserBitShared.DremioPBError.ErrorType.REFLECTION_ERROR, cause);
    }

    public static Builder refreshDatasetError() {
        return UserException.refreshDatasetError(null);
    }

    public static Builder refreshDatasetError(Throwable cause) {
        return UserException.builder(UserBitShared.DremioPBError.ErrorType.REFRESH_DATASET_ERROR, cause);
    }

    public static Builder permissionError() {
        return UserException.permissionError(null);
    }

    public static Builder permissionError(Throwable cause) {
        return UserException.builder(UserBitShared.DremioPBError.ErrorType.PERMISSION, cause);
    }

    public static Builder planError() {
        return UserException.planError(null);
    }

    public static Builder planError(Throwable cause) {
        return UserException.builder(UserBitShared.DremioPBError.ErrorType.PLAN, cause);
    }

    public static Builder resourceError() {
        return UserException.resourceError(null);
    }

    public static Builder resourceError(Throwable cause) {
        return UserException.builder(UserBitShared.DremioPBError.ErrorType.RESOURCE, cause);
    }

    public static Builder unsupportedError() {
        return UserException.unsupportedError(null);
    }

    public static Builder unsupportedError(Throwable cause) {
        return UserException.builder(UserBitShared.DremioPBError.ErrorType.UNSUPPORTED_OPERATION, cause);
    }

    public static Builder ioExceptionError() {
        return UserException.ioExceptionError(null);
    }

    public static Builder ioExceptionError(Throwable cause) {
        return UserException.builder(UserBitShared.DremioPBError.ErrorType.IO_EXCEPTION, cause);
    }

    public static Builder concurrentModificationError() {
        return UserException.concurrentModificationError(null);
    }

    public static Builder concurrentModificationError(Throwable cause) {
        return UserException.builder(UserBitShared.DremioPBError.ErrorType.CONCURRENT_MODIFICATION, cause);
    }

    protected static Builder builder(UserBitShared.DremioPBError.ErrorType type, Throwable cause) {
        return new Builder(type, cause);
    }

    protected UserException(UserBitShared.DremioPBError.ErrorType errorType, String message, Throwable cause, ByteString rawAdditionalContext) {
        super(message, cause);
        this.errorType = errorType;
        this.context = new UserExceptionContext();
        this.rawAdditionalContext = rawAdditionalContext;
        this.attemptCompletionState = AttemptCompletionState.UNKNOWN;
    }

    private UserException(Builder builder) {
        super(builder.message, builder.cause);
        this.errorType = builder.errorType;
        this.context = builder.context;
        this.rawAdditionalContext = builder.rawAdditionalContext;
        this.attemptCompletionState = builder.attemptCompletionState;
    }

    @Override
    public String getMessage() {
        return super.getMessage();
    }

    public String getErrorIdWithIdentity() {
        CoordinationProtos.NodeEndpoint endpoint = this.context.getEndpoint();
        if (endpoint == null) {
            return "ErrorId: " + this.context.getErrorId();
        }
        return "ErrorId: " + this.context.getErrorId() + " on " + endpoint.getAddress() + ":" + endpoint.getUserPort();
    }

    public String getOriginalMessage() {
        return super.getMessage();
    }

    public String getVerboseMessage() {
        return this.getVerboseMessage(true);
    }

    public String getVerboseMessage(boolean includeErrorIdAndIdentity) {
        return this.generateMessage(includeErrorIdAndIdentity) + "\n\n" + ErrorHelper.buildCausesMessage(this.getCause());
    }

    public AttemptCompletionState getAttemptCompletionState() {
        return this.attemptCompletionState;
    }

    public UserBitShared.DremioPBError getOrCreatePBError(boolean verbose) {
        UserBitShared.DremioPBError.Builder builder = UserBitShared.DremioPBError.newBuilder();
        builder.setErrorType(this.errorType);
        builder.setErrorId(this.context.getErrorId());
        if (this.context.getEndpoint() != null) {
            builder.setEndpoint(this.context.getEndpoint());
        }
        if (this.context.getErrorOrigin() != null) {
            builder.setErrorOrigin(this.context.getErrorOrigin());
        }
        builder.setMessage(this.getVerboseMessage());
        builder.setOriginalMessage(this.getOriginalMessage());
        if (this.getCause() != null) {
            builder.setException(ErrorHelper.getWrapper(this.getCause()));
        }
        builder.addAllContext(this.context.getContextAsStrings());
        if (this.rawAdditionalContext != null) {
            builder.setTypeSpecificContext(this.rawAdditionalContext);
        }
        return builder.build();
    }

    public ByteString getRawAdditionalExceptionContext() {
        return this.rawAdditionalContext;
    }

    public List<String> getContextStrings() {
        return this.context.getContextAsStrings();
    }

    public String getErrorId() {
        return this.context.getErrorId();
    }

    public UserBitShared.DremioPBError.ErrorType getErrorType() {
        return this.errorType;
    }

    public void addErrorOrigin(String role) {
        this.context.addErrorOrigin(role);
    }

    public String getErrorOrigin() {
        return this.context.getErrorOrigin();
    }

    public void addIdentity(CoordinationProtos.NodeEndpoint endpoint) {
        this.context.add(endpoint);
    }

    public CoordinationProtos.NodeEndpoint getIdentity() {
        return this.context.getEndpoint();
    }

    public String getErrorLocation() {
        CoordinationProtos.NodeEndpoint ep = this.context.getEndpoint();
        if (ep != null) {
            return ep.getAddress() + ":" + ep.getUserPort();
        }
        return null;
    }

    private String generateMessage(boolean includeErrorIdAndIdentity) {
        return String.valueOf(this.errorType) + " ERROR: " + super.getMessage() + "\n\n" + this.context.generateContextMessage(includeErrorIdAndIdentity);
    }

    public static final class Builder {
        private final Throwable cause;
        private final UserBitShared.DremioPBError.ErrorType errorType;
        private final UserException uex;
        private final UserExceptionContext context;
        private String message;
        private ByteString rawAdditionalContext;
        private boolean fixedMessage;
        private AttemptCompletionState attemptCompletionState = AttemptCompletionState.UNKNOWN;

        private Builder(UserBitShared.DremioPBError.ErrorType errorType, Throwable cause) {
            this.uex = ErrorHelper.findWrappedCause(cause, UserException.class);
            if (this.uex != null) {
                this.errorType = null;
                this.context = this.uex.context;
                this.cause = cause;
            } else {
                if (ErrorHelper.isDirectMemoryException(cause) || ErrorHelper.isJavaHeapOutOfMemory(cause)) {
                    this.errorType = UserBitShared.DremioPBError.ErrorType.OUT_OF_MEMORY;
                    this.message = UserException.MEMORY_ERROR_MSG;
                    this.cause = cause;
                    this.fixedMessage = true;
                } else {
                    this.cause = cause;
                    this.errorType = errorType;
                    this.message = cause != null ? cause.getMessage() : null;
                }
                this.context = new UserExceptionContext();
            }
        }

        public Builder message(String message) {
            if (this.uex == null && !this.fixedMessage && message != null) {
                this.message = message;
            }
            return this;
        }

        @FormatMethod
        public Builder message(String format, Object ... args) {
            if (this.uex == null && !this.fixedMessage && format != null) {
                this.message = String.format(format, args);
            }
            return this;
        }

        public Builder addIdentity(CoordinationProtos.NodeEndpoint endpoint) {
            this.context.add(endpoint);
            return this;
        }

        public Builder addErrorOrigin(String errorOrigin) {
            this.context.addErrorOrigin(errorOrigin);
            return this;
        }

        public Builder addContext(String value) {
            this.context.add(String.valueOf(value));
            return this;
        }

        @FormatMethod
        public Builder addContext(String value, Object ... args) {
            return this.addContext(String.format(value, args));
        }

        public Builder addContext(String name, String value) {
            this.context.add(name, value);
            return this;
        }

        public Builder addContext(String name, long value) {
            this.context.add(name, value);
            return this;
        }

        public Builder addContext(String name, double value) {
            this.context.add(name, value);
            return this;
        }

        public Builder pushContext(String value) {
            this.context.push(String.valueOf(value));
            return this;
        }

        public Builder pushContext(String name, String value) {
            this.context.push(name, value);
            return this;
        }

        public Builder pushContext(String name, long value) {
            this.context.push(name, value);
            return this;
        }

        public Builder pushContext(String name, double value) {
            this.context.push(name, value);
            return this;
        }

        public Builder setAdditionalExceptionContext(AdditionalExceptionContext additionalContext) {
            assert (additionalContext.getErrorType() == this.errorType) : "error type of context and builder must match";
            this.rawAdditionalContext = additionalContext.toByteString();
            return this;
        }

        public Builder attemptCompletionState(AttemptCompletionState attemptCompletionState) {
            this.attemptCompletionState = attemptCompletionState;
            return this;
        }

        @Deprecated
        public UserException build(Logger logger) {
            boolean isSystemError;
            if (this.uex != null) {
                return this.uex;
            }
            boolean bl = isSystemError = this.errorType == UserBitShared.DremioPBError.ErrorType.SYSTEM;
            if (isSystemError) {
                this.message = ErrorHelper.getRootMessage(this.cause);
            } else if (this.message == null || this.message.length() == 0) {
                this.message = this.cause != null ? this.cause.getClass().getSimpleName() : "";
            }
            UserException newException = new UserException(this);
            if (logger != null) {
                try {
                    switch (this.errorType) {
                        case SYSTEM: {
                            logger.error(newException.getMessage(), newException);
                            break;
                        }
                        case OUT_OF_MEMORY: {
                            logger.error(newException.getMessage(), newException);
                            break;
                        }
                        case SCHEMA_CHANGE: 
                        case IO_EXCEPTION: {
                            logger.debug(newException.getMessage(), newException);
                            break;
                        }
                        case VALIDATION: 
                        case PLAN: {
                            logger.trace(newException.getMessage(), newException);
                            break;
                        }
                        default: {
                            logger.info("User Error Occurred [" + newException.getErrorIdWithIdentity() + "]", newException);
                            break;
                        }
                    }
                }
                catch (Throwable ignore) {
                    Exception e = new Exception("Failure while logging", ignore.getCause());
                    e.addSuppressed(newException);
                    e.printStackTrace();
                    newException.addSuppressed(ignore);
                }
            }
            return newException;
        }

        @Deprecated
        public UserException build() {
            return this.build(logger);
        }

        public UserException buildSilently() {
            return this.build(null);
        }
    }

    public static enum AttemptCompletionState {
        SUCCESS,
        CLIENT_CANCELLED,
        PLANNING_TIMEOUT,
        ENGINE_TIMEOUT,
        RUNTIME_EXCEEDED,
        HEAP_MONITOR_C,
        HEAP_MONITOR_E,
        UNKNOWN,
        DREMIO_PB_ERROR;

    }
}

