/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.common.exceptions;

import com.dremio.jdbc.shaded.com.dremio.common.exceptions.OutOfMemoryOrResourceExceptionContext;
import com.dremio.jdbc.shaded.com.dremio.common.exceptions.UserException;
import com.dremio.jdbc.shaded.com.dremio.exec.proto.UserBitShared;
import com.dremio.jdbc.shaded.org.slf4j.Logger;
import com.dremio.jdbc.shaded.org.slf4j.LoggerFactory;
import java.util.List;

public final class UserRemoteException
extends UserException {
    private static final Logger logger = LoggerFactory.getLogger(UserRemoteException.class);
    private final UserBitShared.DremioPBError error;

    private UserRemoteException(UserBitShared.DremioPBError error) {
        super(error.getErrorType(), "Dremio Remote Exception", null, error.getTypeSpecificContext());
        super.addErrorOrigin(error.getErrorOrigin());
        this.error = error;
    }

    @Override
    public String getMessage() {
        return this.error.getMessage();
    }

    @Override
    public String getOriginalMessage() {
        return this.error.getOriginalMessage();
    }

    @Override
    public String getVerboseMessage() {
        return this.getVerboseMessage(true);
    }

    @Override
    public String getVerboseMessage(boolean includeErrorIdAndIdentity) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.error.getMessage());
        if (this.error.getContextCount() > 0) {
            sb.append("\n\n");
            for (String context : this.error.getContextList()) {
                sb.append(context).append("\n");
            }
        }
        if (this.error.getErrorOrigin() != null) {
            sb.append("\nErrorOrigin: ");
            sb.append(this.error.getErrorOrigin());
            sb.append("\n");
        }
        if (this.error.hasTypeSpecificContext() && this.error.getErrorType() == UserBitShared.DremioPBError.ErrorType.OUT_OF_MEMORY) {
            try {
                OutOfMemoryOrResourceExceptionContext oomExceptionContext = OutOfMemoryOrResourceExceptionContext.fromUserException(this);
                sb.append("OOM Type: ");
                sb.append((Object)oomExceptionContext.getMemoryType());
                sb.append("\n");
                sb.append("OOM Details: ");
                sb.append(oomExceptionContext.getAdditionalInfo());
            }
            catch (Exception e) {
                logger.error("Exception during parsing OutOfMemoryExceptionContext, but ignored ", e);
            }
        }
        if (this.error.hasException()) {
            sb.append("\n");
            for (UserBitShared.StackTraceElementWrapper stackLine : this.error.getException().getStackTraceList()) {
                sb.append(stackLine.getClassName()).append("(").append(stackLine.getFileName()).append(":").append(stackLine.getLineNumber()).append(")\n");
            }
        }
        return sb.toString();
    }

    @Override
    public UserBitShared.DremioPBError getOrCreatePBError(boolean verbose) {
        return this.error;
    }

    @Override
    public List<String> getContextStrings() {
        return this.error.getContextList();
    }

    public static UserRemoteException create(UserBitShared.DremioPBError error) {
        return new UserRemoteException(error);
    }
}

