/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.common.expression;

import com.dremio.jdbc.shaded.com.dremio.common.expression.PathSegment;
import com.dremio.jdbc.shaded.com.dremio.common.expression.ProvidesUnescapedPath;
import com.dremio.jdbc.shaded.com.dremio.exec.proto.UserBitShared;
import java.util.ArrayList;
import java.util.List;

public abstract class BasePath
implements ProvidesUnescapedPath {
    protected final PathSegment.NameSegment rootSegment;

    protected BasePath(BasePath path) {
        this.rootSegment = path.rootSegment;
    }

    public BasePath(PathSegment.NameSegment rootSegment) {
        this.rootSegment = rootSegment;
    }

    public PathSegment getLastSegment() {
        PathSegment s2 = this.rootSegment;
        while (s2.getChild() != null) {
            s2 = s2.getChild();
        }
        return s2;
    }

    public UserBitShared.NamePart getAsNamePart() {
        return BasePath.getNamePart(this.rootSegment);
    }

    public <IN, OUT> OUT accept(SchemaPathVisitor<IN, OUT> visitor, IN in) {
        return this.getRootSegment().accept(visitor, in);
    }

    public List<String> getNameSegments() {
        ArrayList<String> segments = new ArrayList<String>();
        for (PathSegment seg = this.rootSegment; seg != null; seg = seg.getChild()) {
            if (!((PathSegment)seg).getType().equals((Object)PathSegment.PathSegmentType.NAME)) continue;
            segments.add(seg.getNameSegment().getPath());
        }
        return segments;
    }

    public List<String> getComplexNameSegments() {
        ArrayList<String> segments = new ArrayList<String>();
        for (PathSegment seg = this.rootSegment; seg != null; seg = seg.getChild()) {
            if (((PathSegment)seg).getType().equals((Object)PathSegment.PathSegmentType.NAME)) {
                segments.add(seg.getNameSegment().getPath());
                continue;
            }
            if (!((PathSegment)seg).getType().equals((Object)PathSegment.PathSegmentType.ARRAY_INDEX)) continue;
            segments.add("list");
            segments.add("element");
        }
        return segments;
    }

    protected static PathSegment getPathSegment(UserBitShared.NamePart n) {
        PathSegment child;
        PathSegment pathSegment = child = n.hasChild() ? BasePath.getPathSegment(n.getChild()) : null;
        if (n.getType() == UserBitShared.NamePart.Type.ARRAY) {
            return new PathSegment.ArraySegment(child);
        }
        return new PathSegment.NameSegment(n.getName(), child);
    }

    public boolean isSimplePath() {
        for (PathSegment seg = this.rootSegment; seg != null; seg = seg.getChild()) {
            if (!((PathSegment)seg).getType().equals((Object)PathSegment.PathSegmentType.ARRAY_INDEX) && !((PathSegment)seg).getType().equals((Object)PathSegment.PathSegmentType.ARRAY_INDEX_REF) || seg.isLastPath()) continue;
            return false;
        }
        return true;
    }

    public PathSegment.NameSegment getRootSegment() {
        return this.rootSegment;
    }

    @Override
    public String getAsUnescapedPath() {
        StringBuilder sb = new StringBuilder();
        PathSegment seg = this.getRootSegment();
        if (seg.getType().equals((Object)PathSegment.PathSegmentType.ARRAY_INDEX) || seg.getType().equals((Object)PathSegment.PathSegmentType.ARRAY_INDEX_REF)) {
            throw new IllegalStateException("Dremio doesn't currently support top level arrays");
        }
        sb.append(seg.getNameSegment().getPath());
        while ((seg = seg.getChild()) != null) {
            if (seg.getType().equals((Object)PathSegment.PathSegmentType.NAME)) {
                sb.append('.');
                sb.append(seg.getNameSegment().getPath());
                continue;
            }
            if (seg.getType().equals((Object)PathSegment.PathSegmentType.ARRAY_INDEX_REF)) {
                sb.append('[');
                sb.append(seg.getArrayInputRef().getPath());
                sb.append(']');
                continue;
            }
            sb.append('[');
            sb.append(seg.getArraySegment().getOptionalIndex());
            sb.append(']');
        }
        return sb.toString();
    }

    public static BasePath getSimple(String name) {
        return new BasePath(new PathSegment.NameSegment(name)){};
    }

    private static UserBitShared.NamePart getNamePart(PathSegment s2) {
        if (s2 == null) {
            return null;
        }
        UserBitShared.NamePart.Builder b = UserBitShared.NamePart.newBuilder();
        if (s2.getChild() != null) {
            b.setChild(BasePath.getNamePart(s2.getChild()));
        }
        if (s2.getType().equals((Object)PathSegment.PathSegmentType.ARRAY_INDEX)) {
            if (s2.getArraySegment().hasIndex()) {
                throw new IllegalStateException("You cannot convert a indexed schema path to a NamePart.  NameParts can only reference Vectors, not individual records or values.");
            }
            b.setType(UserBitShared.NamePart.Type.ARRAY);
        } else {
            b.setType(UserBitShared.NamePart.Type.NAME);
            b.setName(s2.getNameSegment().getPath());
        }
        return b.build();
    }

    public static interface SchemaPathVisitor<IN, OUT> {
        public OUT visitName(PathSegment.NameSegment var1, IN var2);

        public OUT visitArray(PathSegment.ArraySegment var1, IN var2);

        public OUT visitArrayInput(PathSegment.ArraySegmentInputRef var1, IN var2);
    }
}

