/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.common.expression;

import com.dremio.jdbc.shaded.com.dremio.common.expression.AbstractArrowTypeVisitor;
import com.dremio.jdbc.shaded.com.dremio.common.expression.ArrowLateType;
import com.dremio.jdbc.shaded.com.dremio.common.expression.Describer;
import com.dremio.jdbc.shaded.com.dremio.common.expression.ProvidesUnescapedPath;
import com.dremio.jdbc.shaded.com.dremio.common.expression.SqlDisplaySizeVisitor;
import com.dremio.jdbc.shaded.com.dremio.common.expression.SqlTypeNameVisitor;
import com.dremio.jdbc.shaded.com.dremio.common.types.SupportsTypeCoercionsAndUpPromotions;
import com.dremio.jdbc.shaded.com.dremio.common.types.TypeProtos;
import com.dremio.jdbc.shaded.com.dremio.common.util.MajorTypeHelper;
import com.dremio.jdbc.shaded.com.dremio.common.util.ObjectType;
import com.dremio.jdbc.shaded.com.dremio.exec.exception.NoSupportedUpPromotionOrCoercionException;
import com.dremio.jdbc.shaded.com.fasterxml.jackson.core.JsonGenerator;
import com.dremio.jdbc.shaded.com.fasterxml.jackson.core.JsonParser;
import com.dremio.jdbc.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import com.dremio.jdbc.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import com.dremio.jdbc.shaded.com.fasterxml.jackson.databind.JsonDeserializer;
import com.dremio.jdbc.shaded.com.fasterxml.jackson.databind.JsonSerializer;
import com.dremio.jdbc.shaded.com.fasterxml.jackson.databind.SerializerProvider;
import com.dremio.jdbc.shaded.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.dremio.jdbc.shaded.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.dremio.jdbc.shaded.com.google.common.annotations.VisibleForTesting;
import com.dremio.jdbc.shaded.com.google.common.base.Objects;
import com.dremio.jdbc.shaded.com.google.common.base.Preconditions;
import com.dremio.jdbc.shaded.com.google.common.collect.FluentIterable;
import com.dremio.jdbc.shaded.com.google.common.collect.ImmutableList;
import com.dremio.jdbc.shaded.com.google.flatbuffers.FlatBufferBuilder;
import com.dremio.jdbc.shaded.org.apache.arrow.flatbuf.Schema;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.BigIntVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.BitVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.DateMilliVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.DecimalVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.FieldVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.Float4Vector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.Float8Vector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.IntVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.IntervalDayVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.IntervalYearVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.SmallIntVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.TimeMilliVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.TimeStampMilliVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.TinyIntVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.UInt1Vector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.UInt2Vector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.UInt4Vector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.UInt8Vector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.VarBinaryVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.VarCharVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.ZeroVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.complex.ListVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.complex.MapVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.complex.StructVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.complex.UnionVector;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.holders.BigIntHolder;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.holders.BitHolder;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.holders.ComplexHolder;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.holders.DateMilliHolder;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.holders.DecimalHolder;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.holders.Float4Holder;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.holders.Float8Holder;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.holders.IntHolder;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.holders.IntervalDayHolder;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.holders.IntervalYearHolder;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.holders.NullableBigIntHolder;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.holders.NullableBitHolder;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.holders.NullableDateMilliHolder;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.holders.NullableDecimalHolder;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.holders.NullableFixedSizeBinaryHolder;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.holders.NullableFloat4Holder;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.holders.NullableFloat8Holder;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.holders.NullableIntHolder;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.holders.NullableIntervalDayHolder;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.holders.NullableIntervalYearHolder;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.holders.NullableTimeMilliHolder;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.holders.NullableTimeStampMilliHolder;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.holders.NullableVarBinaryHolder;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.holders.NullableVarCharHolder;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.holders.ObjectHolder;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.holders.TimeMilliHolder;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.holders.TimeStampMilliHolder;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.holders.UnionHolder;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.holders.ValueHolder;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.holders.VarBinaryHolder;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.holders.VarCharHolder;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.types.DateUnit;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.types.FloatingPointPrecision;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.types.IntervalUnit;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.types.TimeUnit;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.types.Types;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.types.UnionMode;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.types.pojo.ArrowType;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.types.pojo.Field;
import com.dremio.jdbc.shaded.org.apache.arrow.vector.types.pojo.FieldType;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;

@JsonSerialize(using=Ser.class)
@JsonDeserialize(using=De.class)
public class CompleteType {
    public static final int MAX_DECIMAL_PRECISION = 38;
    public static final int DEFAULT_VARCHAR_PRECISION = 65536;
    public static final CompleteType NULL = new CompleteType((ArrowType)ArrowType.Null.INSTANCE, new Field[0]);
    public static final CompleteType LATE = new CompleteType(ArrowLateType.INSTANCE, new Field[0]);
    public static final CompleteType OBJECT = new CompleteType(ObjectType.INTERNAL_OBJECT_TYPE, new Field[0]);
    public static final CompleteType VARBINARY = new CompleteType((ArrowType)ArrowType.Binary.INSTANCE, new Field[0]);
    public static final CompleteType BIT = new CompleteType((ArrowType)ArrowType.Bool.INSTANCE, new Field[0]);
    public static final CompleteType DATE = new CompleteType((ArrowType)new ArrowType.Date(DateUnit.MILLISECOND), new Field[0]);
    public static final CompleteType FLOAT = new CompleteType((ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE), new Field[0]);
    public static final CompleteType DOUBLE = new CompleteType((ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.DOUBLE), new Field[0]);
    public static final CompleteType INTERVAL_DAY_SECONDS = new CompleteType((ArrowType)new ArrowType.Interval(IntervalUnit.DAY_TIME), new Field[0]);
    public static final CompleteType INTERVAL_YEAR_MONTHS = new CompleteType((ArrowType)new ArrowType.Interval(IntervalUnit.YEAR_MONTH), new Field[0]);
    public static final CompleteType INT = new CompleteType((ArrowType)new ArrowType.Int(32, true), new Field[0]);
    public static final CompleteType BIGINT = new CompleteType((ArrowType)new ArrowType.Int(64, true), new Field[0]);
    public static final CompleteType TIME = new CompleteType((ArrowType)new ArrowType.Time(TimeUnit.MILLISECOND, 32), new Field[0]);
    public static final CompleteType TIMESTAMP = new CompleteType((ArrowType)new ArrowType.Timestamp(TimeUnit.MILLISECOND, null), new Field[0]);
    public static final CompleteType VARCHAR = new CompleteType((ArrowType)ArrowType.Utf8.INSTANCE, new Field[0]);
    public static final CompleteType LIST = new CompleteType((ArrowType)ArrowType.List.INSTANCE, new Field[0]);
    public static final CompleteType STRUCT = new CompleteType((ArrowType)ArrowType.Struct.INSTANCE, new Field[0]);
    public static final CompleteType MAP = new CompleteType((ArrowType)new ArrowType.Map(false), new Field[0]);
    public static final CompleteType FIXEDSIZEBINARY = new CompleteType((ArrowType)new ArrowType.FixedSizeBinary(128), new Field[0]);
    public static final CompleteType DECIMAL = new CompleteType((ArrowType)new ArrowType.Decimal(38, 38, 128), new Field[0]);
    private static final String LIST_DATA_NAME = "$data$";
    public static final boolean REJECT_MIXED_DECIMALS = false;
    private final ArrowType type;
    private final ImmutableList<Field> children;

    public CompleteType(ArrowType type, List<Field> children) {
        this.type = type;
        this.children = ImmutableList.copyOf(children);
    }

    public CompleteType(ArrowType type, Field ... children) {
        this(type, Arrays.asList(children));
    }

    public static CompleteType fromMajorType(TypeProtos.MajorType type) {
        switch (type.getMinorType()) {
            case DECIMAL: {
                return CompleteType.fromDecimalPrecisionScale(type.getPrecision(), type.getScale());
            }
        }
        return CompleteType.fromMinorType(type.getMinorType());
    }

    public Field toField(String name) {
        return new Field(name, new FieldType(true, this.type, null), this.children);
    }

    public Field toField(String name, boolean isNullable) {
        return new Field(name, new FieldType(isNullable, this.type, null), this.children);
    }

    public Field toField(ProvidesUnescapedPath ref, boolean isNullable) {
        return new Field(ref.getAsUnescapedPath(), new FieldType(isNullable, this.type, null), this.children);
    }

    public Field toField(ProvidesUnescapedPath ref) {
        return this.toField(ref, true);
    }

    private Field toInternalList() {
        return this.toField(LIST_DATA_NAME);
    }

    private Field toInternalField() {
        String name = Describer.describeInternal(this.type);
        return this.toField(name);
    }

    public TypeProtos.MinorType toMinorType() {
        if (this.type instanceof ObjectType) {
            return TypeProtos.MinorType.GENERIC_OBJECT;
        }
        return MajorTypeHelper.getMinorTypeFromArrowMinorType(Types.getMinorTypeForArrowType(this.type));
    }

    public ArrowType getType() {
        return this.type;
    }

    public <T extends ArrowType> T getType(Class<T> clazz) {
        Preconditions.checkArgument(clazz.isAssignableFrom(this.type.getClass()), "Trying to unwrap type of %s when current type is %s.", (Object)clazz.getName(), (Object)Describer.describe(this.type));
        return (T)((ArrowType)clazz.cast(this.type));
    }

    public ImmutableList<Field> getChildren() {
        return this.children;
    }

    public Field getOnlyChild() {
        Preconditions.checkArgument(this.children.size() == 1);
        return (Field)this.children.get(0);
    }

    public CompleteType getOnlyChildType() {
        return CompleteType.fromField(this.getOnlyChild());
    }

    public boolean isComparable() {
        switch (this.type.getTypeID()) {
            case Struct: 
            case Map: {
                return false;
            }
        }
        return true;
    }

    public static CompleteType fromField(Field field) {
        return new CompleteType(field.getType(), field.getChildren());
    }

    public static CompleteType fromDecimalPrecisionScale(int precision, int scale) {
        return new CompleteType((ArrowType)new ArrowType.Decimal(precision, scale, 128), new Field[0]);
    }

    public static CompleteType fromMinorType(TypeProtos.MinorType type) {
        switch (type) {
            case BIGINT: {
                return BIGINT;
            }
            case BIT: {
                return BIT;
            }
            case DATE: {
                return DATE;
            }
            case FLOAT4: {
                return FLOAT;
            }
            case FLOAT8: {
                return DOUBLE;
            }
            case INT: {
                return INT;
            }
            case INTERVALDAY: {
                return INTERVAL_DAY_SECONDS;
            }
            case INTERVALYEAR: {
                return INTERVAL_YEAR_MONTHS;
            }
            case TIME: {
                return TIME;
            }
            case TIMESTAMPMILLI: {
                return TIMESTAMP;
            }
            case VARBINARY: {
                return VARBINARY;
            }
            case VARCHAR: {
                return VARCHAR;
            }
            case GENERIC_OBJECT: {
                return OBJECT;
            }
            case LATE: {
                return LATE;
            }
            case DECIMAL: {
                return DECIMAL;
            }
            case LIST: {
                return LIST;
            }
            case STRUCT: {
                return STRUCT;
            }
            case MAP: {
                return MAP;
            }
            case UNION: {
                throw new UnsupportedOperationException("You can't create a complete type from a minor type when working with type of " + type.name());
            }
        }
        throw new UnsupportedOperationException("unsupported type " + type.name());
    }

    public boolean isText() {
        return this.type.getTypeID() == ArrowType.ArrowTypeID.Utf8;
    }

    public boolean isInt() {
        return this.equals(INT);
    }

    public boolean isBigInt() {
        return this.equals(BIGINT);
    }

    public boolean isFloat() {
        return this.equals(FLOAT);
    }

    public boolean isDouble() {
        return this.equals(DOUBLE);
    }

    public boolean isNumeric() {
        switch (this.type.getTypeID()) {
            case Decimal: 
            case FloatingPoint: 
            case Int: {
                return true;
            }
        }
        return false;
    }

    public boolean isBoolean() {
        return this.type.getTypeID() == ArrowType.ArrowTypeID.Bool;
    }

    public boolean isTemporal() {
        switch (this.type.getTypeID()) {
            case Date: 
            case Time: 
            case Timestamp: {
                return true;
            }
        }
        return false;
    }

    public boolean isNull() {
        return this.type == ArrowType.Null.INSTANCE;
    }

    public boolean isUnion() {
        return this.type.getTypeID() == ArrowType.ArrowTypeID.Union;
    }

    public boolean isStruct() {
        return this.type.getTypeID() == ArrowType.ArrowTypeID.Struct;
    }

    public boolean isMap() {
        return this.type.getTypeID() == ArrowType.ArrowTypeID.Map;
    }

    public boolean isList() {
        return this.type.getTypeID() == ArrowType.ArrowTypeID.List;
    }

    public boolean isLate() {
        return this == LATE;
    }

    public boolean isComplex() {
        return this.isStruct() || this.isList() || this.isMap();
    }

    public boolean isScalar() {
        switch (this.type.getTypeID()) {
            case Struct: 
            case Map: 
            case List: 
            case Union: {
                return false;
            }
        }
        return true;
    }

    public boolean isFixedWidthScalar() {
        switch (this.type.getTypeID()) {
            case Struct: 
            case Map: 
            case List: 
            case Union: 
            case Binary: 
            case Utf8: {
                return false;
            }
        }
        return true;
    }

    public boolean isFixedWidthType() {
        if (this.type.isComplex()) {
            return false;
        }
        return this.type.getTypeID() != ArrowType.ArrowTypeID.Utf8 && this.type.getTypeID() != ArrowType.ArrowTypeID.Binary && this.type.getTypeID() != ArrowType.ArrowTypeID.LargeBinary && this.type.getTypeID() != ArrowType.ArrowTypeID.LargeUtf8;
    }

    public boolean isVariableWidthScalar() {
        switch (this.type.getTypeID()) {
            case Binary: 
            case Utf8: {
                return true;
            }
        }
        return false;
    }

    public boolean isDecimal() {
        return this.type.getTypeID() == ArrowType.ArrowTypeID.Decimal;
    }

    public boolean isValidDecimal() {
        if (!this.isDecimal()) {
            return false;
        }
        if (this.getPrecision() > 38) {
            throw new IllegalArgumentException("Illegal decimal precision in type: " + String.valueOf(this.type) + ". Max supported precision is 38");
        }
        return true;
    }

    public Class<? extends FieldVector> getValueVectorClass() {
        switch (Types.getMinorTypeForArrowType(this.type)) {
            case UNION: {
                return UnionVector.class;
            }
            case STRUCT: {
                return StructVector.class;
            }
            case LIST: {
                return ListVector.class;
            }
            case MAP: {
                return MapVector.class;
            }
            case NULL: {
                return ZeroVector.class;
            }
            case TINYINT: {
                return TinyIntVector.class;
            }
            case UINT1: {
                return UInt1Vector.class;
            }
            case UINT2: {
                return UInt2Vector.class;
            }
            case SMALLINT: {
                return SmallIntVector.class;
            }
            case INT: {
                return IntVector.class;
            }
            case UINT4: {
                return UInt4Vector.class;
            }
            case FLOAT4: {
                return Float4Vector.class;
            }
            case INTERVALYEAR: {
                return IntervalYearVector.class;
            }
            case TIMEMILLI: {
                return TimeMilliVector.class;
            }
            case BIGINT: {
                return BigIntVector.class;
            }
            case UINT8: {
                return UInt8Vector.class;
            }
            case FLOAT8: {
                return Float8Vector.class;
            }
            case DATEMILLI: {
                return DateMilliVector.class;
            }
            case TIMESTAMPMILLI: {
                return TimeStampMilliVector.class;
            }
            case INTERVALDAY: {
                return IntervalDayVector.class;
            }
            case DECIMAL: {
                return DecimalVector.class;
            }
            case VARBINARY: {
                return VarBinaryVector.class;
            }
            case VARCHAR: {
                return VarCharVector.class;
            }
            case BIT: {
                return BitVector.class;
            }
        }
        throw new UnsupportedOperationException(String.format("Unable to determine vector class for type %s.", this.type));
    }

    public Class<? extends ValueHolder> getHolderClass() {
        if (this == OBJECT) {
            return ObjectHolder.class;
        }
        return this.type.accept(new ArrowType.ArrowTypeVisitor<Class<? extends ValueHolder>>(){

            @Override
            public Class<? extends ValueHolder> visit(ArrowType.Null type) {
                throw new UnsupportedOperationException("You cannot create a holder for a NULL type.");
            }

            @Override
            public Class<? extends ValueHolder> visit(ArrowType.Struct type) {
                return ComplexHolder.class;
            }

            @Override
            public Class<? extends ValueHolder> visit(ArrowType.List type) {
                return ComplexHolder.class;
            }

            @Override
            public Class<? extends ValueHolder> visit(ArrowType.ListView type) {
                return ComplexHolder.class;
            }

            @Override
            public Class<? extends ValueHolder> visit(ArrowType.Union type) {
                return UnionHolder.class;
            }

            @Override
            public Class<? extends ValueHolder> visit(ArrowType.Int type) {
                Preconditions.checkArgument(type.getIsSigned());
                switch (type.getBitWidth()) {
                    case 32: {
                        return NullableIntHolder.class;
                    }
                    case 64: {
                        return NullableBigIntHolder.class;
                    }
                }
                throw new UnsupportedOperationException("Don't support int width of " + type.getBitWidth());
            }

            @Override
            public Class<? extends ValueHolder> visit(ArrowType.FloatingPoint type) {
                switch (type.getPrecision()) {
                    case DOUBLE: {
                        return NullableFloat8Holder.class;
                    }
                    case SINGLE: {
                        return NullableFloat4Holder.class;
                    }
                }
                throw new UnsupportedOperationException("Don't support float with precision of " + String.valueOf((Object)type.getPrecision()));
            }

            @Override
            public Class<? extends ValueHolder> visit(ArrowType.Utf8 type) {
                return NullableVarCharHolder.class;
            }

            @Override
            public Class<? extends ValueHolder> visit(ArrowType.Utf8View type) {
                throw new UnsupportedOperationException("Utf8View is not supported.");
            }

            @Override
            public Class<? extends ValueHolder> visit(ArrowType.Binary type) {
                return NullableVarBinaryHolder.class;
            }

            @Override
            public Class<? extends ValueHolder> visit(ArrowType.BinaryView type) {
                throw new UnsupportedOperationException("BinaryView is not supported.");
            }

            @Override
            public Class<? extends ValueHolder> visit(ArrowType.Bool type) {
                return NullableBitHolder.class;
            }

            @Override
            public Class<? extends ValueHolder> visit(ArrowType.Decimal type) {
                return NullableDecimalHolder.class;
            }

            @Override
            public Class<? extends ValueHolder> visit(ArrowType.Date type) {
                return NullableDateMilliHolder.class;
            }

            @Override
            public Class<? extends ValueHolder> visit(ArrowType.Time type) {
                return NullableTimeMilliHolder.class;
            }

            @Override
            public Class<? extends ValueHolder> visit(ArrowType.Timestamp type) {
                return NullableTimeStampMilliHolder.class;
            }

            @Override
            public Class<? extends ValueHolder> visit(ArrowType.Interval type) {
                switch (type.getUnit()) {
                    case DAY_TIME: {
                        return NullableIntervalDayHolder.class;
                    }
                    case YEAR_MONTH: {
                        return NullableIntervalYearHolder.class;
                    }
                }
                throw new UnsupportedOperationException("Don't support interval with unit of " + String.valueOf((Object)type.getUnit()));
            }

            @Override
            public Class<? extends ValueHolder> visit(ArrowType.FixedSizeList type) {
                return ComplexHolder.class;
            }

            @Override
            public Class<? extends ValueHolder> visit(ArrowType.FixedSizeBinary type) {
                return ComplexHolder.class;
            }

            @Override
            public Class<? extends ValueHolder> visit(ArrowType.LargeBinary type) {
                throw new UnsupportedOperationException("Dremio does not support LargeBinary yet.");
            }

            @Override
            public Class<? extends ValueHolder> visit(ArrowType.LargeList type) {
                throw new UnsupportedOperationException("Dremio does not support LargeUtf8 yet.");
            }

            @Override
            public Class<? extends ValueHolder> visit(ArrowType.LargeUtf8 type) {
                throw new UnsupportedOperationException("Dremio does not support LargeUtf8 yet.");
            }

            @Override
            public Class<? extends ValueHolder> visit(ArrowType.Duration type) {
                throw new UnsupportedOperationException("Dremio does not support duration yet.");
            }

            @Override
            public Class<? extends ValueHolder> visit(ArrowType.RunEndEncoded type) {
                throw new UnsupportedOperationException("Dremio does not support RunEndEncoded yet.");
            }

            @Override
            public Class<? extends ValueHolder> visit(ArrowType.LargeListView type) {
                throw new UnsupportedOperationException("Dremio does not support LargeListView yet.");
            }

            @Override
            public Class<? extends ValueHolder> visit(ArrowType.Map type) {
                return ComplexHolder.class;
            }
        });
    }

    public static <T extends ValueHolder> CompleteType fromHolderClass(Class<T> holderClass) {
        if (holderClass.equals(IntHolder.class)) {
            return INT;
        }
        if (holderClass.equals(NullableIntHolder.class)) {
            return INT;
        }
        if (holderClass.equals(Float4Holder.class)) {
            return FLOAT;
        }
        if (holderClass.equals(NullableFloat4Holder.class)) {
            return FLOAT;
        }
        if (holderClass.equals(IntervalYearHolder.class)) {
            return INTERVAL_YEAR_MONTHS;
        }
        if (holderClass.equals(NullableIntervalYearHolder.class)) {
            return INTERVAL_YEAR_MONTHS;
        }
        if (holderClass.equals(TimeMilliHolder.class)) {
            return TIME;
        }
        if (holderClass.equals(NullableTimeMilliHolder.class)) {
            return TIME;
        }
        if (holderClass.equals(BigIntHolder.class)) {
            return BIGINT;
        }
        if (holderClass.equals(NullableBigIntHolder.class)) {
            return BIGINT;
        }
        if (holderClass.equals(Float8Holder.class)) {
            return DOUBLE;
        }
        if (holderClass.equals(NullableFloat8Holder.class)) {
            return DOUBLE;
        }
        if (holderClass.equals(DateMilliHolder.class)) {
            return DATE;
        }
        if (holderClass.equals(NullableDateMilliHolder.class)) {
            return DATE;
        }
        if (holderClass.equals(TimeStampMilliHolder.class)) {
            return TIMESTAMP;
        }
        if (holderClass.equals(NullableTimeStampMilliHolder.class)) {
            return TIMESTAMP;
        }
        if (holderClass.equals(IntervalDayHolder.class)) {
            return INTERVAL_DAY_SECONDS;
        }
        if (holderClass.equals(NullableIntervalDayHolder.class)) {
            return INTERVAL_DAY_SECONDS;
        }
        if (holderClass.equals(DecimalHolder.class)) {
            return CompleteType.fromDecimalPrecisionScale(0, 0);
        }
        if (holderClass.equals(NullableDecimalHolder.class)) {
            return CompleteType.fromDecimalPrecisionScale(0, 0);
        }
        if (holderClass.equals(VarBinaryHolder.class)) {
            return VARBINARY;
        }
        if (holderClass.equals(NullableVarBinaryHolder.class)) {
            return VARBINARY;
        }
        if (holderClass.equals(VarCharHolder.class)) {
            return VARCHAR;
        }
        if (holderClass.equals(NullableVarCharHolder.class)) {
            return VARCHAR;
        }
        if (holderClass.equals(BitHolder.class)) {
            return BIT;
        }
        if (holderClass.equals(NullableBitHolder.class)) {
            return BIT;
        }
        if (holderClass.equals(ObjectHolder.class)) {
            return OBJECT;
        }
        if (holderClass.equals(UnionHolder.class)) {
            return new CompleteType((ArrowType)new ArrowType.Union(UnionMode.Sparse, new int[0]), new Field[0]);
        }
        if (holderClass.equals(NullableFixedSizeBinaryHolder.class)) {
            return FIXEDSIZEBINARY;
        }
        throw new UnsupportedOperationException(String.format("%s is not supported for 'getValueHolderType' method.", holderClass.getName()));
    }

    public static List<Field> mergeFieldLists(List<Field> fields1, List<Field> fields2) {
        LinkedHashMap<String, Field> secondFieldMap = new LinkedHashMap<String, Field>();
        ArrayList<Field> mergedList = new ArrayList<Field>();
        for (Field field : fields2) {
            secondFieldMap.put(field.getName().toLowerCase(), field);
        }
        for (Field field : fields1) {
            Field matchingField = (Field)secondFieldMap.remove(field.getName().toLowerCase());
            if (matchingField != null) {
                mergedList.add(CompleteType.fromField(field).merge(CompleteType.fromField(matchingField)).toField(field.getName(), field.isNullable()));
                continue;
            }
            mergedList.add(field);
        }
        for (Field field : secondFieldMap.values()) {
            mergedList.add(field);
        }
        return mergedList;
    }

    public static List<Field> mergeFieldListsWithUpPromotionOrCoercion(List<Field> tableFields, List<Field> fileFields, SupportsTypeCoercionsAndUpPromotions coercionRulesSet) {
        LinkedHashMap<String, Field> secondFieldMap = new LinkedHashMap<String, Field>();
        ArrayList<Field> mergedList = new ArrayList<Field>();
        for (Field field : fileFields) {
            secondFieldMap.put(field.getName().toLowerCase(), field);
        }
        for (Field tableSchemaField : tableFields) {
            Field matchingField = (Field)secondFieldMap.remove(tableSchemaField.getName().toLowerCase());
            if (matchingField != null) {
                try {
                    mergedList.add(CompleteType.fromField(tableSchemaField).mergeFieldListsWithUpPromotionOrCoercion(CompleteType.fromField(matchingField), coercionRulesSet).toField(tableSchemaField.getName(), tableSchemaField.isNullable()));
                    continue;
                }
                catch (NoSupportedUpPromotionOrCoercionException e) {
                    e.addColumnName(tableSchemaField.getName());
                    throw e;
                }
            }
            mergedList.add(tableSchemaField);
        }
        mergedList.addAll(secondFieldMap.values());
        return mergedList;
    }

    public CompleteType merge(CompleteType type2) {
        return this.merge(type2, false);
    }

    public CompleteType merge(CompleteType type2, boolean allowMixedDecimals) {
        CompleteType type1 = this;
        if (type1.getType().getTypeID() == ArrowType.ArrowTypeID.Union && type2.getType().getTypeID() == ArrowType.ArrowTypeID.Union) {
            List<Field> subTypes = CompleteType.mergeFieldLists(type1.getChildren(), type2.getChildren());
            int[] typeIds = CompleteType.getTypeIds(subTypes);
            return new CompleteType((ArrowType)new ArrowType.Union(UnionMode.Sparse, typeIds), subTypes);
        }
        if (type1.getType().equals(type2.getType())) {
            if (type1.isScalar()) {
                return type1;
            }
            if (type1.isList()) {
                CompleteType child1 = CompleteType.fromField(type1.getOnlyChild());
                CompleteType child2 = CompleteType.fromField(type2.getOnlyChild());
                return new CompleteType(type1.getType(), child1.merge(child2).toInternalList());
            }
            if (type1.isStruct()) {
                return new CompleteType(type1.getType(), CompleteType.mergeFieldLists(type1.getChildren(), type2.getChildren()));
            }
            if (type1.isMap()) {
                return new CompleteType(type1.getType(), CompleteType.struct(CompleteType.mergeFieldLists(type1.getOnlyChild().getChildren(), type2.getOnlyChild().getChildren())).toField("entries", false));
            }
        }
        if (type1.getType().equals(ArrowType.Null.INSTANCE)) {
            return type2;
        }
        if (type2.getType().equals(ArrowType.Null.INSTANCE)) {
            return type1;
        }
        if (type1.getType().getTypeID() == ArrowType.ArrowTypeID.Decimal || type2.getType().getTypeID() == ArrowType.ArrowTypeID.Decimal) {
            if (!allowMixedDecimals) {
                throw new UnsupportedOperationException("Cannot have mixed types for a decimal field. Found types : " + String.valueOf(type1.getType()) + " , " + String.valueOf(type2.getType()));
            }
            return this.coerceDecimalTypes(type1, type2);
        }
        List<Field> fields1 = type1.isUnion() ? type1.getChildren() : Collections.singletonList(type1.toInternalField());
        List<Field> fields2 = type2.isUnion() ? type2.getChildren() : Collections.singletonList(type2.toInternalField());
        List<Field> mergedFields = CompleteType.mergeFieldLists(fields1, fields2);
        int[] typeIds = CompleteType.getTypeIds(mergedFields);
        return new CompleteType((ArrowType)new ArrowType.Union(UnionMode.Sparse, typeIds), mergedFields);
    }

    @VisibleForTesting
    CompleteType mergeFieldListsWithUpPromotionOrCoercion(CompleteType fileType, SupportsTypeCoercionsAndUpPromotions rules) throws UnsupportedOperationException {
        CompleteType tableType = this;
        if (tableType.isUnion()) {
            tableType = CompleteType.removeUnions(tableType, rules);
        }
        if (fileType.isUnion()) {
            fileType = CompleteType.removeUnions(fileType, rules);
        }
        if (tableType.getType().equals(fileType.getType())) {
            if (tableType.isScalar()) {
                return tableType;
            }
            if (tableType.isList()) {
                CompleteType tableTypeChild = CompleteType.fromField(tableType.getOnlyChild());
                CompleteType fileTypeChild = CompleteType.fromField(fileType.getOnlyChild());
                return new CompleteType(tableType.getType(), tableTypeChild.mergeFieldListsWithUpPromotionOrCoercion(fileTypeChild, rules).toInternalList());
            }
            if (tableType.isStruct()) {
                return new CompleteType(tableType.getType(), CompleteType.mergeFieldListsWithUpPromotionOrCoercion(tableType.getChildren(), fileType.getChildren(), rules));
            }
            if (tableType.isMap()) {
                CompleteType entryStruct = new CompleteType(tableType.getOnlyChildType().getType(), CompleteType.mergeFieldListsWithUpPromotionOrCoercion(tableType.getOnlyChild().getChildren(), fileType.getOnlyChild().getChildren(), rules));
                return new CompleteType(tableType.getType(), entryStruct.toField("entries", false));
            }
            throw new IllegalStateException("Unsupported type: " + String.valueOf(tableType));
        }
        Optional<CompleteType> tableSchemaUpPromotion = rules.getUpPromotionRules().getResultantType(fileType, tableType);
        if (tableSchemaUpPromotion.isPresent()) {
            return tableSchemaUpPromotion.get();
        }
        Optional<CompleteType> typeCoercion = rules.getTypeCoercionRules().getResultantType(fileType, tableType);
        if (typeCoercion.isPresent()) {
            return typeCoercion.get();
        }
        throw new NoSupportedUpPromotionOrCoercionException(fileType, tableType);
    }

    @VisibleForTesting
    public static CompleteType removeUnions(CompleteType type, SupportsTypeCoercionsAndUpPromotions rules) {
        ImmutableList<Field> fieldList = type.getChildren();
        type = new CompleteType(((Field)fieldList.get(0)).getType(), ((Field)fieldList.get(0)).getChildren());
        for (Field currentField : fieldList) {
            CompleteType currentCompleteType = new CompleteType(currentField.getType(), currentField.getChildren());
            type = type.mergeFieldListsWithUpPromotionOrCoercion(currentCompleteType, rules);
        }
        return type;
    }

    private CompleteType coerceDecimalTypes(CompleteType type1, CompleteType type2) {
        CompleteType nonDecimalType;
        CompleteType decimalType;
        if (type1.isDecimal() && type2.isDecimal()) {
            return this.getDecimalUnion(type1, type2);
        }
        if (type1.isDecimal()) {
            decimalType = type1;
            nonDecimalType = type2;
        } else {
            decimalType = type2;
            nonDecimalType = type1;
        }
        if (nonDecimalType.equals(BIGINT)) {
            return this.getDecimalUnion(decimalType, CompleteType.fromDecimalPrecisionScale(19, 0));
        }
        if (nonDecimalType.equals(INT)) {
            return this.getDecimalUnion(decimalType, CompleteType.fromDecimalPrecisionScale(10, 0));
        }
        throw new UnsupportedOperationException("Cannot have mixed types for a decimal field. Found types : " + String.valueOf(type1.getType()) + " , " + String.valueOf(type2.getType()));
    }

    private CompleteType getDecimalUnion(CompleteType type1, CompleteType type2) {
        int outputScale = Math.max(type1.getScale(), type2.getScale());
        int outputPrecision = Math.max(type1.getPrecision() - type1.getScale(), type2.getPrecision() - type2.getScale()) + outputScale;
        if (outputPrecision > 38) {
            throw new UnsupportedOperationException("Incompatible precision and scale(common precision is greater than 38 digits. Please consider downcasting the values Found types : " + String.valueOf(type1.getType()) + " , " + String.valueOf(type2.getType()));
        }
        return CompleteType.fromDecimalPrecisionScale(outputPrecision, outputScale);
    }

    public static int[] getTypeIds(List<Field> subTypes) {
        int[] typeIds = new int[subTypes.size()];
        for (int i = 0; i < typeIds.length; ++i) {
            typeIds[i] = Types.getMinorTypeForArrowType(subTypes.get(i).getType()).ordinal();
        }
        return typeIds;
    }

    public Integer getPrecision() {
        return this.type.accept(new AbstractArrowTypeVisitor<Integer>(){

            @Override
            public Integer visit(ArrowType.Utf8 type) {
                return 65536;
            }

            @Override
            public Integer visit(ArrowType.Binary type) {
                return 65536;
            }

            @Override
            public Integer visit(ArrowType.Decimal type) {
                return type.getPrecision();
            }

            @Override
            public Integer visit(ArrowType.Time type) {
                return MajorTypeHelper.getPrecisionFromTimeUnit(type.getUnit());
            }

            @Override
            public Integer visit(ArrowType.Timestamp type) {
                return MajorTypeHelper.getPrecisionFromTimeUnit(type.getUnit());
            }

            @Override
            protected Integer visitGeneric(ArrowType type) {
                return null;
            }
        });
    }

    public Integer getScale() {
        return this.type.accept(new AbstractArrowTypeVisitor<Integer>(){

            @Override
            public Integer visit(ArrowType.Decimal type) {
                return type.getScale();
            }

            @Override
            protected Integer visitGeneric(ArrowType type) {
                return null;
            }
        });
    }

    public String toString() {
        return Describer.describe(this);
    }

    public int hashCode() {
        return Objects.hashCode(this.children, this.type);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CompleteType other = (CompleteType)obj;
        return Objects.equal(this.children, other.children) && Objects.equal(this.type, other.type);
    }

    public byte[] serialize() {
        FlatBufferBuilder builder = new FlatBufferBuilder();
        builder.finish(this.serialize(builder));
        return builder.sizedByteArray();
    }

    public static CompleteType deserialize(byte[] bytes) {
        Schema schema = Schema.getRootAsSchema(ByteBuffer.wrap(bytes));
        com.dremio.jdbc.shaded.org.apache.arrow.vector.types.pojo.Schema s2 = com.dremio.jdbc.shaded.org.apache.arrow.vector.types.pojo.Schema.convertSchema(schema);
        return CompleteType.fromField(s2.getFields().get(0));
    }

    public int serialize(FlatBufferBuilder builder) {
        com.dremio.jdbc.shaded.org.apache.arrow.vector.types.pojo.Schema schema = new com.dremio.jdbc.shaded.org.apache.arrow.vector.types.pojo.Schema(Collections.singletonList(this.toField("f")));
        return schema.getSchema(builder);
    }

    public CompleteType asList() {
        return new CompleteType((ArrowType)ArrowType.List.INSTANCE, this.toField(LIST_DATA_NAME));
    }

    public static CompleteType struct(Iterable<Field> fields) {
        return new CompleteType((ArrowType)ArrowType.Struct.INSTANCE, ImmutableList.copyOf(fields));
    }

    public static CompleteType union(Field ... fields) {
        return CompleteType.union(FluentIterable.from(fields));
    }

    public static CompleteType union(Iterable<Field> fields) {
        ImmutableList<Field> listOfFields = ImmutableList.copyOf(fields);
        int[] typeIds = new int[listOfFields.size()];
        for (int i = 0; i < typeIds.length; ++i) {
            typeIds[i] = MajorTypeHelper.getArrowMinorType(CompleteType.fromField((Field)listOfFields.get(i)).toMinorType()).ordinal();
        }
        return new CompleteType((ArrowType)new ArrowType.Union(UnionMode.Sparse, typeIds), listOfFields);
    }

    public static CompleteType struct(Field ... fields) {
        return new CompleteType((ArrowType)ArrowType.Struct.INSTANCE, fields);
    }

    public String getSqlTypeName() {
        return this.type.accept(new SqlTypeNameVisitor());
    }

    public int getSqlDisplaySize() {
        return this.type.accept(new SqlDisplaySizeVisitor());
    }

    public boolean isSigned() {
        return this.type.accept(new AbstractArrowTypeVisitor<Boolean>(){

            @Override
            public Boolean visit(ArrowType.Int type) {
                return true;
            }

            @Override
            public Boolean visit(ArrowType.FloatingPoint type) {
                return true;
            }

            @Override
            public Boolean visit(ArrowType.Decimal type) {
                return true;
            }

            @Override
            protected Boolean visitGeneric(ArrowType type) {
                return false;
            }
        });
    }

    public boolean isSortable() {
        return this.type.accept(new AbstractArrowTypeVisitor<Boolean>(){

            @Override
            public Boolean visit(ArrowType.Null type) {
                return false;
            }

            @Override
            public Boolean visit(ArrowType.Struct type) {
                return false;
            }

            @Override
            public Boolean visit(ArrowType.Map type) {
                return false;
            }

            @Override
            public Boolean visit(ArrowType.List type) {
                return false;
            }

            @Override
            public Boolean visit(ArrowType.ListView type) {
                return false;
            }

            @Override
            public Boolean visit(ArrowType.Union type) {
                return false;
            }

            @Override
            protected Boolean visitGeneric(ArrowType type) {
                return true;
            }
        });
    }

    private static ArrowType convertToSupportedArrowType(ArrowType arrowType) {
        switch (arrowType.getTypeID()) {
            case Int: {
                ArrowType.Int arrowInt = (ArrowType.Int)arrowType;
                if (arrowInt.getBitWidth() < 32) {
                    return INT.getType();
                }
                if (arrowInt.getBitWidth() == 32 && !arrowInt.getIsSigned()) {
                    return BIGINT.getType();
                }
                if (arrowInt.getBitWidth() == 64 && !arrowInt.getIsSigned()) {
                    return DOUBLE.getType();
                }
                return arrowInt;
            }
            case Date: {
                return DATE.getType();
            }
            case Time: {
                return TIME.getType();
            }
            case Timestamp: {
                return TIMESTAMP.getType();
            }
        }
        return arrowType;
    }

    private static String convertFieldName(String fieldName) {
        return fieldName == null ? LIST_DATA_NAME : fieldName;
    }

    public static List<Field> convertToDremioFields(List<Field> arrowFields) {
        if (arrowFields == null) {
            return null;
        }
        ArrayList<Field> dremioFields = new ArrayList<Field>();
        for (Field field : arrowFields) {
            if (field.getType().getTypeID() == ArrowType.ArrowTypeID.Map) {
                dremioFields.add(CompleteType.convertMapToDremioField(field));
                continue;
            }
            dremioFields.add(new Field(CompleteType.convertFieldName(field.getName()), new FieldType(true, CompleteType.convertToSupportedArrowType(field.getType()), null), CompleteType.convertToDremioFields(field.getChildren())));
        }
        return dremioFields;
    }

    public static Field convertMapToDremioField(Field arrowField) {
        Field entryStruct = arrowField.getChildren().get(0);
        Field keyField = entryStruct.getChildren().get(0);
        Field valueField = entryStruct.getChildren().get(1);
        if (keyField.getType().isComplex()) {
            throw new UnsupportedOperationException("Cannot have complex key in map data type for field " + arrowField.getName());
        }
        ArrayList<Field> childFields = new ArrayList<Field>();
        childFields.add(new Field(CompleteType.convertFieldName(keyField.getName()), new FieldType(false, CompleteType.convertToSupportedArrowType(keyField.getType()), null), null));
        childFields.add(CompleteType.convertToDremioFields(Arrays.asList(valueField)).get(0));
        Field entries = new Field(entryStruct.getName() == null ? "entries" : entryStruct.getName(), new FieldType(false, CompleteType.convertToSupportedArrowType(entryStruct.getType()), null), childFields);
        return new Field(CompleteType.convertFieldName(arrowField.getName()), new FieldType(arrowField.isNullable(), CompleteType.convertToSupportedArrowType(arrowField.getType()), null), Collections.singletonList(entries));
    }

    public static class De
    extends JsonDeserializer<CompleteType> {
        @Override
        public CompleteType deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return CompleteType.deserialize(p.getBinaryValue());
        }
    }

    public static class Ser
    extends JsonSerializer<CompleteType> {
        @Override
        public void serialize(CompleteType value, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
            gen.writeBinary(value.serialize());
        }
    }
}

