/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.common.expression;

import com.dremio.jdbc.shaded.com.dremio.common.expression.BasePath;
import com.dremio.jdbc.shaded.com.dremio.exec.record.TypedFieldId;
import java.util.Optional;

public abstract class PathSegment {
    protected PathSegment child;
    private int hash;

    protected PathSegment(PathSegment child) {
        this.child = child;
    }

    public abstract PathSegment cloneWithNewChild(PathSegment var1);

    public abstract PathSegment cloneWithoutChild();

    public abstract PathSegment clone();

    public abstract <IN, OUT> OUT accept(BasePath.SchemaPathVisitor<IN, OUT> var1, IN var2);

    public abstract PathSegment getPathSegment();

    public abstract PathSegmentType getType();

    public NameSegment getNameSegment() {
        PathSegment current = this.getPathSegment();
        if (current instanceof NameSegment) {
            return (NameSegment)current;
        }
        throw new UnsupportedOperationException();
    }

    public ArraySegment getArraySegment() {
        PathSegment current = this.getPathSegment();
        if (current instanceof ArraySegment) {
            return (ArraySegment)current;
        }
        throw new UnsupportedOperationException();
    }

    public ArraySegmentInputRef getArrayInputRef() {
        PathSegment current = this.getPathSegment();
        if (current instanceof ArraySegmentInputRef) {
            return (ArraySegmentInputRef)current;
        }
        throw new UnsupportedOperationException();
    }

    public boolean isLastPath() {
        return this.child == null;
    }

    public PathSegment getChild() {
        return this.child;
    }

    void setChild(PathSegment child) {
        this.child = child;
    }

    protected abstract int segmentHashCode();

    protected abstract boolean segmentEquals(PathSegment var1);

    public int hashCode() {
        int h2 = this.hash;
        if (h2 == 0) {
            h2 = this.segmentHashCode();
            this.hash = h2 = 31 * h2 + (this.child == null ? 0 : this.child.hashCode());
        }
        return h2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PathSegment other = (PathSegment)obj;
        if (!this.segmentEquals(other)) {
            return false;
        }
        if (this.child == null) {
            return other.child == null;
        }
        return this.child.equals(other.child);
    }

    public boolean contains(PathSegment otherSeg) {
        if (this == otherSeg) {
            return true;
        }
        if (otherSeg == null) {
            return false;
        }
        if (otherSeg.getType().equals((Object)PathSegmentType.ARRAY_INDEX) || this.getType().equals((Object)PathSegmentType.ARRAY_INDEX)) {
            return true;
        }
        if (this.getClass() != otherSeg.getClass()) {
            return false;
        }
        if (!this.segmentEquals(otherSeg)) {
            return false;
        }
        if (this.child == null || otherSeg.child == null) {
            return true;
        }
        return this.child.contains(otherSeg.child);
    }

    public static final class NameSegment
    extends PathSegment {
        private final String path;

        public NameSegment(CharSequence n, PathSegment child) {
            super(child);
            this.path = n.toString();
        }

        public NameSegment(CharSequence n) {
            this(n, null);
        }

        public String getPath() {
            return this.path;
        }

        @Override
        public NameSegment cloneWithoutChild() {
            if (this.isLastPath()) {
                return null;
            }
            return new NameSegment(this.path, this.child.cloneWithoutChild());
        }

        @Override
        public PathSegmentType getType() {
            return PathSegmentType.NAME;
        }

        @Override
        public PathSegment getPathSegment() {
            return this;
        }

        @Override
        public <IN, OUT> OUT accept(BasePath.SchemaPathVisitor<IN, OUT> visitor, IN in) {
            return visitor.visitName(this, in);
        }

        public String toString() {
            return "NameSegment [path=" + this.path + ", getChild()=" + String.valueOf(this.getChild()) + "]";
        }

        @Override
        public int segmentHashCode() {
            return this.path == null ? 0 : this.path.toLowerCase().hashCode();
        }

        @Override
        public boolean segmentEquals(PathSegment obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NameSegment other = (NameSegment)obj;
            if (this.path == null) {
                return other.path == null;
            }
            return this.path.equalsIgnoreCase(other.path);
        }

        @Override
        public NameSegment clone() {
            NameSegment s2 = new NameSegment(this.path);
            if (this.child != null) {
                s2.setChild(this.child.clone());
            }
            return s2;
        }

        @Override
        public NameSegment cloneWithNewChild(PathSegment newChild) {
            NameSegment s2 = new NameSegment(this.path);
            if (this.child != null) {
                s2.setChild(this.child.cloneWithNewChild(newChild));
            } else {
                s2.setChild(newChild);
            }
            return s2;
        }
    }

    public static final class ArraySegment
    extends PathSegment {
        private final Optional<Integer> optionalIndex;

        public ArraySegment(Optional<Integer> optionalIndex, PathSegment child) {
            super(child);
            if (optionalIndex.isPresent() && optionalIndex.get() < 0) {
                throw new IllegalArgumentException("Expected a non negative index for array indexing. Got: " + String.valueOf(optionalIndex.get()));
            }
            this.optionalIndex = optionalIndex;
        }

        public ArraySegment(String numberAsText, PathSegment child) {
            this(Integer.parseInt(numberAsText), child);
        }

        public ArraySegment(int index, PathSegment child) {
            this(Optional.of(index), child);
        }

        public ArraySegment(PathSegment child) {
            this(Optional.empty(), child);
        }

        public ArraySegment(int index) {
            this(Optional.of(index), null);
        }

        public boolean hasIndex() {
            return this.optionalIndex.isPresent();
        }

        public int getOptionalIndex() {
            return this.optionalIndex.orElse(-1);
        }

        @Override
        public PathSegmentType getType() {
            return PathSegmentType.ARRAY_INDEX;
        }

        @Override
        public PathSegment getPathSegment() {
            return this;
        }

        @Override
        public <IN, OUT> OUT accept(BasePath.SchemaPathVisitor<IN, OUT> visitor, IN in) {
            return visitor.visitArray(this, in);
        }

        public String toString() {
            return "ArraySegment [index=" + this.getOptionalIndex() + ", getChild()=" + String.valueOf(this.getChild()) + "]";
        }

        @Override
        public int segmentHashCode() {
            return this.getOptionalIndex();
        }

        @Override
        public boolean segmentEquals(PathSegment obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (obj instanceof ArraySegment) {
                return this.optionalIndex.equals(((ArraySegment)obj).optionalIndex);
            }
            return false;
        }

        @Override
        public PathSegment clone() {
            ArraySegment seg;
            ArraySegment arraySegment = seg = !this.optionalIndex.isPresent() ? new ArraySegment(null) : new ArraySegment(this.optionalIndex.get());
            if (this.child != null) {
                seg.setChild(this.child.clone());
            }
            return seg;
        }

        @Override
        public ArraySegment cloneWithNewChild(PathSegment newChild) {
            ArraySegment seg;
            ArraySegment arraySegment = seg = !this.optionalIndex.isPresent() ? new ArraySegment(null) : new ArraySegment(this.optionalIndex.get());
            if (this.child != null) {
                seg.setChild(this.child.cloneWithNewChild(newChild));
            } else {
                seg.setChild(newChild);
            }
            return seg;
        }

        @Override
        public PathSegment cloneWithoutChild() {
            if (this.isLastPath()) {
                return null;
            }
            return new ArraySegment(this.optionalIndex, this.child.cloneWithoutChild());
        }
    }

    public static final class ArraySegmentInputRef
    extends PathSegment {
        private final String path;
        private TypedFieldId fieldId;

        public ArraySegmentInputRef(CharSequence n, PathSegment child) {
            super(child);
            this.path = n.toString();
        }

        public ArraySegmentInputRef(CharSequence n) {
            this(n, null);
        }

        public String getPath() {
            return this.path;
        }

        public TypedFieldId getFieldId() {
            return this.fieldId;
        }

        public void setFieldId(TypedFieldId fieldId) {
            this.fieldId = fieldId;
        }

        @Override
        public ArraySegmentInputRef cloneWithoutChild() {
            if (this.isLastPath()) {
                return null;
            }
            return new ArraySegmentInputRef(this.path, this.child.cloneWithoutChild());
        }

        @Override
        public PathSegmentType getType() {
            return PathSegmentType.ARRAY_INDEX_REF;
        }

        @Override
        public PathSegment getPathSegment() {
            return this;
        }

        @Override
        public <IN, OUT> OUT accept(BasePath.SchemaPathVisitor<IN, OUT> visitor, IN in) {
            return visitor.visitArrayInput(this, in);
        }

        public String toString() {
            return "ArrayInputRef [path=" + this.path + ", getChild()=" + String.valueOf(this.getChild()) + "]";
        }

        @Override
        public int segmentHashCode() {
            return this.path == null ? 0 : this.path.toLowerCase().hashCode();
        }

        @Override
        public boolean segmentEquals(PathSegment obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ArraySegmentInputRef other = (ArraySegmentInputRef)obj;
            if (this.path == null) {
                return other.path == null;
            }
            return this.path.equalsIgnoreCase(other.path);
        }

        @Override
        public ArraySegmentInputRef clone() {
            ArraySegmentInputRef s2 = new ArraySegmentInputRef(this.path);
            if (this.child != null) {
                s2.setChild(this.child.clone());
            }
            return s2;
        }

        @Override
        public ArraySegmentInputRef cloneWithNewChild(PathSegment newChild) {
            ArraySegmentInputRef s2 = new ArraySegmentInputRef(this.path);
            if (this.child != null) {
                s2.setChild(this.child.cloneWithNewChild(newChild));
            } else {
                s2.setChild(newChild);
            }
            return s2;
        }
    }

    public static enum PathSegmentType {
        ARRAY_INDEX,
        ARRAY_INDEX_REF,
        NAME;

    }
}

