/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.common.logging;

import com.dremio.jdbc.shaded.com.dremio.common.logging.StructuredLogger;
import com.dremio.jdbc.shaded.com.google.common.annotations.VisibleForTesting;
import com.dremio.jdbc.shaded.com.google.protobuf.Message;
import com.dremio.jdbc.shaded.net.logstash.logback.argument.StructuredArguments;
import com.dremio.jdbc.shaded.org.apache.commons.lang3.ArrayUtils;
import com.dremio.jdbc.shaded.org.slf4j.Logger;
import com.dremio.jdbc.shaded.org.slf4j.LoggerFactory;

class ProtobufStructuredLogger<T extends Message>
implements StructuredLogger<T> {
    private final Logger logger;

    ProtobufStructuredLogger(Logger logger) {
        this.logger = logger;
    }

    @VisibleForTesting
    Object[] constructArgsArray(T data, Object ... args) {
        if (args[args.length - 1] instanceof Throwable) {
            return ArrayUtils.insert(args.length - 1, args, StructuredArguments.f(data));
        }
        return ArrayUtils.add(args, StructuredArguments.f(data));
    }

    @Override
    public void info(T data, String message, Object ... args) {
        if (!this.logger.isInfoEnabled()) {
            return;
        }
        this.logger.info(message, this.constructArgsArray(data, args));
    }

    @Override
    public void debug(T data, String message, Object ... args) {
        if (!this.logger.isDebugEnabled()) {
            return;
        }
        this.logger.debug(message, this.constructArgsArray(data, args));
    }

    @Override
    public void warn(T data, String message, Object ... args) {
        if (!this.logger.isWarnEnabled()) {
            return;
        }
        this.logger.warn(message, this.constructArgsArray(data, args));
    }

    @Override
    public void error(T data, String message, Object ... args) {
        if (!this.logger.isErrorEnabled()) {
            return;
        }
        this.logger.error(message, this.constructArgsArray(data, args));
    }

    @Override
    public void info(T data, String message) {
        if (!this.logger.isInfoEnabled()) {
            return;
        }
        this.logger.info(message, (Object)StructuredArguments.f(data));
    }

    @Override
    public void debug(T data, String message) {
        if (!this.logger.isDebugEnabled()) {
            return;
        }
        this.logger.debug(message, (Object)StructuredArguments.f(data));
    }

    @Override
    public void warn(T data, String message) {
        if (!this.logger.isWarnEnabled()) {
            return;
        }
        this.logger.warn(message, (Object)StructuredArguments.f(data));
    }

    @Override
    public void error(T data, String message) {
        if (!this.logger.isErrorEnabled()) {
            return;
        }
        this.logger.error(message, (Object)StructuredArguments.f(data));
    }

    static <M extends Message> ProtobufStructuredLogger<M> of(String loggerName) {
        return new ProtobufStructuredLogger(LoggerFactory.getLogger(loggerName));
    }
}

