/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.common.logging;

import com.dremio.jdbc.shaded.com.dremio.common.logging.ProtobufStructuredLogger;
import com.dremio.jdbc.shaded.com.google.protobuf.Message;
import java.util.function.Function;

public interface StructuredLogger<T> {
    public void info(T var1, String var2);

    public void debug(T var1, String var2);

    public void warn(T var1, String var2);

    public void error(T var1, String var2);

    public void info(T var1, String var2, Object ... var3);

    public void debug(T var1, String var2, Object ... var3);

    public void warn(T var1, String var2, Object ... var3);

    public void error(T var1, String var2, Object ... var3);

    public static <V extends Message> StructuredLogger<V> get(Class<V> clazz, String loggerName) {
        return ProtobufStructuredLogger.of(loggerName);
    }

    public static <V extends Message> StructuredLogger<V> get(Class<V> clazz, Class<?> loggerClass) {
        return StructuredLogger.get(clazz, loggerClass.getName());
    }

    default public <U> StructuredLogger<U> compose(Function<? super U, ? extends T> mapper) {
        return new ComposedStructuredLogger<U, T>(this, mapper);
    }

    public static final class ComposedStructuredLogger<T, R>
    implements StructuredLogger<T> {
        private final StructuredLogger<R> parentLogger;
        private final Function<? super T, ? extends R> mapper;

        public ComposedStructuredLogger(StructuredLogger<R> parentLogger, Function<? super T, ? extends R> mapper) {
            this.parentLogger = parentLogger;
            this.mapper = mapper;
        }

        @Override
        public void info(T data, String message) {
            this.parentLogger.info(this.mapper.apply(data), message);
        }

        @Override
        public void debug(T data, String message) {
            this.parentLogger.debug(this.mapper.apply(data), message);
        }

        @Override
        public void warn(T data, String message) {
            this.parentLogger.warn(this.mapper.apply(data), message);
        }

        @Override
        public void error(T data, String message) {
            this.parentLogger.error(this.mapper.apply(data), message);
        }

        @Override
        public void info(T data, String message, Object ... args) {
            this.parentLogger.info(this.mapper.apply(data), message, args);
        }

        @Override
        public void debug(T data, String message, Object ... args) {
            this.parentLogger.debug(this.mapper.apply(data), message, args);
        }

        @Override
        public void warn(T data, String message, Object ... args) {
            this.parentLogger.warn(this.mapper.apply(data), message, args);
        }

        @Override
        public void error(T data, String message, Object ... args) {
            this.parentLogger.error(this.mapper.apply(data), message, args);
        }
    }

    public static final class TeeStructuredLogger<T>
    implements StructuredLogger<T> {
        private final StructuredLogger<T> first;
        private final StructuredLogger<T> second;

        public TeeStructuredLogger(StructuredLogger<T> firstLogger, StructuredLogger<T> secondLogger) {
            this.first = firstLogger;
            this.second = secondLogger;
        }

        @Override
        public void info(T data, String message) {
            this.first.info(data, message);
            this.second.info(data, message);
        }

        @Override
        public void debug(T data, String message) {
            this.first.debug(data, message);
            this.second.debug(data, message);
        }

        @Override
        public void warn(T data, String message) {
            this.first.warn(data, message);
            this.second.warn(data, message);
        }

        @Override
        public void error(T data, String message) {
            this.first.error(data, message);
            this.second.error(data, message);
        }

        @Override
        public void info(T data, String message, Object ... args) {
            this.first.info(data, message, args);
            this.second.info(data, message, args);
        }

        @Override
        public void debug(T data, String message, Object ... args) {
            this.first.debug(data, message, args);
            this.second.debug(data, message, args);
        }

        @Override
        public void warn(T data, String message, Object ... args) {
            this.first.warn(data, message, args);
            this.second.warn(data, message, args);
        }

        @Override
        public void error(T data, String message, Object ... args) {
            this.first.error(data, message, args);
            this.second.error(data, message, args);
        }
    }
}

