/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.common.logging.obfuscation;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.turbo.TurboFilter;
import ch.qos.logback.core.spi.FilterReply;
import com.dremio.jdbc.shaded.org.slf4j.Marker;
import java.util.ArrayList;
import java.util.List;

public class BlockLogLevelTurboFilter
extends TurboFilter {
    private List<String[]> packageThresholdLevel = new ArrayList<String[]>();
    private Level defaultLogLevelThreshold;
    private boolean start = false;

    private boolean matches(String classPath, String logger) {
        int i;
        for (i = 0; i < classPath.length(); ++i) {
            if (logger.charAt(i) == classPath.charAt(i)) continue;
            return false;
        }
        if (i == logger.length()) {
            return true;
        }
        return logger.charAt(i) == '.';
    }

    public FilterReply decide(Marker marker, Logger logger, Level level, String s2, Object[] objects, Throwable throwable) {
        int maximumMatchingPackageLength = 0;
        String[] longestMatchingPackageThreshold = new String[]{"defaultLog", this.defaultLogLevelThreshold.levelStr};
        for (int i = 0; i < this.packageThresholdLevel.size(); ++i) {
            if (!this.matches(this.packageThresholdLevel.get(i)[0], logger.getName()) || this.packageThresholdLevel.get(i)[0].length() <= maximumMatchingPackageLength) continue;
            longestMatchingPackageThreshold = this.packageThresholdLevel.get(i);
            maximumMatchingPackageLength = this.packageThresholdLevel.get(i)[0].length();
        }
        if (!level.isGreaterOrEqual(Level.toLevel((String)longestMatchingPackageThreshold[1]))) {
            return FilterReply.DENY;
        }
        return FilterReply.NEUTRAL;
    }

    public void addPackageLogLevel(String packageLogLevel) {
        String[] arrOfStr = packageLogLevel.split(",");
        this.packageThresholdLevel.add(arrOfStr);
    }

    public void setDefaultLogLevelThreshold(String defaultLogLevelThreshold) {
        this.defaultLogLevelThreshold = Level.toLevel((String)defaultLogLevelThreshold);
    }

    public void stop() {
        this.start = false;
    }

    public void start() {
        if (this.defaultLogLevelThreshold != null) {
            super.start();
            this.start = true;
        }
    }
}

