/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.jdbc.shaded.com.dremio.common.memory;

import com.dremio.jdbc.shaded.org.apache.arrow.memory.AllocationListener;
import com.dremio.jdbc.shaded.org.apache.arrow.memory.AllocationOutcome;
import com.dremio.jdbc.shaded.org.apache.arrow.memory.ArrowBuf;
import com.dremio.jdbc.shaded.org.apache.arrow.memory.BufferAllocator;
import com.dremio.jdbc.shaded.org.apache.arrow.memory.BufferManager;
import com.dremio.jdbc.shaded.org.apache.arrow.memory.OutOfMemoryException;
import com.dremio.jdbc.shaded.org.apache.arrow.memory.RootAllocator;
import com.dremio.jdbc.shaded.org.slf4j.Logger;
import com.dremio.jdbc.shaded.org.slf4j.LoggerFactory;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;

public final class DremioRootAllocator
extends RootAllocator {
    private static final Logger logger = LoggerFactory.getLogger(DremioRootAllocator.class);
    private final ConcurrentMap<String, BufferAllocator> children = new ConcurrentHashMap<String, BufferAllocator>();
    private RootAllocatorListener listener;

    public static DremioRootAllocator create(long limit, long maxBufferCount) {
        RootAllocatorListener listener = new RootAllocatorListener(maxBufferCount);
        DremioRootAllocator rootAllocator = new DremioRootAllocator(listener, limit);
        listener.setRootAllocator(rootAllocator);
        return rootAllocator;
    }

    public long getAvailableBuffers() {
        return this.listener.getAvailableBuffers();
    }

    public long getMaxBufferCount() {
        return this.listener.getMaxBufferCount();
    }

    private DremioRootAllocator(RootAllocatorListener listener, long limit) {
        super(listener, limit);
        this.listener = listener;
    }

    @Override
    public ArrowBuf buffer(long initialRequestSize) {
        throw new UnsupportedOperationException("Dremio's root allocator should not be used for direct allocations");
    }

    @Override
    public ArrowBuf buffer(long initialRequestSize, BufferManager manager) {
        throw new UnsupportedOperationException("Dremio's root allocator should not be used for direct allocations");
    }

    private static final class RootAllocatorListener
    implements AllocationListener {
        private final AtomicLong availBuffers;
        private final long maxBufferCount;
        private DremioRootAllocator rootAllocator;

        public RootAllocatorListener(long maxCount) {
            this.availBuffers = new AtomicLong(maxCount);
            this.maxBufferCount = maxCount;
        }

        void setRootAllocator(DremioRootAllocator rootAllocator) {
            this.rootAllocator = rootAllocator;
        }

        public long getAvailableBuffers() {
            return this.availBuffers.get();
        }

        public long getMaxBufferCount() {
            return this.maxBufferCount;
        }

        @Override
        public void onPreAllocation(long size) {
            if (this.availBuffers.get() < 1L) {
                throw new OutOfMemoryException(String.format("Buffer count (%d) exceeds maximum (%d).", this.availBuffers.get(), this.maxBufferCount));
            }
        }

        @Override
        public void onAllocation(long size) {
            this.availBuffers.decrementAndGet();
        }

        @Override
        public void onRelease(long size) {
            this.availBuffers.incrementAndGet();
        }

        @Override
        public boolean onFailedAllocation(long size, AllocationOutcome outcome) {
            return false;
        }

        @Override
        public void onChildAdded(BufferAllocator parentAllocator, BufferAllocator childAllocator) {
            if (parentAllocator == this.rootAllocator) {
                this.rootAllocator.children.put(childAllocator.getName(), childAllocator);
            }
        }

        @Override
        public void onChildRemoved(BufferAllocator parentAllocator, BufferAllocator childAllocator) {
            if (parentAllocator == this.rootAllocator) {
                this.rootAllocator.children.remove(childAllocator.getName(), childAllocator);
            }
        }
    }
}

